/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.institution;

import gov.va.med.environment.Environment;
import gov.va.med.environment.ServerType;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionFactory;
import gov.va.med.vistalink.adapter.spi.ConfigurationReader;
import gov.va.med.vistalink.institution.IPrimaryStationRules;
import gov.va.med.vistalink.institution.InstitutionMappingBadStationNumberException;
import gov.va.med.vistalink.institution.InstitutionMappingNotFoundException;
import gov.va.med.vistalink.institution.InstitutionMappingVO;
import gov.va.med.vistalink.institution.PrimaryStationRulesFactory;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.naming.InitialContext;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class InstitutionMapping {
    private static final Logger logger = Logger.getLogger(InstitutionMapping.class);
    private static IPrimaryStationRules primaryStationRules;
    private TreeMap institutionMap;
    private Object syncObjMapping = new Object();

    public InstitutionMapping() {
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.debug((Object)"InstitutionMapping :: In constructor.");
        }
        this.institutionMap = new TreeMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMappingsForJndiName(String mcfJndiName, String[] mcfStationNumbers, long mcfDistinguishedIdentifier) throws InstitutionMappingBadStationNumberException {
        for (int i = 0; i < mcfStationNumbers.length; ++i) {
            primaryStationRules.validatePrimaryStation(mcfStationNumbers[i]);
        }
        Object object = this.syncObjMapping;
        synchronized (object) {
            String mappingJndiName;
            Set keySet = this.institutionMap.keySet();
            Iterator iter = keySet.iterator();
            while (iter.hasNext()) {
                String mappingStationNumber = (String)iter.next();
                mappingJndiName = ((InstitutionMappingVO)this.institutionMap.get(mappingStationNumber)).getJndiName();
                if (!mcfJndiName.equals(mappingJndiName)) continue;
                boolean stationMatch = false;
                for (int i = 0; i < mcfStationNumbers.length; ++i) {
                    if (!mcfStationNumbers[i].equals(mappingStationNumber)) continue;
                    stationMatch = true;
                }
                if (stationMatch) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("removing mapping of station number '" + mappingStationNumber + "' to JNDI name '" + mcfJndiName + "'."));
                }
                iter.remove();
            }
            for (int i = 0; i < mcfStationNumbers.length; ++i) {
                logger.debug((Object)("considering station#: " + mcfStationNumbers[i]));
                if (!this.institutionMap.containsKey(mcfStationNumbers[i])) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("adding mapping for JNDI name '" + mcfJndiName + "' to station number '" + mcfStationNumbers[i] + "'."));
                    }
                    this.institutionMap.put(mcfStationNumbers[i], new InstitutionMappingVO(mcfJndiName, mcfDistinguishedIdentifier));
                    continue;
                }
                InstitutionMappingVO foundMapping = (InstitutionMappingVO)this.institutionMap.get(mcfStationNumbers[i]);
                mappingJndiName = foundMapping.getJndiName();
                if (mappingJndiName.equals(mcfJndiName)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Institution mapping contains station number: " + mcfStationNumbers[i] + "and the JNDI names are equal. Updating the last MCF distinguished identifier for mapping."));
                    }
                    foundMapping.setLastOneInMcfDistinguishedIdentifier(mcfDistinguishedIdentifier);
                    continue;
                }
                if (!mappingJndiName.equals(mcfJndiName)) {
                    logger.warn((Object)("Existing station mapping found for station '" + mcfStationNumbers[i] + "' mapped to JNDI name '" + mappingJndiName + "'. Replacing with new mapping to JNDI name '" + mcfJndiName + "'."));
                }
                foundMapping.setJndiName(mcfJndiName);
                foundMapping.setLastOneInMcfDistinguishedIdentifier(mcfDistinguishedIdentifier);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMappingsForJndiName(String mcfJndiName, String[] mcfStationNumbers, long mcfDistinguishedIdentifier) {
        Object object = this.syncObjMapping;
        synchronized (object) {
            for (int i = 0; i < mcfStationNumbers.length; ++i) {
                InstitutionMappingVO imVO;
                logger.debug((Object)("considering removing station # " + mcfStationNumbers[i]));
                if (!this.institutionMap.containsKey(mcfStationNumbers[i]) || !(imVO = (InstitutionMappingVO)this.institutionMap.get(mcfStationNumbers[i])).getJndiName().equals(mcfJndiName) || imVO.getLastOneInMcfDistinguishedIdentifier() != mcfDistinguishedIdentifier) continue;
                this.institutionMap.remove(mcfStationNumbers[i]);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Removed mapping for station #'" + mcfStationNumbers[i] + "', JNDI name '" + mcfJndiName + "'."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getJndiConnectorNameForInstitution(String stationNumber) throws InstitutionMappingNotFoundException, InstitutionMappingBadStationNumberException {
        InstitutionMappingVO imuVO = null;
        String primaryStationLookupStr = primaryStationRules.getPrimaryStationLookupString(stationNumber);
        Object object = this.syncObjMapping;
        synchronized (object) {
            imuVO = (InstitutionMappingVO)this.institutionMap.get(primaryStationLookupStr);
        }
        if (imuVO == null && ServerType.WEBSPHERE.equals(Environment.getServerType())) {
            try {
                String jndiName = ConfigurationReader.getJndiNameForStationNumber(primaryStationLookupStr);
                logger.debug((Object)("Attempting to force load of connection factory into JNDI for WebSphere, for JNDI name: " + jndiName));
                InitialContext ic = new InitialContext();
                VistaLinkConnectionFactory cf = (VistaLinkConnectionFactory)ic.lookup(jndiName);
                Object object2 = this.syncObjMapping;
                synchronized (object2) {
                    imuVO = (InstitutionMappingVO)this.institutionMap.get(primaryStationLookupStr);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (imuVO == null) {
            throw new InstitutionMappingNotFoundException("Could not match stationNumber '" + stationNumber + "' to an institution mapping.");
        }
        return imuVO.getJndiName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getMappingClone() {
        TreeMap clone = null;
        Object object = this.syncObjMapping;
        synchronized (object) {
            clone = (TreeMap)this.institutionMap.clone();
        }
        return clone;
    }

    Set getVistaLinkMappedStationNumberSet() {
        return Collections.unmodifiableSet(this.getMappingClone().keySet());
    }

    static {
        try {
            primaryStationRules = PrimaryStationRulesFactory.getPrimaryStationRulesImplementation();
        }
        catch (InstantiationException e) {
            logger.error((Object)"Could not get primary station rules implementation: ", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"Could not get primary station rules implementation: ", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"Could not get primary station rules implementation: ", (Throwable)e);
        }
    }
}

