/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.adapter.spi;

import gov.va.med.exception.ExceptionUtils;
import gov.va.med.vistalink.adapter.cci.VistaLinkResourceException;
import gov.va.med.vistalink.adapter.spi.VistaLinkManagedConnectionEventListener;
import java.io.Serializable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class VistaLinkConnectionManager
implements ConnectionManager,
Serializable {
    transient VistaLinkManagedConnectionEventListener eventListener;
    private static final Logger logger = Logger.getLogger(VistaLinkConnectionManager.class);

    public VistaLinkConnectionManager() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Constructing");
        }
        this.eventListener = new VistaLinkManagedConnectionEventListener();
    }

    public Object allocateConnection(ManagedConnectionFactory managedConnFactory, ConnectionRequestInfo info) throws ResourceException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"allocating connection");
            }
            ManagedConnection managedConn = managedConnFactory.createManagedConnection(null, info);
            managedConn.addConnectionEventListener((ConnectionEventListener)this.eventListener);
            return managedConn.getConnection(null, info);
        }
        catch (VistaLinkResourceException e) {
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                String errMsg = new StringBuffer().append("VistaLinkResourceException attempting to allocate connection.").append("\n\t").append(ExceptionUtils.getFullStackTrace((Throwable)((Object)e))).toString();
                logger.error((Object)errMsg);
            }
            throw e;
        }
    }
}

