/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.adapter.spi;

public class EMAdapterStatus {
    private final int adapterStatus;
    private final String adapterStatusStringValue;
    private static final int INT_CONSTRUCTING = 1;
    private static final int INT_DESTRUCTING = 2;
    private static final int INT_CLEANUP = 3;
    private static final int INT_RUNNING = 0;
    private static final String STRING_CONSTRUCTING = "constructing";
    private static final String STRING_DESTRUCTING = "destructing";
    private static final String STRING_CLEANUP = "cleanup";
    private static final String STRING_RUNNING = "running";
    public static final EMAdapterStatus CONSTRUCTING = new EMAdapterStatus(1);
    public static final EMAdapterStatus DESTROYING = new EMAdapterStatus(2);
    public static final EMAdapterStatus CLEANUP = new EMAdapterStatus(3);
    public static final EMAdapterStatus RUNNING = new EMAdapterStatus(0);

    private EMAdapterStatus(int adapterStatus) {
        this.adapterStatus = adapterStatus;
        String stringAdapterStatus = null;
        switch (adapterStatus) {
            case 1: {
                stringAdapterStatus = STRING_CONSTRUCTING;
                break;
            }
            case 2: {
                stringAdapterStatus = STRING_DESTRUCTING;
                break;
            }
            case 3: {
                stringAdapterStatus = STRING_CLEANUP;
                break;
            }
            case 0: {
                stringAdapterStatus = STRING_RUNNING;
                break;
            }
            default: {
                stringAdapterStatus = null;
            }
        }
        this.adapterStatusStringValue = stringAdapterStatus;
    }

    private int getValue() {
        return this.adapterStatus;
    }

    public String toString() {
        return this.adapterStatusStringValue;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EMAdapterStatus) {
            return ((EMAdapterStatus)obj).getValue() == this.getValue();
        }
        return false;
    }

    public int hashCode() {
        int HASHCODE_SEED;
        int returnVal = HASHCODE_SEED = 17;
        int valueHashCode = this.getValue();
        returnVal = 37 * returnVal + valueHashCode;
        return returnVal;
    }
}

