/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.adapter.heartbeat;

import gov.va.med.exception.ExceptionUtils;
import gov.va.med.exception.FoundationsException;
import gov.va.med.vistalink.adapter.heartbeat.VistaHeartBeatTimerResponse;
import gov.va.med.vistalink.adapter.record.VistaLinkRequestVO;
import gov.va.med.vistalink.adapter.record.VistaLinkResponseFactoryImpl;
import gov.va.med.vistalink.adapter.record.VistaLinkResponseVO;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VistaHeartBeatTimerResponseFactory
extends VistaLinkResponseFactoryImpl {
    private static final Logger logger = Logger.getLogger(VistaHeartBeatTimerResponseFactory.class);

    protected VistaLinkResponseVO parseMessageBody(String rawXml, String filteredXml, Document doc, String messageType, VistaLinkRequestVO requestVO) throws FoundationsException {
        try {
            boolean heartBeatSuccessful;
            long heartBeatRateMillis = 0L;
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList resultsNodeList = (NodeList)xpath.evaluate("/VistaLink/Response/.", doc, XPathConstants.NODESET);
            Node resultsNode = resultsNodeList.getLength() > 0 ? resultsNodeList.item(0) : null;
            NamedNodeMap attrs = resultsNode.getAttributes();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"got response attributes");
            }
            boolean bl = heartBeatSuccessful = ((Attr)attrs.getNamedItem("type")).getValue().equals("heartbeat") && ((Attr)attrs.getNamedItem("status")).getValue().equals("success");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"got heart beat success");
            }
            heartBeatRateMillis = 1000L * Long.parseLong(((Attr)attrs.getNamedItem("rate")).getValue());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"got heart beat rate millis");
            }
            return new VistaHeartBeatTimerResponse(rawXml, filteredXml, doc, messageType, heartBeatSuccessful, heartBeatRateMillis);
        }
        catch (XPathExpressionException e) {
            String errStr = "could not parse xml";
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                String errMsg = new StringBuffer().append(errStr).append("\n\t").append(ExceptionUtils.getFullStackTrace((Throwable)e)).toString();
                logger.error((Object)errMsg);
            }
            throw new FoundationsException(errStr, (Throwable)e);
        }
    }
}

