/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.adapter.heartbeat;

import gov.va.med.vistalink.adapter.heartbeat.HeartBeatInitializationFailedException;
import gov.va.med.vistalink.adapter.heartbeat.VistaHeartbeatTimerTask;
import gov.va.med.vistalink.adapter.spi.EMAdapterEnvironment;
import gov.va.med.vistalink.adapter.spi.VistaLinkManagedConnection;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class VistaHeartBeatTimerManager {
    private VistaHeartbeatTimerTask timerTask;
    private Timer heartBeatTimer;
    private long heartBeatRate = 10000L;
    private boolean heartBeatActive;
    private boolean retrievedHeartBeatRate;
    private boolean constructedTimerTask;
    private EMAdapterEnvironment adapterEnvironment;
    private static final Logger logger = Logger.getLogger(VistaHeartBeatTimerManager.class);

    public VistaHeartBeatTimerManager() {
        this.setHeartBeatActive(false);
        this.setRetrievedHeartBeatRate(false);
        this.setConstructedTimerTask(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addManagedConnection(VistaLinkManagedConnection mc, long heartBeatRate) throws HeartBeatInitializationFailedException {
        VistaHeartBeatTimerManager vistaHeartBeatTimerManager = this;
        synchronized (vistaHeartBeatTimerManager) {
            if (!this.hasConstructedTimerTask()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Constructing timer task");
                }
                this.constructTimerTask();
            }
            if (!this.hasRetrievedHeartBeatRate()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"setting heartbeat rate");
                }
                this.setHeartBeatRate(heartBeatRate);
            }
            if (this.getAdapterEnvironment().equals(EMAdapterEnvironment.J2EE)) {
                return;
            }
            this.timerTask.addManagedConnection(mc);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Managed connection added for J2SE");
            }
            if (!this.isHeartBeatActive()) {
                this.startTimer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeManagedConnection(VistaLinkManagedConnection mc) {
        if (this.getAdapterEnvironment().equals(EMAdapterEnvironment.J2EE)) {
            return;
        }
        VistaHeartBeatTimerManager vistaHeartBeatTimerManager = this;
        synchronized (vistaHeartBeatTimerManager) {
            if (this.timerTask != null) {
                this.timerTask.removeManagedConnection(mc);
                logger.debug((Object)"Removed managed connection");
                if (this.timerTask.isManagedConnectionListEmpty()) {
                    logger.debug((Object)"cancelling timer");
                    this.cancelTimer();
                }
            }
        }
    }

    private void startTimer() {
        if (!this.isHeartBeatActive()) {
            this.heartBeatTimer = null;
            this.heartBeatTimer = new Timer(true);
            this.heartBeatTimer.schedule((TimerTask)this.timerTask, this.getHeartBeatRate(), this.getHeartBeatRate());
            this.setHeartBeatActive(true);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Timer started");
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"Timer is already running");
        }
    }

    private void cancelTimer() {
        this.heartBeatTimer.cancel();
        this.setHeartBeatActive(false);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Timer cancelled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHeartBeatActive() {
        VistaHeartBeatTimerManager vistaHeartBeatTimerManager = this;
        synchronized (vistaHeartBeatTimerManager) {
            return this.heartBeatActive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHeartBeatRate() {
        VistaHeartBeatTimerManager vistaHeartBeatTimerManager = this;
        synchronized (vistaHeartBeatTimerManager) {
            return this.heartBeatRate;
        }
    }

    private void setHeartBeatActive(boolean heartBeatActive) {
        this.heartBeatActive = heartBeatActive;
    }

    private void setHeartBeatRate(long heartBeatRate) {
        this.heartBeatRate = heartBeatRate;
        this.setRetrievedHeartBeatRate(true);
    }

    public EMAdapterEnvironment getAdapterEnvironment() {
        return this.adapterEnvironment;
    }

    public void setAdapterEnvironment(EMAdapterEnvironment environment) {
        this.adapterEnvironment = environment;
    }

    private boolean hasRetrievedHeartBeatRate() {
        return this.retrievedHeartBeatRate;
    }

    private void setRetrievedHeartBeatRate(boolean b) {
        this.retrievedHeartBeatRate = b;
    }

    private void constructTimerTask() {
        this.timerTask = new VistaHeartbeatTimerTask(this.adapterEnvironment);
        this.setConstructedTimerTask(true);
    }

    public boolean hasConstructedTimerTask() {
        return this.constructedTimerTask;
    }

    public final void setConstructedTimerTask(boolean b) {
        this.constructedTimerTask = b;
    }
}

