/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.console;

import gov.va.med.vistalink.console.IServerHelper;
import gov.va.med.vistalink.console.ServerHelperAbstract;
import gov.va.med.vistalink.console.ServerHelperException;
import gov.va.med.vistalink.console.ServerHelperNotRunningException;
import gov.va.med.vistalink.jmx.IJmxHelper;
import gov.va.med.vistalink.jmx.JmxHelperException;
import gov.va.med.vistalink.jmx.JmxHelperFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.Logger;
import weblogic.management.NoAccessRuntimeException;

public final class ServerHelperWebLogic
extends ServerHelperAbstract
implements Comparable,
IServerHelper {
    private static final Logger logger = Logger.getLogger(ServerHelperWebLogic.class);
    private static final String OBJECT_NAME_STRING_TYPE = "Type";
    private static final String OBJECT_NAME_STRING_NAME = "Name";
    private static final String JMX_REMOTE_PROTOCOL = "t3";
    private static final String JMX_JNDI_ROOT = "/jndi/";
    private static final String JMX_DOMAIN_RUNTIME_MBEANSERVER = "weblogic.management.mbeanservers.domainruntime";
    private static final String DOMAIN_RUNTIME_SERVICE_MBEAN_ONAME = "com.bea:Name=DomainRuntimeService,Type=weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean";
    private static final String JMX_PROTOCOL_PREFIX = "service:jmx:";
    private static final String JMX_CONNECTOR_PACKAGE = "weblogic.management.remote";
    private static final String TXT_EXPECT_1_RESULT = "Expected 1 result for local server query, got: ";
    private static final String TXT_NO_RETR_LOC_SRV = "Could not retrieve local server name: ";
    private static final String TXT_NO_RETR_JMX_URL = "Could not retrieve JMX URL for server ";
    private String serverName = null;
    private String locationDisplayName = "";
    private boolean isLocalServer = false;
    private boolean isLocalServerChecked = false;
    private String jmxUrl = null;
    private boolean isJmxUrlServerRuntimeValidated = false;

    protected ServerHelperWebLogic() {
        this.init(true);
        logger.debug((Object)("Constructed WebLogic Server Helper: " + this.toString()));
    }

    protected ServerHelperWebLogic(String objectNameFragment) {
        super(objectNameFragment);
        this.init(false);
        logger.debug((Object)("Constructed WebLogic Server Helper: " + this.toString()));
    }

    private void init(boolean localServerNoArgConstructor) {
        if (localServerNoArgConstructor) {
            this.isLocalServer = true;
            this.isLocalServerChecked = true;
            try {
                this.serverName = this.getLocalServerName();
            }
            catch (ServerHelperException serverHelperException) {}
        } else if (super.keyPropertiesContainKey(OBJECT_NAME_STRING_NAME)) {
            this.serverName = super.keyPropertiesGetValue(OBJECT_NAME_STRING_NAME);
        } else {
            logger.error((Object)"Could not construct IServerHelper for WebLogic, missing 'Name' key.");
        }
        if (this.serverName != null) {
            this.locationDisplayName = this.serverName;
        }
    }

    public String getServerHelperConstructorProperties() {
        return "Name=" + this.getServerName();
    }

    public synchronized String getDisplayNameFullyLocationQualified() {
        return this.locationDisplayName;
    }

    public JMXConnector getJmxConnector() throws ServerHelperNotRunningException, ServerHelperException, IOException {
        logger.debug((Object)("Getting JMX Connector for server: " + this.getServerName()));
        JMXConnector returnVal = null;
        try {
            String baseURL = this.getJmxRemoteUrlBase();
            if (baseURL == null) {
                throw new IOException("Could not determine host address for server '" + this.getServerName() + "'");
            }
            JMXServiceURL serviceURL = new JMXServiceURL(JMX_PROTOCOL_PREFIX + baseURL + "/jndi/weblogic.management.mbeanservers.runtime");
            Hashtable<String, String> h = new Hashtable<String, String>();
            h.put("jmx.remote.protocol.provider.pkgs", JMX_CONNECTOR_PACKAGE);
            returnVal = JMXConnectorFactory.connect(serviceURL, h);
        }
        catch (MalformedURLException e) {
            logger.error((Object)"Could not retrieve JMX Connector: ", (Throwable)e);
            throw new ServerHelperException("Could not retrieve JMX Connector: " + e.getMessage(), e);
        }
        return returnVal;
    }

    private String getJmxRemoteUrlBase() throws ServerHelperNotRunningException, ServerHelperException {
        if (this.getJmxUrl() == null || !this.isJmxUrlServerRuntimeValidated()) {
            try {
                IJmxHelper jmxHelper = JmxHelperFactory.getJmxHelper();
                MBeanServer localMBeanServer = jmxHelper.getLocalMBeanServer();
                String jmxDomainForPlatform = jmxHelper.getJmxDomainForPlatform();
                try {
                    if (!this.isJmxUrlServerRuntimeValidated()) {
                        this.initUrlFromServerRuntimeMBean(localMBeanServer, jmxDomainForPlatform);
                    }
                    if (!this.isJmxUrlServerRuntimeValidated()) {
                        this.initUrlFromConfigMBean(localMBeanServer, jmxDomainForPlatform);
                    }
                }
                catch (NoAccessRuntimeException e1) {
                    logger.warn((Object)("No access rights to make JMX call: " + e1.getMessage()));
                    this.initUrlFromConfigMBean(localMBeanServer, jmxDomainForPlatform);
                }
            }
            catch (JmxHelperException e) {
                logger.error((Object)(TXT_NO_RETR_JMX_URL + this.getServerName() + ": "), (Throwable)e);
                throw new ServerHelperException(TXT_NO_RETR_JMX_URL + this.getServerName() + ": ", e);
            }
        }
        return this.getJmxUrl();
    }

    private void initUrlFromServerRuntimeMBean(MBeanServer localMBeanServer, String jmxDomainForPlatform) throws ServerHelperNotRunningException, ServerHelperException {
        String adminServerHost = null;
        Integer adminServerListenPort = null;
        try {
            ObjectName oNamePartial = new ObjectName(jmxDomainForPlatform + ":" + OBJECT_NAME_STRING_TYPE + "=ServerRuntime,*");
            Set<ObjectName> queryResults = localMBeanServer.queryNames(oNamePartial, null);
            if (queryResults.size() != 1) {
                logger.error((Object)(TXT_EXPECT_1_RESULT + queryResults.size()));
            } else {
                ObjectName serverObjectName = queryResults.iterator().next();
                adminServerHost = (String)localMBeanServer.getAttribute(serverObjectName, "AdminServerHost");
                adminServerListenPort = (Integer)localMBeanServer.getAttribute(serverObjectName, "AdminServerListenPort");
            }
            JMXServiceURL serviceURL = new JMXServiceURL(JMX_REMOTE_PROTOCOL, adminServerHost, adminServerListenPort, "/jndi/weblogic.management.mbeanservers.domainruntime");
            logger.debug((Object)("about to make JMX Remote call on URL: " + serviceURL));
            Hashtable<String, String> h = new Hashtable<String, String>();
            h.put("jmx.remote.protocol.provider.pkgs", JMX_CONNECTOR_PACKAGE);
            JMXConnector adminConnector = JMXConnectorFactory.connect(serviceURL, h);
            MBeanServerConnection adminConnection = adminConnector.getMBeanServerConnection();
            ObjectName drsOName = new ObjectName(DOMAIN_RUNTIME_SERVICE_MBEAN_ONAME);
            logger.debug((Object)("checking URL for server: " + this.getServerName()));
            ObjectName serverRuntimeMBean = (ObjectName)adminConnection.invoke(drsOName, "lookupServerRuntime", new Object[]{this.getServerName()}, new String[]{"java.lang.String"});
            if (serverRuntimeMBean == null) {
                logger.debug((Object)"ServerRuntime MBean was null, but no InstanceNotFoundException was thrown.");
                throw new ServerHelperNotRunningException("Does not appear that server " + this.getServerName() + " is running.");
            }
            String UrlString = (String)adminConnection.invoke(serverRuntimeMBean, "getURL", new Object[]{JMX_REMOTE_PROTOCOL}, new String[]{"java.lang.String"});
            this.setJmxUrl(UrlString);
            this.setJmxUrlServerRuntimeValidated(true);
            logger.debug((Object)("set ServerHelper [" + this.getServerName() + "]'s JMX URL from ServerRuntime MBean, to: " + UrlString));
        }
        catch (MalformedObjectNameException e) {
            logger.error((Object)(TXT_NO_RETR_JMX_URL + this.getServerName() + ": "), (Throwable)e);
        }
        catch (NullPointerException e) {
            logger.error((Object)(TXT_NO_RETR_JMX_URL + this.getServerName() + ": "), (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            logger.debug((Object)(TXT_NO_RETR_JMX_URL + this.getServerName() + ": "), (Throwable)e);
            throw new ServerHelperNotRunningException("Does not appear that server " + this.getServerName() + " is running: ", e);
        }
        catch (AttributeNotFoundException e) {
            logger.error((Object)(TXT_NO_RETR_JMX_URL + this.getServerName() + ": "), (Throwable)e);
        }
        catch (MBeanException e) {
            logger.error((Object)(TXT_NO_RETR_JMX_URL + this.getServerName() + ": "), (Throwable)e);
        }
        catch (ReflectionException e) {
            logger.error((Object)(TXT_NO_RETR_JMX_URL + this.getServerName() + ": "), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)(TXT_NO_RETR_JMX_URL + this.getServerName() + ": "), (Throwable)e);
        }
    }

    private void initUrlFromConfigMBean(MBeanServer localMBeanServer, String jmxDomainForPlatform) throws ServerHelperException {
        try {
            StringBuffer sb = new StringBuffer(jmxDomainForPlatform).append(":");
            sb.append(OBJECT_NAME_STRING_TYPE).append("=Server,");
            sb.append(OBJECT_NAME_STRING_NAME).append("=").append(this.getServerName());
            sb.append(",*");
            ObjectName serverQuery = new ObjectName(sb.toString());
            Set<ObjectName> queryResults = localMBeanServer.queryNames(serverQuery, null);
            if (queryResults.size() != 1) {
                logger.error((Object)(TXT_EXPECT_1_RESULT + queryResults.size()));
                throw new ServerHelperException("Could not get local server information.");
            }
            ObjectName serverObjectName = queryResults.iterator().next();
            Integer jmxPort = (Integer)localMBeanServer.getAttribute(serverObjectName, "ListenPort");
            String jmxHostname = (String)localMBeanServer.getAttribute(serverObjectName, "ListenAddress");
            if (jmxHostname == null || jmxHostname.trim().length() <= 0) {
                logger.warn((Object)("ListenAddress and/or ListenPort not configured for server '" + this.getServerName() + "'"));
                throw new ServerHelperException("ListenAddress and/or ListenPort not configured for server '" + this.getServerName() + "'");
            }
            String urlVal = "t3://" + jmxHostname + ":" + jmxPort.toString();
            this.setJmxUrl(urlVal);
            logger.debug((Object)("set ServerHelper [" + this.getServerName() + "]'s JMX URL from Server Config MBean, to: " + urlVal));
        }
        catch (MalformedObjectNameException e) {
            logger.error((Object)(TXT_NO_RETR_JMX_URL + this.getServerName() + ": "), (Throwable)e);
        }
        catch (AttributeNotFoundException e) {
            logger.error((Object)(TXT_NO_RETR_JMX_URL + this.getServerName() + ": "), (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            logger.error((Object)(TXT_NO_RETR_JMX_URL + this.getServerName() + ": "), (Throwable)e);
        }
        catch (NullPointerException e) {
            logger.error((Object)(TXT_NO_RETR_JMX_URL + this.getServerName() + ": "), (Throwable)e);
        }
        catch (MBeanException e) {
            logger.error((Object)(TXT_NO_RETR_JMX_URL + this.getServerName() + ": "), (Throwable)e);
        }
        catch (ReflectionException e) {
            logger.error((Object)(TXT_NO_RETR_JMX_URL + this.getServerName() + ": "), (Throwable)e);
        }
    }

    private String getLocalServerName() throws ServerHelperException {
        String returnVal = null;
        try {
            IJmxHelper jmxHelper = JmxHelperFactory.getJmxHelper();
            MBeanServer localMBeanServer = jmxHelper.getLocalMBeanServer();
            ObjectName oNamePartial = new ObjectName(jmxHelper.getJmxDomainForPlatform() + ":" + OBJECT_NAME_STRING_TYPE + "=ServerRuntime,*");
            Set<ObjectName> queryResults = localMBeanServer.queryNames(oNamePartial, null);
            if (queryResults.size() != 1) {
                logger.error((Object)(TXT_EXPECT_1_RESULT + queryResults.size()));
                throw new Exception("Could not get local server information.");
            }
            ObjectName serverObjectName = queryResults.iterator().next();
            returnVal = serverObjectName.getKeyProperty(OBJECT_NAME_STRING_NAME);
        }
        catch (MalformedObjectNameException e) {
            logger.error((Object)TXT_NO_RETR_LOC_SRV, (Throwable)e);
            throw new ServerHelperException(TXT_NO_RETR_LOC_SRV, e);
        }
        catch (NullPointerException e) {
            logger.error((Object)TXT_NO_RETR_LOC_SRV, (Throwable)e);
            throw new ServerHelperException(TXT_NO_RETR_LOC_SRV, e);
        }
        catch (JmxHelperException e) {
            logger.error((Object)TXT_NO_RETR_LOC_SRV, (Throwable)e);
            throw new ServerHelperException(TXT_NO_RETR_LOC_SRV, e);
        }
        catch (Exception e) {
            logger.error((Object)TXT_NO_RETR_LOC_SRV, (Throwable)e);
            throw new ServerHelperException(TXT_NO_RETR_LOC_SRV, e);
        }
        return returnVal;
    }

    public boolean isLocalAndAdminServer() throws ServerHelperException {
        Boolean returnVal = Boolean.FALSE;
        if (!this.isLocalServerChecked()) {
            String localServerName = this.getLocalServerName();
            boolean isLocal = this.getServerName().equalsIgnoreCase(localServerName);
            this.setLocalServerChecked(true);
            this.setLocalServer(isLocal);
            logger.debug((Object)("isLocalServer results for server [" + this.getServerName() + "]: " + isLocal));
        }
        if (this.isLocalServer()) {
            try {
                IJmxHelper jmxHelper = JmxHelperFactory.getJmxHelper();
                MBeanServer localMBeanServer = jmxHelper.getLocalMBeanServer();
                ObjectName oNamePartial = new ObjectName(jmxHelper.getJmxDomainForPlatform() + ":" + OBJECT_NAME_STRING_TYPE + "=ServerRuntime,*");
                Set<ObjectName> queryResults = localMBeanServer.queryNames(oNamePartial, null);
                if (queryResults.size() != 1) {
                    logger.error((Object)(TXT_EXPECT_1_RESULT + queryResults.size()));
                    throw new Exception("Could not get local server information.");
                }
                ObjectName serverObjectName = queryResults.iterator().next();
                returnVal = (Boolean)localMBeanServer.getAttribute(serverObjectName, "AdminServer");
            }
            catch (MalformedObjectNameException e) {
                logger.error((Object)"Could not determine if server is local/current server.", (Throwable)e);
                throw new ServerHelperException("Could not determine if server is local/current server.", e);
            }
            catch (NullPointerException e) {
                logger.error((Object)"Could not determine if server is local/current server.", (Throwable)e);
                throw new ServerHelperException("Could not determine if server is local/current server.", e);
            }
            catch (JmxHelperException e) {
                logger.error((Object)"Could not determine if server is local/current server.", (Throwable)e);
                throw new ServerHelperException("Could not determine if server is local/current server.", e);
            }
            catch (Exception e) {
                logger.error((Object)"Could not determine if server is local/current server.", (Throwable)e);
                throw new ServerHelperException("Could not determine if server is local/current server.", e);
            }
        }
        return returnVal;
    }

    private synchronized boolean isLocalServer() {
        return this.isLocalServer;
    }

    private synchronized void setLocalServer(boolean isLocalServer) {
        this.isLocalServer = isLocalServer;
    }

    private synchronized String getServerName() {
        return this.serverName;
    }

    private synchronized boolean isLocalServerChecked() {
        return this.isLocalServerChecked;
    }

    private synchronized void setLocalServerChecked(boolean val) {
        this.isLocalServerChecked = val;
    }

    private synchronized String getJmxUrl() {
        return this.jmxUrl;
    }

    private synchronized void setJmxUrl(String val) {
        this.jmxUrl = val;
    }

    private synchronized boolean isJmxUrlServerRuntimeValidated() {
        return this.isJmxUrlServerRuntimeValidated;
    }

    private synchronized void setJmxUrlServerRuntimeValidated(boolean val) {
        this.isJmxUrlServerRuntimeValidated = val;
    }
}

