/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.console;

import gov.va.med.vistalink.console.IServerHelper;
import gov.va.med.vistalink.jmx.IJmxHelper;
import gov.va.med.vistalink.jmx.JmxHelperFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class ServerHelperAbstract
implements Comparable,
IServerHelper {
    private static final Logger logger = Logger.getLogger(ServerHelperAbstract.class);
    private final Map keyPropertyHm = new HashMap();

    ServerHelperAbstract() {
        IJmxHelper jmxHelper = JmxHelperFactory.getJmxHelper();
        this.init(jmxHelper.getServerObjectNamePropertiesForRegistration());
    }

    ServerHelperAbstract(String objectNameFragment) {
        this.init(objectNameFragment);
    }

    final void init(String objectNameFragment) {
        if (objectNameFragment.trim().length() > 0) {
            logger.debug((Object)("processing objectNameFragment: " + objectNameFragment));
            String[] keyValuePairs = objectNameFragment.trim().split(",");
            for (int i = 0; i < keyValuePairs.length; ++i) {
                String[] keyValuePair = keyValuePairs[i].trim().split("=");
                logger.debug((Object)("found keyValuePair: " + keyValuePair[0] + "=" + keyValuePair[1]));
                if (keyValuePair.length != 2 || keyValuePair[0].length() <= 0 || keyValuePair[1].length() <= 0) continue;
                this.keyPropertyHm.put(keyValuePair[0], keyValuePair[1]);
            }
        }
    }

    public final int compareTo(Object o) {
        int returnVal = 0;
        if (o instanceof IServerHelper) {
            String compareDisplayName = ((IServerHelper)o).getDisplayNameFullyLocationQualified();
            String displayName = this.getDisplayNameFullyLocationQualified();
            returnVal = compareDisplayName == null && displayName == null ? 0 : (compareDisplayName == null ? 1 : (displayName == null ? -1 : displayName.compareTo(compareDisplayName)));
        } else {
            throw new ClassCastException("Expected IServerHelper, found: " + o.getClass().getName());
        }
        return returnVal;
    }

    public final boolean equals(Object obj) {
        boolean returnVal = false;
        if (obj == this) {
            returnVal = true;
        } else if (obj instanceof IServerHelper) {
            returnVal = "".equals(this.getDisplayNameFullyLocationQualified()) || "".equals(((IServerHelper)obj).getDisplayNameFullyLocationQualified()) ? false : this.getDisplayNameFullyLocationQualified().equals(((IServerHelper)obj).getDisplayNameFullyLocationQualified());
        }
        return returnVal;
    }

    public final int hashCode() {
        int result = 17;
        int c = 0;
        String objectNameFragment = this.getDisplayNameFullyLocationQualified();
        if (objectNameFragment != null) {
            c = objectNameFragment.hashCode();
        }
        return 37 * result + c;
    }

    public final String toString() {
        String locationDisplayName = this.getDisplayNameFullyLocationQualified();
        StringBuffer sb = new StringBuffer("DisplayName: '").append(locationDisplayName == null ? "null" : locationDisplayName);
        sb.append("'");
        return sb.toString();
    }

    protected synchronized boolean keyPropertiesContainKey(String key) {
        return this.keyPropertyHm.containsKey(key);
    }

    protected synchronized String keyPropertiesGetValue(String key) {
        return (String)this.keyPropertyHm.get(key);
    }
}

