/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.crypto;

import gov.va.med.crypto.VistaLinkEncrypter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class KeyEncrypter
extends VistaLinkEncrypter {
    static final int UNINITIALIZED = -1;
    protected int ks = -1;

    protected Key generateKey() {
        try {
            return this.getKeyGenerator().generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            this.handleException(e, "generateKey() - NoSuchAlgorithmException!");
            return null;
        }
    }

    protected KeyGenerator getKeyGenerator() throws NoSuchAlgorithmException {
        KeyGenerator gen = null;
        gen = KeyGenerator.getInstance(this.algorithmName);
        if (this.ks != -1) {
            gen.init(this.ks);
        }
        return gen;
    }

    protected void handleException(Exception e, String message) {
        logger.error((Object)message, (Throwable)e);
    }

    protected Cipher getCipher(int opmode) {
        try {
            Cipher result = Cipher.getInstance(this.algorithmName);
            result.init(opmode, this.getKey());
            return result;
        }
        catch (InvalidKeyException e) {
            this.handleException(e, "getCipher() - InvalidKeyException!");
        }
        catch (NoSuchPaddingException e) {
            this.handleException(e, "getCipher() - NoSuchPaddingException!");
        }
        catch (NoSuchAlgorithmException e) {
            this.handleException(e, "getCipher() - NoSuchAlgorithmException!");
        }
        return null;
    }

    public String encrypt(String s) {
        try {
            byte[] encoded = s.getBytes(this.encodingFormat);
            byte[] encr = this.getCipher(1).doFinal(encoded);
            return new BASE64Encoder().encode(encr);
        }
        catch (BadPaddingException e) {
            this.handleException(e, "encrypt() - BadPaddingException!");
        }
        catch (IllegalBlockSizeException e) {
            this.handleException(e, "encrypt() - IllegalBlockSizeException!");
        }
        catch (UnsupportedEncodingException e) {
            this.handleException(e, "encrypt() - UnsupportedEncodingException!");
        }
        return null;
    }

    public String decrypt(String s) {
        try {
            byte[] decoded = new BASE64Decoder().decodeBuffer(s);
            byte[] decr = this.getCipher(2).doFinal(decoded);
            return new String(decr, this.encodingFormat);
        }
        catch (BadPaddingException e) {
            this.handleException(e, "decrypt() - BadPaddingException!");
        }
        catch (IllegalBlockSizeException e) {
            this.handleException(e, "decrypt() - IllegalBlockSizeException!");
        }
        catch (UnsupportedEncodingException e) {
            this.handleException(e, "decrypt() - UnsupportedEncodingException!");
        }
        catch (IOException e) {
            this.handleException(e, "decrypt() - IOException!");
        }
        return null;
    }

    public Key getKey() {
        if (this.key == null) {
            this.key = this.generateKey();
        }
        return this.key;
    }

    public void setKey(Key key) {
        this.key = key;
    }
}

