/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.pharmacy.persistence.dao.impl;

import gov.va.med.pharmacy.persistence.BaseDao;
import gov.va.med.pharmacy.persistence.dao.PharmacyDao;
import gov.va.med.pharmacy.persistence.managepharmacy.ManagePharmacyFilter;
import gov.va.med.pharmacy.persistence.model.PharmacyEntity;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="pharmacy")
public class PharmacyDaoImpl
extends BaseDao<Integer, PharmacyEntity>
implements PharmacyDao {
    @Override
    public List<PharmacyEntity> find(ManagePharmacyFilter pharmacyFilterModel) {
        Criteria criteria = this.createEntityCriteria().addOrder(Order.asc((String)"divisionName"));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        if (pharmacyFilterModel != null && pharmacyFilterModel.getVisn().length() > 0) {
            criteria.add((Criterion)Restrictions.eq((String)"visn", (Object)pharmacyFilterModel.getVisn()));
        }
        criteria.setProjection((Projection)Projections.projectionList().add((Projection)Projections.property((String)"visn"), "visn").add((Projection)Projections.property((String)"vaStationId"), "vaStationId").add((Projection)Projections.property((String)"ncpdpId"), "ncpdpId").add((Projection)Projections.property((String)"divisionName"), "divisionName").add((Projection)Projections.property((String)"pharmacyAddressLine1"), "pharmacyAddressLine1").add((Projection)Projections.property((String)"pharmacyAddressLine1"), "pharmacyAddressLine1").add((Projection)Projections.property((String)"pharmacyCity"), "pharmacyCity").add((Projection)Projections.property((String)"pharmacyState"), "pharmacyState").add((Projection)Projections.property((String)"storeName"), "storeName").add((Projection)Projections.property((String)"activeStartTime"), "activeStartTime").add((Projection)Projections.property((String)"pharmacyPhoneNumber"), "pharmacyPhoneNumber").add((Projection)Projections.property((String)"inboundErxEnabled"), "inboundErxEnabled"));
        criteria.add((Criterion)Restrictions.ne((String)"pharmacyId", (Object)new Long(0L)));
        criteria.setResultTransformer(Criteria.ALIAS_TO_ENTITY_MAP);
        List pharmacies = criteria.list();
        return pharmacies;
    }

    @Override
    public PharmacyEntity findByNCPDPId(String NCPDPId) {
        Criteria criteria = this.createEntityCriteria();
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        if (NCPDPId != null) {
            criteria.add((Criterion)Restrictions.eq((String)"ncpdpId", (Object)NCPDPId));
        }
        PharmacyEntity pharmacy = (PharmacyEntity)criteria.uniqueResult();
        return pharmacy;
    }

    @Override
    public PharmacyEntity findById(Long pharmacyId) {
        PharmacyEntity pharmacy = (PharmacyEntity)this.getByKey(pharmacyId);
        return pharmacy;
    }

    @Override
    public void save(PharmacyEntity pharmacy) {
        this.persist(pharmacy);
    }

    @Override
    public void updatePharmacyInfo(PharmacyEntity pharmacy) {
        this.update(pharmacy);
    }
}

