/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.pharmacy.persistence.service.impl;

import gov.va.med.pharmacy.persistence.dao.UserDao;
import gov.va.med.pharmacy.persistence.model.VaUser;
import gov.va.med.pharmacy.persistence.service.UserService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="userService")
@Transactional
public class UserServiceImpl
implements UserService {
    @Autowired
    private UserDao userDao;

    @Override
    public VaUser findById(long id) {
        return this.userDao.findById(id);
    }

    @Override
    public VaUser findByVAUserID(String networkID) {
        return this.userDao.findByVAUserID(networkID);
    }

    @Override
    public void addNewVAUser(VaUser user) {
        try {
            this.userDao.save(user);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateVAUser(VaUser user) {
        try {
            this.userDao.save(user);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<VaUser> findAllUsers() {
        return this.userDao.findAll();
    }

    @Override
    public void updateUserInfo(VaUser user) {
        this.userDao.updateVaUser(user);
    }

    @Override
    public void updateUsers(List<VaUser> users) throws Exception {
        VaUser userFromDB = null;
        for (VaUser user : users) {
            try {
                userFromDB = this.userDao.findById(user.getUsersId());
                if (null == userFromDB) continue;
                if (null != user.getIsPharmMgr()) {
                    userFromDB.setIsPharmMgr(user.getIsPharmMgr());
                }
                if (null != user.getIsPbmAdmn()) {
                    userFromDB.setIsPbmAdmn(user.getIsPbmAdmn());
                }
                if (null != user.getIsPharmTech()) {
                    userFromDB.setIsPharmTech(user.getIsPharmTech());
                }
                if (null != user.getIsSystemAdmn()) {
                    userFromDB.setIsSystemAdmn(user.getIsSystemAdmn());
                }
                if (null != user.getFirstName()) {
                    userFromDB.setFirstName(user.getFirstName());
                }
                if (null != user.getLastName()) {
                    userFromDB.setLastName(user.getLastName());
                }
                if (null != user.getVaUserid()) {
                    userFromDB.setVaUserid(user.getVaUserid());
                }
                userFromDB.setUpdatedDate(user.getUpdatedDate());
                userFromDB.setUpdatedBy(user.getUpdatedBy());
                this.userDao.updateVaUser(userFromDB);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception(e);
            }
        }
    }

    @Override
    public void deleteUsers(List<VaUser> users) throws Exception {
        VaUser userFromDB = null;
        for (VaUser user : users) {
            try {
                userFromDB = this.userDao.findById(user.getUsersId());
                if (null == userFromDB) continue;
                this.userDao.deleteVaUser(userFromDB);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception(e);
            }
        }
    }
}

