/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.pharmacy.persistence.dao.impl;

import gov.va.med.pharmacy.persistence.BaseDao;
import gov.va.med.pharmacy.persistence.dao.SummaryReportDao;
import gov.va.med.pharmacy.persistence.model.SummaryReportVw;
import gov.va.med.pharmacy.persistence.report.SummaryReportFilter;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository(value="summaryReportDao")
public class SummaryReportDaoImpl
extends BaseDao<Integer, SummaryReportVw>
implements SummaryReportDao {
    @Override
    public SummaryReportVw findByVisn(String visn) {
        Criteria crit = this.createEntityCriteria();
        crit.add((Criterion)Restrictions.eq((String)"visn", (Object)visn));
        SummaryReportVw summaryReportVw = (SummaryReportVw)crit.uniqueResult();
        return summaryReportVw;
    }

    @Override
    public List<SummaryReportVw> findByDate(Date dateFrom, Date dateTo) {
        Criteria criteria = this.createEntityCriteria().addOrder(Order.asc((String)"pharmacyDivisionName"));
        List summaryReportRows = criteria.list();
        return summaryReportRows;
    }

    @Override
    public List<SummaryReportVw> find(SummaryReportFilter summaryReportFilter) {
        Criteria criteria = this.createEntityCriteria().addOrder(Order.asc((String)"pharmacyDivisionName"));
        criteria.add(Restrictions.between((String)"newRxMessageDate", (Object)summaryReportFilter.getDateFrom(), (Object)summaryReportFilter.getDateTo()));
        if (summaryReportFilter.getVisn().length() > 0) {
            criteria.add((Criterion)Restrictions.eq((String)"visn", (Object)summaryReportFilter.getVisn()));
        }
        if (summaryReportFilter.getStationId() != null && summaryReportFilter.getStationId().compareTo("All") != 0) {
            criteria.add((Criterion)Restrictions.eq((String)"pharmacyVaStationId", (Object)summaryReportFilter.getStationId()));
        }
        criteria.setProjection((Projection)Projections.projectionList().add(Projections.groupProperty((String)"visn").as("visn")).add(Projections.groupProperty((String)"pharmacyNcpdpId").as("pharmacyNcpdpId")).add(Projections.groupProperty((String)"pharmacyVaStationId").as("pharmacyVaStationId")).add(Projections.groupProperty((String)"pharmacyDivisionName").as("pharmacyDivisionName")).add(Projections.groupProperty((String)"pharmacyAddress").as("pharmacyAddress")).add(Projections.sum((String)"newRxCnt").as("newRxCnt")).add(Projections.sum((String)"newRxPharmDisabledAtHub").as("newRxPharmDisabledAtHub")).add(Projections.sum((String)"newRxRejectedAtHub").as("newRxRejectedAtHub")).add(Projections.sum((String)"newRxPassAutoChk").as("newRxPassAutoChk")).add(Projections.sum((String)"newRxFailAutoChk").as("newRxFailAutoChk")).add(Projections.sum((String)"newRxRejectedByPharmacist").as("newRxRejectedByPharmacist")).add(Projections.sum((String)"newRxFilled").as("newRxFilled")).add(Projections.sum((String)"newRxInProcess").as("newRxInProcess")));
        criteria.setResultTransformer(Criteria.ALIAS_TO_ENTITY_MAP);
        List summaryReportRows = criteria.list();
        return summaryReportRows;
    }

    @Override
    public List<SummaryReportVw> find(String visn) {
        Criteria criteria = this.createEntityCriteria().addOrder(Order.asc((String)"pharmacyVaStationId"));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        if (visn != null && visn.length() > 0) {
            visn = visn.substring(0, visn.length() - 1);
        }
        if (visn.compareTo("") == 0) {
            visn = "%";
        }
        criteria.add((Criterion)Restrictions.like((String)"visn", (Object)visn));
        List selectRows = criteria.list();
        return selectRows;
    }

    @Override
    public List<SummaryReportVw> queryForExport(SummaryReportFilter summaryReportFilter) {
        Criteria criteria = this.createEntityCriteria().addOrder(Order.asc((String)"pharmacyDivisionName"));
        criteria.add(Restrictions.between((String)"newRxMessageDate", (Object)summaryReportFilter.getDateFrom(), (Object)summaryReportFilter.getDateTo()));
        if (summaryReportFilter.getVisn().length() > 0) {
            criteria.add((Criterion)Restrictions.eq((String)"visn", (Object)summaryReportFilter.getVisn()));
        }
        if (summaryReportFilter.getStationId() != null && summaryReportFilter.getStationId().compareTo("All") != 0) {
            criteria.add((Criterion)Restrictions.eq((String)"pharmacyVaStationId", (Object)summaryReportFilter.getStationId()));
        }
        criteria.setProjection((Projection)Projections.projectionList().add(Projections.groupProperty((String)"visn").as("visn")).add(Projections.groupProperty((String)"pharmacyNcpdpId").as("pharmacyNcpdpId")).add(Projections.groupProperty((String)"pharmacyVaStationId").as("pharmacyVaStationId")).add(Projections.groupProperty((String)"pharmacyDivisionName").as("pharmacyDivisionName")).add(Projections.groupProperty((String)"pharmacyAddress").as("pharmacyAddress")).add(Projections.sum((String)"newRxCnt").as("newRxCnt")).add(Projections.sum((String)"newRxPharmDisabledAtHub").as("newRxPharmDisabledAtHub")).add(Projections.sum((String)"newRxRejectedAtHub").as("newRxRejectedAtHub")).add(Projections.sum((String)"newRxPassAutoChk").as("newRxPassAutoChk")).add(Projections.sum((String)"newRxFailAutoChk").as("newRxFailAutoChk")).add(Projections.sum((String)"newRxRejectedByPharmacist").as("newRxRejectedByPharmacist")).add(Projections.sum((String)"newRxFilled").as("newRxFilled")).add(Projections.sum((String)"newRxInProcess").as("newRxInProcess")));
        criteria.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(SummaryReportVw.class));
        List summaryReportRows = criteria.list();
        return summaryReportRows;
    }
}

