/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.pharmacy.persistence;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseDao<PK extends Serializable, T> {
    private final Class<T> persistentClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[1];
    @Autowired
    private SessionFactory inboundErxSessionFactory;

    protected Session getSession() {
        return this.inboundErxSessionFactory.getCurrentSession();
    }

    public T getByKey(long id) {
        return (T)this.getSession().get(this.persistentClass, (Serializable)Long.valueOf(id));
    }

    public void persist(T entity) {
        Session session = this.getSession();
        session.persist(entity);
        session.flush();
        session.clear();
    }

    public void update(T entity) {
        Session session = this.getSession();
        session.update(entity);
        session.flush();
        session.clear();
    }

    public void delete(T entity) {
        this.getSession().delete(entity);
    }

    protected Criteria createEntityCriteria() {
        return this.getSession().createCriteria(this.persistentClass);
    }
}

