/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.pharmacy.persistence.track.impl;

import gov.va.med.pharmacy.persistence.report.VisnSelectModel;
import gov.va.med.pharmacy.persistence.track.VisnSelectDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
public class VisnSelectDaoImpl
implements VisnSelectDao {
    private static final Logger LOG = LogManager.getLogger(VisnSelectDaoImpl.class);
    @Autowired
    private DataSource dataSource;

    public VisnSelectDaoImpl() {
    }

    public VisnSelectDaoImpl(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public List<VisnSelectModel> getVisns() {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        String sql = "";
        sql = "select distinct visn from pharmacy order by to_number(visn)";
        ArrayList<VisnSelectModel> visnList = new ArrayList();
        try {
            visnList = jdbcTemplate.query(sql, (RowMapper)new VisnListRowMapper());
        }
        catch (DataAccessException e) {
            LOG.info("Exception retrieving NCPDP message details." + e.getMessage());
        }
        return visnList;
    }

    public class VisnListRowMapper
    implements RowMapper<VisnSelectModel> {
        public VisnSelectModel mapRow(ResultSet rs, int rowNum) throws SQLException {
            VisnSelectModel visnSelectModel = new VisnSelectModel();
            visnSelectModel.setId(rs.getString("visn"));
            visnSelectModel.setLabel(rs.getString("visn"));
            return visnSelectModel;
        }
    }
}

