/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.xml;

import gov.va.med.exception.ExceptionUtils;
import gov.va.med.exception.FoundationsException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtilities {
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
    private static final Logger logger = Logger.getLogger(XmlUtilities.class);
    private static DocumentBuilderFactory documentBuilderFactory = null;
    private static TransformerFactory transformerFactory = null;
    private static ThreadLocalDocumentBuilder threadDocumentBuilder;
    private static ThreadLocalTransformer threadTransformer;

    private XmlUtilities() {
    }

    public static String convertXmlToStr(Document doc) throws FoundationsException {
        StringWriter sw = new StringWriter();
        try {
            threadTransformer.getTransformer().transform(new DOMSource(doc), new StreamResult(sw));
        }
        catch (TransformerException e) {
            String errStr = "Exception occured transforming DOM to String.";
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                logger.error((Object)new StringBuffer().append(errStr).append("\n\t").append(ExceptionUtils.getFullStackTrace(e)).toString());
            }
            throw new FoundationsException(errStr, e);
        }
        return sw.toString();
    }

    public static Node getNode(String xpathStr, Node node) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            NodeList nodeSet = (NodeList)xpath.evaluate(xpathStr, node, XPathConstants.NODESET);
            logger.debug((Object)new StringBuffer().append("XPath ").append(xpathStr).append(" returned  ").append(nodeSet.getLength()).append("nodes.").toString());
            if (nodeSet.getLength() == 0) {
                return null;
            }
            return nodeSet.item(0);
        }
        catch (XPathExpressionException e) {
            logger.error((Object)new StringBuffer().append("Exception occured.").append("\n\t").append(ExceptionUtils.getFullStackTrace(e)).toString());
            return null;
        }
    }

    public static Attr getAttr(Node node, String attrName) {
        NamedNodeMap attrs = node.getAttributes();
        return (Attr)attrs.getNamedItem(attrName);
    }

    public static Document getDocumentForXmlString(String xml) throws FoundationsException {
        return XmlUtilities.getDocumentForXmlInputSource(new InputSource(new StringReader(xml)));
    }

    public static Document getDocumentForXmlInputStream(InputStream xml) throws FoundationsException {
        return XmlUtilities.getDocumentForXmlInputSource(new InputSource(xml));
    }

    private static Document getDocumentForXmlInputSource(InputSource xml) throws FoundationsException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)new StringBuffer().append("Using DocumentBuilderFactory factory ").append(documentBuilderFactory).append("; and DocumentBuilder builder ").append(threadDocumentBuilder));
        }
        Document returnDoc = null;
        try {
            returnDoc = threadDocumentBuilder.getBuilder().parse(xml);
        }
        catch (SAXException e) {
            String errStr = "Can not parse xml into a Document - SAXException.";
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                logger.error((Object)new StringBuffer().append(errStr).append("\n\t").append(ExceptionUtils.getFullStackTrace(e)).toString());
            }
            throw new FoundationsException(errStr, e);
        }
        catch (IOException e) {
            String errStr = "Can not parse xml into a Document - IOException.";
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                logger.error((Object)new StringBuffer().append(errStr).append("\n\t").append(ExceptionUtils.getFullStackTrace(e)).toString());
            }
            throw new FoundationsException(errStr, e);
        }
        return returnDoc;
    }

    static {
        documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        transformerFactory = TransformerFactory.newInstance();
        threadDocumentBuilder = new ThreadLocalDocumentBuilder();
        threadTransformer = new ThreadLocalTransformer();
    }

    private static class ThreadLocalTransformer
    extends ThreadLocal {
        private ThreadLocalTransformer() {
        }

        public Transformer getTransformer() throws FoundationsException {
            Transformer transformer = (Transformer)this.get();
            if (transformer == null) {
                throw new FoundationsException("Exception occured trying to create Transformer. See error log for details.");
            }
            return transformer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object initialValue() {
            TransformerFactory transformerFactory = transformerFactory;
            synchronized (transformerFactory) {
                try {
                    Transformer transformer = transformerFactory.newTransformer();
                    Properties oprops = new Properties();
                    oprops.put("method", "xml");
                    transformer.setOutputProperties(oprops);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Using Transformer implementation: " + transformer.getClass().getName()));
                    }
                    return transformer;
                }
                catch (TransformerConfigurationException e) {
                    logger.error((Object)new StringBuffer().append("Exception occured trying to create Transformer.").append("\n\t").append(ExceptionUtils.getFullStackTrace(e)).toString());
                    return null;
                }
            }
        }
    }

    private static class ThreadLocalDocumentBuilder
    extends ThreadLocal {
        private ThreadLocalDocumentBuilder() {
        }

        public DocumentBuilder getBuilder() throws FoundationsException {
            DocumentBuilder builder = (DocumentBuilder)this.get();
            if (builder == null) {
                throw new FoundationsException("Can not get DocumentBuilder from DocumentBuilderFactory - check JAXP configuration/classpaths. See error log for details.");
            }
            return builder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object initialValue() {
            DocumentBuilderFactory documentBuilderFactory = documentBuilderFactory;
            synchronized (documentBuilderFactory) {
                try {
                    DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Using DocumentBuilder implementation: " + builder.getClass().getName()));
                    }
                    return builder;
                }
                catch (ParserConfigurationException e) {
                    logger.error((Object)new StringBuffer().append("Can not get DocumentBuilder from DocumentBuilderFactory - check JAXP configuration/classpaths.").append("\n\t").append(ExceptionUtils.getFullStackTrace(e)).toString());
                    return null;
                }
            }
        }
    }
}

