/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.environment;

import gov.va.med.environment.ServerType;
import org.apache.log4j.Logger;

public class Environment {
    private static final String WEBLOGIC_CLASSLOADER_PACKAGE = "weblogic.utils.classloaders";
    private static final int WEBLOGIC_CLASSLOADER_PACKAGE_LENGTH = "weblogic.utils.classloaders".length();
    static final Logger logger = Logger.getLogger(Environment.class);

    private Environment() {
    }

    public static boolean isProduction() {
        return Boolean.getBoolean("gov.va.med.environment.production");
    }

    public static ServerType getServerType() {
        ServerType returnVal = null;
        String serverProperty = System.getProperty("gov.va.med.environment.servertype");
        if (serverProperty != null) {
            returnVal = ServerType.getServerTypeObject(serverProperty.toLowerCase());
            if (returnVal != null) {
                logger.debug((Object)"used JVM arg for server type");
            }
        } else if (Environment.isWebLogicClassLoaderHierarchy(Environment.class.getClassLoader())) {
            returnVal = ServerType.WEBLOGIC;
            logger.debug((Object)"used server auto-detection for server type");
        }
        if (returnVal == null) {
            returnVal = ServerType.UNKNOWN;
            logger.debug((Object)"no JVM arg value, and auto-detection failed; could not determine server type.");
        }
        return returnVal;
    }

    private static boolean isWebLogicClassLoaderHierarchy(ClassLoader classLoader) {
        boolean returnVal = false;
        if (classLoader != null) {
            String className = classLoader.getClass().getName();
            logger.debug((Object)("found class name in classloader hierarchy: " + className));
            returnVal = className.length() > WEBLOGIC_CLASSLOADER_PACKAGE.length() && WEBLOGIC_CLASSLOADER_PACKAGE.equals(className.substring(0, WEBLOGIC_CLASSLOADER_PACKAGE_LENGTH)) ? true : Environment.isWebLogicClassLoaderHierarchy(classLoader.getParent());
        }
        return returnVal;
    }
}

