/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.security;

import gov.va.med.vistalink.security.CallbackChangeVc;
import gov.va.med.vistalink.security.DialogConfirm;
import gov.va.med.vistalink.security.VistaLoginSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;

final class DialogChangeVc
extends JDialog {
    private static final String DEFAULT_TITLE = "Change VistA Verify Code";
    private static final String PANEL_TITLE = "You need to enter a new verify code.";
    private static final String PANEL_ACCESSIBLE_DESCRIPTION = "This dialog is prompting you to change your verify code.";
    private static final String OLD_VERIFY_LABEL = "Old Verify Code: ";
    private static final char OLD_VERIFY_MNEMONIC = 'D';
    private static final String OLD_VERIFY_TOOLTIP = "Enter Current (Old) Verify Code";
    private static final String NEW_VERIFY_LABEL = "New Verify Code: ";
    private static final char NEW_VERIFY_MNEMONIC = 'N';
    private static final String NEW_VERIFY_TOOLTIP = "Enter New Verify Code";
    private static final String NEW_VERIFY_CHECK_LABEL = "Confirm New Verify Code: ";
    private static final char NEW_VERIFY_CHECK_MNEMONIC = 'F';
    private static final String NEW_VERIFY_CHECK_TOOLTIP = "Re-Enter New Verify Code";
    private static final String OK_BUTTON_LABEL = "OK";
    private static final char OK_BUTTON_MNEMONIC = 'O';
    private static final String OK_BUTTON_TOOLTIP = "Submits Request to Server to Change Verify Code";
    private static final String CANCEL_BUTTON_LABEL = "Cancel";
    private static final char CANCEL_BUTTON_MNEMONIC = 'C';
    private static final String CANCEL_BUTTON_TOOLTIP = "Cancels the Change Verify Code request";
    private static final String HELP_BUTTON_LABEL = "Help";
    private static final char HELP_BUTTON_MNEMONIC = 'H';
    private static final String HELP_BUTTON_TOOLTIP = "Get Help on Changing Verify Code";
    private static final int CODE_FIELD_COLUMNS = 13;
    private static final String HELP_MSG_1 = "Enter a new verify code and then confirm it.";
    private JPasswordField oldVerify;
    private JPasswordField newVerify;
    private JPasswordField newVerifyCheck;
    private JButton help;
    private JButton ok;
    private JButton cancel;
    private JLabel oldVerifyLabel;
    private JLabel newVerifyLabel;
    private JLabel newVerifyCheckLabel;
    private CallbackChangeVc cvcCbh;
    private Frame parentFrame;

    static void showVistaAVSwingChangeVC(Frame parent, CallbackChangeVc cvcCbh) {
        DialogChangeVc dialog = new DialogChangeVc(parent, cvcCbh);
        if (parent != null && !"".equals(parent.getTitle())) {
            dialog.setTitle(parent.getTitle() + ": " + "Sign-on" + " " + DEFAULT_TITLE);
        } else {
            dialog.setTitle("HealtheVet-VistA Sign-on: Change VistA Verify Code");
        }
        VistaLoginSwingUtilities.goldenMeanCenterDialog(parent, dialog);
        dialog.setVisible(true);
    }

    private DialogChangeVc(Frame parent, CallbackChangeVc cvcCbh) {
        super(parent, DEFAULT_TITLE, true);
        this.cvcCbh = cvcCbh;
        this.parentFrame = parent;
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.createContentPane(), "Center");
        this.pack();
        VistaLoginSwingUtilities.goldenMeanCenterDialog(parent, this);
        this.getAccessibleContext().setAccessibleDescription(PANEL_ACCESSIBLE_DESCRIPTION);
        int timeout = 1000 * this.cvcCbh.getTimeoutInSeconds();
        ActionListener taskPerformer = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogChangeVc.this.doTimeout();
            }
        };
        new Timer(timeout, taskPerformer).start();
        if (cvcCbh.getEnteredVerifyCodeWasNull()) {
            this.oldVerify.setEditable(false);
            this.newVerify.requestFocusInWindow();
        } else {
            this.oldVerify.requestFocusInWindow();
        }
    }

    private JComponent createContentPane() {
        GridBagLayout gridbag = new GridBagLayout();
        JPanel p = new JPanel();
        p.setLayout(gridbag);
        this.createPasswordFields();
        this.createLabels();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(6, 6, 6, 6);
        c.ipadx = 3;
        c.ipady = 3;
        c.gridheight = 1;
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 3;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 1;
        p.add((Component)this.oldVerifyLabel, c);
        c.gridy = 2;
        p.add((Component)this.newVerifyLabel, c);
        c.gridy = 3;
        p.add((Component)this.newVerifyCheckLabel, c);
        c.gridx = 1;
        c.gridy = 1;
        p.add((Component)this.oldVerify, c);
        c.gridy = 2;
        p.add((Component)this.newVerify, c);
        c.gridy = 3;
        p.add((Component)this.newVerifyCheck, c);
        c.gridx = 2;
        c.gridy = 1;
        p.add((Component)this.createOKButton(), c);
        c.gridy = 2;
        p.add((Component)this.createCancelButton(), c);
        c.gridy = 3;
        p.add((Component)this.createHelpButton(), c);
        p.setFocusCycleRoot(true);
        p.setFocusTraversalPolicy(new DialogChangeVcFocusTraversalPolicy());
        p.setBorder(new TitledBorder(PANEL_TITLE));
        return p;
    }

    private void createPasswordFields() {
        this.oldVerify = new JPasswordField("", 13);
        this.oldVerify.setToolTipText(OLD_VERIFY_TOOLTIP);
        this.newVerify = new JPasswordField("", 13);
        this.newVerify.setToolTipText(NEW_VERIFY_TOOLTIP);
        this.newVerifyCheck = new JPasswordField("", 13);
        this.newVerifyCheck.setToolTipText(NEW_VERIFY_CHECK_TOOLTIP);
    }

    private void createLabels() {
        this.oldVerifyLabel = new JLabel(OLD_VERIFY_LABEL);
        this.oldVerifyLabel.setHorizontalAlignment(4);
        this.oldVerifyLabel.setFont(this.oldVerifyLabel.getFont().deriveFont(1));
        this.oldVerifyLabel.setDisplayedMnemonic('D');
        this.oldVerifyLabel.setToolTipText(OLD_VERIFY_TOOLTIP);
        this.oldVerifyLabel.setLabelFor(this.oldVerify);
        this.oldVerifyLabel.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                DialogChangeVc.this.oldVerify.requestFocusInWindow();
            }
        });
        this.newVerifyLabel = new JLabel(NEW_VERIFY_LABEL);
        this.newVerifyLabel.setHorizontalAlignment(4);
        this.newVerifyLabel.setFont(this.newVerifyLabel.getFont().deriveFont(1));
        this.newVerifyLabel.setDisplayedMnemonic('N');
        this.newVerifyLabel.setToolTipText(NEW_VERIFY_TOOLTIP);
        this.newVerifyLabel.setLabelFor(this.newVerify);
        this.newVerifyLabel.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                DialogChangeVc.this.newVerify.requestFocusInWindow();
            }
        });
        this.newVerifyCheckLabel = new JLabel(NEW_VERIFY_CHECK_LABEL);
        this.newVerifyCheckLabel.setHorizontalAlignment(4);
        this.newVerifyCheckLabel.setFont(this.newVerifyCheckLabel.getFont().deriveFont(1));
        this.newVerifyCheckLabel.setDisplayedMnemonic('F');
        this.newVerifyCheckLabel.setToolTipText(NEW_VERIFY_CHECK_TOOLTIP);
        this.newVerifyCheckLabel.setLabelFor(this.newVerifyCheck);
        this.newVerifyCheckLabel.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                DialogChangeVc.this.newVerifyCheck.requestFocusInWindow();
            }
        });
    }

    private JButton createCancelButton() {
        this.cancel = new JButton(CANCEL_BUTTON_LABEL);
        this.cancel.setMnemonic('C');
        this.cancel.setFont(this.cancel.getFont().deriveFont(1));
        this.cancel.setToolTipText(CANCEL_BUTTON_TOOLTIP);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogChangeVc.this.cancelActionPerformed();
            }
        });
        return this.cancel;
    }

    private JButton createOKButton() {
        this.ok = new JButton(OK_BUTTON_LABEL);
        this.ok.setMnemonic('O');
        this.ok.setFont(this.ok.getFont().deriveFont(1));
        this.ok.setToolTipText(OK_BUTTON_TOOLTIP);
        this.getRootPane().setDefaultButton(this.ok);
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogChangeVc.this.okActionPerformed();
            }
        });
        return this.ok;
    }

    private JButton createHelpButton() {
        this.help = new JButton(HELP_BUTTON_LABEL);
        this.help.setMnemonic('H');
        this.help.setFont(this.help.getFont().deriveFont(1));
        this.help.setToolTipText(HELP_BUTTON_TOOLTIP);
        this.help.addActionListener(new HelpButtonActionListener());
        return this.help;
    }

    private void okActionPerformed() {
        this.cvcCbh.setOldVerifyCode(this.oldVerify.getPassword());
        this.cvcCbh.setNewVerifyCode(this.newVerify.getPassword());
        this.cvcCbh.setNewVerifyCodeCheck(this.newVerifyCheck.getPassword());
        this.cvcCbh.setSelectedOption(1);
        this.setVisible(false);
        this.dispose();
    }

    private void cancelActionPerformed() {
        this.cvcCbh.setOldVerifyCode(null);
        this.cvcCbh.setNewVerifyCode(null);
        this.cvcCbh.setNewVerifyCodeCheck(null);
        this.cvcCbh.setSelectedOption(0);
        this.setVisible(false);
        this.dispose();
    }

    private void doTimeout() {
        this.cvcCbh.setOldVerifyCode(null);
        this.cvcCbh.setNewVerifyCode(null);
        this.cvcCbh.setNewVerifyCodeCheck(null);
        this.cvcCbh.setSelectedOption(2);
        this.setVisible(false);
        this.dispose();
    }

    class DialogChangeVcFocusTraversalPolicy
    extends FocusTraversalPolicy {
        DialogChangeVcFocusTraversalPolicy() {
        }

        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(DialogChangeVc.this.oldVerify)) {
                return DialogChangeVc.this.newVerify;
            }
            if (aComponent.equals(DialogChangeVc.this.newVerify)) {
                return DialogChangeVc.this.newVerifyCheck;
            }
            if (aComponent.equals(DialogChangeVc.this.newVerifyCheck)) {
                return DialogChangeVc.this.ok;
            }
            if (aComponent.equals(DialogChangeVc.this.ok)) {
                return DialogChangeVc.this.cancel;
            }
            if (aComponent.equals(DialogChangeVc.this.cancel)) {
                return DialogChangeVc.this.help;
            }
            if (aComponent.equals(DialogChangeVc.this.help)) {
                return DialogChangeVc.this.oldVerify;
            }
            if (aComponent.equals(DialogChangeVc.this.oldVerifyLabel)) {
                return DialogChangeVc.this.oldVerify;
            }
            if (aComponent.equals(DialogChangeVc.this.newVerifyLabel)) {
                return DialogChangeVc.this.newVerify;
            }
            if (aComponent.equals(DialogChangeVc.this.newVerifyCheckLabel)) {
                return DialogChangeVc.this.newVerifyCheck;
            }
            return DialogChangeVc.this.oldVerify;
        }

        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(DialogChangeVc.this.help)) {
                return DialogChangeVc.this.cancel;
            }
            if (aComponent.equals(DialogChangeVc.this.cancel)) {
                return DialogChangeVc.this.ok;
            }
            if (aComponent.equals(DialogChangeVc.this.ok)) {
                return DialogChangeVc.this.newVerifyCheck;
            }
            if (aComponent.equals(DialogChangeVc.this.newVerifyCheck)) {
                return DialogChangeVc.this.newVerify;
            }
            if (aComponent.equals(DialogChangeVc.this.newVerify)) {
                return DialogChangeVc.this.oldVerify;
            }
            if (aComponent.equals(DialogChangeVc.this.oldVerify)) {
                return DialogChangeVc.this.help;
            }
            if (aComponent.equals(DialogChangeVc.this.newVerifyCheckLabel)) {
                return DialogChangeVc.this.newVerify;
            }
            if (aComponent.equals(DialogChangeVc.this.newVerifyLabel)) {
                return DialogChangeVc.this.oldVerify;
            }
            if (aComponent.equals(DialogChangeVc.this.oldVerifyLabel)) {
                return DialogChangeVc.this.help;
            }
            return DialogChangeVc.this.oldVerify;
        }

        public Component getDefaultComponent(Container focusCycleRoot) {
            return DialogChangeVc.this.oldVerify;
        }

        public Component getLastComponent(Container focusCycleRoot) {
            return DialogChangeVc.this.help;
        }

        public Component getFirstComponent(Container focusCycleRoot) {
            return DialogChangeVc.this.oldVerify;
        }
    }

    class HelpButtonActionListener
    implements ActionListener {
        HelpButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            StringBuffer sb = new StringBuffer(DialogChangeVc.HELP_MSG_1);
            sb.append('\n');
            sb.append(DialogChangeVc.this.cvcCbh.getCvcHelpText());
            int returnVal = DialogConfirm.showDialogConfirm(DialogChangeVc.this.parentFrame, sb.toString(), "Sign-on Change Verify Code Help", 2, DialogChangeVc.this.cvcCbh.getTimeoutInSeconds());
            if (returnVal == 12) {
                DialogChangeVc.this.doTimeout();
            } else {
                DialogChangeVc.this.oldVerify.requestFocusInWindow();
            }
        }
    }
}

