/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.pharmacy.utility;

import gov.va.med.exception.FoundationsException;
import gov.va.med.pharmacy.utility.StreamUtilities;
import gov.va.med.vistalink.adapter.cci.VistaLinkAppProxyConnectionSpec;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnection;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionFactory;
import gov.va.med.vistalink.institution.InstitutionMappingDelegate;
import gov.va.med.vistalink.rpc.RpcRequest;
import gov.va.med.vistalink.rpc.RpcRequestFactory;
import gov.va.med.vistalink.rpc.RpcResponse;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionSpec;

public class VistaLinkConnectionUtility {
    private static final String DUZ_CONNECTION_SPEC = "DUZ";
    private static final String VPID_CONNECTION_SPEC = "VPID";
    private static final String APP_PROXY_CONNECTION_SPEC = "APP PROXY";
    public static final int DEFAULT_RPCTIMEOUT = 60000;
    public static final String DEFAULT_CONNSPEC = "DUZ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RpcResponse sendRequest(String division, String rpcContext, String rpcName, ArrayList<Object> rpcParams) throws Exception {
        String proxyUser = "PSOAPPLICATIONPROXY,PSO";
        VistaLinkConnection connection = null;
        try {
            RpcResponse response;
            Properties properties = new Properties();
            InputStream inputStream = null;
            try {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("gov.va.med.pharmacy.vistalink.properties");
                if (null != inputStream) {
                    properties.load(inputStream);
                    proxyUser = properties.getProperty("vistalink.proxyuser").trim();
                }
            }
            finally {
                if (null != inputStream) {
                    StreamUtilities.safeClose(inputStream);
                }
            }
            connection = this.getConnection(division, proxyUser);
            RpcRequest rpcRequest = RpcRequestFactory.getRpcRequest();
            rpcRequest.setRpcContext(rpcContext);
            rpcRequest.setRpcName(rpcName);
            rpcRequest.setRpcClientTimeOut(60000);
            rpcRequest.setUseProprietaryMessageFormat(true);
            if (rpcParams != null) {
                rpcRequest.setParams(rpcParams);
            }
            RpcResponse rpcResponse = response = connection.executeRPC(rpcRequest);
            return rpcResponse;
        }
        catch (FoundationsException e) {
            throw new Exception(e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (ResourceException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private VistaLinkConnection getConnection(String division, String proxyUser) throws Exception {
        try (Context ic = null;){
            VistaLinkConnection connection;
            VistaLinkAppProxyConnectionSpec connectionSpec = null;
            connectionSpec = new VistaLinkAppProxyConnectionSpec(division, proxyUser);
            ic = new InitialContext();
            String jndiName = InstitutionMappingDelegate.getJndiConnectorNameForInstitution((String)division);
            VistaLinkConnectionFactory cf = (VistaLinkConnectionFactory)ic.lookup(jndiName);
            VistaLinkConnection vistaLinkConnection = connection = (VistaLinkConnection)cf.getConnection((ConnectionSpec)connectionSpec);
            return vistaLinkConnection;
        }
    }
}

