/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.security.m;

import gov.va.med.exception.FoundationsException;
import gov.va.med.vistalink.adapter.record.VistaLinkFaultException;
import gov.va.med.vistalink.adapter.record.VistaLinkRequestVO;
import gov.va.med.vistalink.adapter.record.VistaLinkResponseFactoryImpl;
import gov.va.med.vistalink.adapter.record.VistaLinkResponseVO;
import gov.va.med.vistalink.security.m.SecurityConnectionProxyException;
import gov.va.med.vistalink.security.m.SecurityDataChangeVcResponse;
import gov.va.med.vistalink.security.m.SecurityDataLogonResponse;
import gov.va.med.vistalink.security.m.SecurityDataLogoutResponse;
import gov.va.med.vistalink.security.m.SecurityDataSelectDivisionResponse;
import gov.va.med.vistalink.security.m.SecurityDataSetupAndIntroTextResponse;
import gov.va.med.vistalink.security.m.SecurityDataUserDemographicsResponse;
import gov.va.med.vistalink.security.m.SecurityFaultException;
import gov.va.med.vistalink.security.m.SecurityIPLockedFaultException;
import gov.va.med.vistalink.security.m.SecurityPrimaryStationMismatchException;
import gov.va.med.vistalink.security.m.SecurityProductionMismatchException;
import gov.va.med.vistalink.security.m.SecurityResponse;
import gov.va.med.vistalink.security.m.SecurityTooManyInvalidLoginAttemptsFaultException;
import gov.va.med.vistalink.security.m.SecurityVOSetupAndIntroText;
import gov.va.med.vistalink.security.m.VistaInstitutionVO;
import gov.va.med.xml.XmlUtilities;
import java.util.Hashtable;
import java.util.TreeMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class SecurityResponseFactory
extends VistaLinkResponseFactoryImpl {
    static final String GOV_VA_MED_SECURITY_RESPONSE = "gov.va.med.foundations.security.response";
    static final String GOV_VA_MED_SECURITY_ERROR = "gov.va.med.foundations.security.error";
    static final String GOV_VA_MED_SECURITY_FAULT = "gov.va.med.foundations.security.fault";
    static final String ERROR_MSG_SEC = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><VistaLink messageType=\"gov.va.med.foundations.security.fault";
    private static final Logger LOGGER = Logger.getLogger(SecurityResponseFactory.class);
    static final String RESULT_SUCCESS_STRING = "success";
    static final String RESULT_FAILURE_STRING = "failure";
    static final String RESULT_PARTIAL_STRING = "partialSuccess";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected VistaLinkResponseVO parseMessageBody(String rawXml, String filteredXml, Document doc, String messageType, VistaLinkRequestVO requestVO) throws FoundationsException {
        String securityMsgRequestType = null;
        String securityVersion = null;
        if (!messageType.equals(GOV_VA_MED_SECURITY_ERROR)) {
            if (!messageType.equals(GOV_VA_MED_SECURITY_RESPONSE)) throw new FoundationsException("Unknown Response Message Type Returned: " + messageType);
        }
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node securityInfoNode = (Node)xpath.evaluate("/VistaLink/SecurityInfo/.", doc, XPathConstants.NODE);
            securityVersion = ((Attr)securityInfoNode.getAttributes().getNamedItem("version")).getValue();
            if (messageType.equals(GOV_VA_MED_SECURITY_RESPONSE)) {
                xpath = XPathFactory.newInstance().newXPath();
                NodeList responseNodeList = (NodeList)xpath.evaluate("/VistaLink/Response/.", doc, XPathConstants.NODESET);
                Node responseNode = responseNodeList.getLength() > 0 ? responseNodeList.item(0) : null;
                securityMsgRequestType = ((Attr)responseNode.getAttributes().getNamedItem("type")).getValue();
                return this.getResponseData(securityMsgRequestType, rawXml, doc);
            } else {
                if (!messageType.equals(GOV_VA_MED_SECURITY_ERROR)) return this.getResponseData(securityMsgRequestType, rawXml, doc);
                this.handleFault(doc, messageType);
            }
            return this.getResponseData(securityMsgRequestType, rawXml, doc);
        }
        catch (XPathExpressionException e) {
            throw new FoundationsException("Error parsing security response", (Throwable)e);
        }
        catch (VistaLinkFaultException e) {
            throw new FoundationsException("Error parsing security response", (Throwable)((Object)e));
        }
    }

    protected boolean doesResponseIndicateFault(String rawXml) {
        return rawXml.startsWith(ERROR_MSG_SEC);
    }

    private SecurityResponse getResponseData(String securityMsgRequestType, String rawXml, Document xdoc) throws FoundationsException {
        try {
            if (securityMsgRequestType.equals("AV.SetupAndIntroText")) {
                return this.getSetupAndIntroTextData(rawXml, xdoc);
            }
            if (securityMsgRequestType.equals("AV.Logon")) {
                return this.getLogonData(rawXml, xdoc);
            }
            if (securityMsgRequestType.equals("AV.SelectDivision")) {
                return this.getSelectDivisionData(rawXml, xdoc);
            }
            if (securityMsgRequestType.equals("AV.UpdateVC")) {
                return this.getUpdateVerifyCodeData(rawXml, xdoc);
            }
            if (securityMsgRequestType.equals("AV.Logout")) {
                return this.getLogoutData(rawXml, xdoc);
            }
            if (securityMsgRequestType.equals("AV.GetUserDemographics")) {
                return this.getUserDemographicsData(rawXml, xdoc);
            }
            throw new FoundationsException("Unknown security message action: " + securityMsgRequestType);
        }
        catch (XPathExpressionException e) {
            throw new FoundationsException("Failure while parsing security response", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SecurityDataLogonResponse getLogonData(String rawXml, Document xdoc) throws XPathExpressionException, FoundationsException {
        SecurityResponse responseData = this.getBaseInformationFromMessage(rawXml, xdoc, "AV.Logon");
        boolean needNewVerifyCode = false;
        boolean needDivisionSelection = false;
        TreeMap divisionList = null;
        String postSignInText = "";
        String cvcHelpText = "";
        if (responseData.getResultType() == 1) {
            postSignInText = this.subGetPostSignInTextLines(xdoc);
            return new SecurityDataLogonResponse(needNewVerifyCode, needDivisionSelection, divisionList, postSignInText, cvcHelpText, responseData);
        }
        if (responseData.getResultType() == 0) return new SecurityDataLogonResponse(needNewVerifyCode, needDivisionSelection, divisionList, postSignInText, cvcHelpText, responseData);
        if (responseData.getResultType() == 2) {
            postSignInText = this.subGetPostSignInTextLines(xdoc);
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList partialNodeList = (NodeList)xpath.evaluate("/VistaLink/Response/PartialSuccessData/.", xdoc, XPathConstants.NODESET);
            Node partialNode = partialNodeList.getLength() > 0 ? partialNodeList.item(0) : null;
            try {
                needNewVerifyCode = Boolean.valueOf(((Attr)partialNode.getAttributes().getNamedItem("changeVerify")).getValue());
                cvcHelpText = ((Attr)partialNode.getAttributes().getNamedItem("cvcHelpText")).getValue();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (needNewVerifyCode) return new SecurityDataLogonResponse(needNewVerifyCode, needDivisionSelection, divisionList, postSignInText, cvcHelpText, responseData);
            needDivisionSelection = this.subGetNeedDivisionSelection(xdoc);
            if (!needDivisionSelection) throw new FoundationsException("AV.Logon message was partial success, but without an indicator to either select division or change verify code!");
            divisionList = this.subGetDivisionList(xdoc);
            if (!divisionList.isEmpty()) return new SecurityDataLogonResponse(needNewVerifyCode, needDivisionSelection, divisionList, postSignInText, cvcHelpText, responseData);
            throw new FoundationsException("AV.Logon message requested division selection, but provided no divisions to select from.");
        }
        if (responseData.getResultType() == 1) return new SecurityDataLogonResponse(needNewVerifyCode, needDivisionSelection, divisionList, postSignInText, cvcHelpText, responseData);
        throw new FoundationsException("AV.Logon message has unknown security response type: " + responseData.getResultType());
    }

    private SecurityDataSelectDivisionResponse getSelectDivisionData(String rawXml, Document xdoc) throws XPathExpressionException, FoundationsException {
        SecurityResponse responseData = this.getBaseInformationFromMessage(rawXml, xdoc, "AV.SelectDivision");
        SecurityDataSelectDivisionResponse selectDivisionData = new SecurityDataSelectDivisionResponse(responseData);
        return selectDivisionData;
    }

    private SecurityDataChangeVcResponse getUpdateVerifyCodeData(String rawXml, Document xdoc) throws XPathExpressionException, FoundationsException {
        SecurityResponse responseData = this.getBaseInformationFromMessage(rawXml, xdoc, "AV.UpdateVC");
        TreeMap divisionList = null;
        boolean needDivisionSelection = false;
        if (responseData.getResultType() != 0) {
            if (responseData.getResultType() == 2) {
                if (this.subGetNeedDivisionSelection(xdoc)) {
                    needDivisionSelection = true;
                    divisionList = this.subGetDivisionList(xdoc);
                    if (divisionList.isEmpty()) {
                        throw new FoundationsException("AV.UpdateVC message requested division selection, but provided no divisions to select from.");
                    }
                }
            } else if (responseData.getResultType() != 1) {
                throw new FoundationsException("AV.UpdateVC message has unknown type for Update Verify Code request: " + responseData.getResultType());
            }
        }
        return new SecurityDataChangeVcResponse(needDivisionSelection, divisionList, responseData);
    }

    private String subGetPostSignInTextLines(Document xdoc) throws XPathExpressionException {
        Node messageNode;
        StringBuffer sb = new StringBuffer();
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList messageNodeList = (NodeList)xpath.evaluate("/VistaLink/Response/PostSignInText/.", xdoc, XPathConstants.NODESET);
        Node node = messageNode = messageNodeList.getLength() > 0 ? messageNodeList.item(0) : null;
        if (messageNode != null && messageNode.getNodeType() == 1) {
            NodeList messageLineList = messageNode.getChildNodes();
            for (int i = 0; i < messageLineList.getLength(); ++i) {
                NodeList messageLineText;
                Node messageLineNode = messageLineList.item(i);
                if (!messageLineNode.getNodeName().equals("Line") || messageLineNode.getNodeType() != 1 || (messageLineText = messageLineNode.getChildNodes()).getLength() <= 0) continue;
                for (int j = 0; j < messageLineText.getLength(); ++j) {
                    sb.append(((Text)messageLineText.item(j)).getData());
                    sb.append('\n');
                }
            }
        }
        return sb.toString();
    }

    private SecurityResponse getBaseInformationFromMessage(String rawXml, Document xdoc, String securityMsgRequestType) throws XPathExpressionException, FoundationsException {
        NodeList resultMessageNodeList;
        int resultValue = -1;
        String resultMessage = "";
        String resultTypeString = "";
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList responseNodeList = (NodeList)xpath.evaluate("/VistaLink/Response/.", xdoc, XPathConstants.NODESET);
        Node responseNode = responseNodeList.getLength() > 0 ? responseNodeList.item(0) : null;
        resultTypeString = ((Attr)responseNode.getAttributes().getNamedItem("status")).getValue();
        if (resultTypeString.equals(RESULT_FAILURE_STRING)) {
            Node resultMessageNode;
            resultValue = 0;
            xpath = XPathFactory.newInstance().newXPath();
            resultMessageNodeList = (NodeList)xpath.evaluate("/VistaLink/Response/Message/text()", xdoc, XPathConstants.NODESET);
            Node node = resultMessageNode = resultMessageNodeList.getLength() > 0 ? resultMessageNodeList.item(0) : null;
            if (resultMessageNode != null && resultMessageNode.getNodeType() == 3) {
                resultMessage = ((Text)resultMessageNode).getData();
            }
        } else if (resultTypeString.equals(RESULT_PARTIAL_STRING)) {
            Node resultMessageNode;
            resultValue = 2;
            xpath = XPathFactory.newInstance().newXPath();
            resultMessageNodeList = (NodeList)xpath.evaluate("/VistaLink/Response/Message/text()", xdoc, XPathConstants.NODESET);
            Node node = resultMessageNode = resultMessageNodeList.getLength() > 0 ? resultMessageNodeList.item(0) : null;
            if (resultMessageNode != null && resultMessageNode.getNodeType() == 3) {
                resultMessage = ((Text)resultMessageNode).getData();
            }
        } else if (resultTypeString.equals(RESULT_SUCCESS_STRING)) {
            resultValue = 1;
        } else {
            throw new FoundationsException(securityMsgRequestType + " message has unknown result type: " + resultTypeString);
        }
        SecurityResponse responseData = new SecurityResponse(resultValue, resultMessage, rawXml);
        return responseData;
    }

    private boolean subGetNeedDivisionSelection(Document xdoc) throws XPathExpressionException {
        boolean returnValue = false;
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList partialNodeList = (NodeList)xpath.evaluate("/VistaLink/Response/PartialSuccessData/.", xdoc, XPathConstants.NODESET);
        Node partialNode = partialNodeList.getLength() > 0 ? partialNodeList.item(0) : null;
        try {
            returnValue = Boolean.valueOf(((Attr)partialNode.getAttributes().getNamedItem("needDivisionSelection")).getValue());
        }
        catch (Exception e) {
            // empty catch block
        }
        return returnValue;
    }

    private TreeMap subGetDivisionList(Document xdoc) throws XPathExpressionException {
        Node divisionsNode;
        TreeMap<String, VistaInstitutionVO> divisionList = new TreeMap<String, VistaInstitutionVO>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList divisionsNodeList = (NodeList)xpath.evaluate("/VistaLink/Response/PartialSuccessData/Divisions/.", xdoc, XPathConstants.NODESET);
        Node node = divisionsNode = divisionsNodeList.getLength() > 0 ? divisionsNodeList.item(0) : null;
        if (divisionsNode != null && divisionsNode.getNodeType() == 1) {
            NodeList divisionNodeList = divisionsNode.getChildNodes();
            for (int i = 0; i < divisionNodeList.getLength(); ++i) {
                Node divisionNode = divisionNodeList.item(i);
                if (!divisionNode.getNodeName().equals("Division") || divisionNode.getNodeType() != 1) continue;
                String strDivisionIen = ((Attr)divisionNode.getAttributes().getNamedItem("ien")).getValue();
                String strDivisionName = ((Attr)divisionNode.getAttributes().getNamedItem("divName")).getValue();
                String strDivisionNumber = ((Attr)divisionNode.getAttributes().getNamedItem("divNumber")).getValue();
                boolean isDefaultDivision = false;
                if ((Attr)divisionNode.getAttributes().getNamedItem("default") != null) {
                    String isDefaultDivisionString = ((Attr)divisionNode.getAttributes().getNamedItem("default")).getValue();
                    isDefaultDivision = isDefaultDivisionString.equals("true");
                }
                divisionList.put(strDivisionNumber, new VistaInstitutionVO(strDivisionIen, strDivisionName, strDivisionNumber, isDefaultDivision));
            }
        }
        return divisionList;
    }

    private SecurityDataUserDemographicsResponse getUserDemographicsData(String rawXml, Document xdoc) throws XPathExpressionException, FoundationsException {
        SecurityResponse responseData = this.getBaseInformationFromMessage(rawXml, xdoc, "AV.GetUserDemographics");
        Hashtable<String, String> userDemographicsHashtable = new Hashtable<String, String>();
        if (responseData.getResultType() != 1) {
            throw new FoundationsException("AV.GetUserDemographics message has unknown result type: " + responseData.getResultType());
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList nameInfoNodeList = (NodeList)xpath.evaluate("/VistaLink/Response/NameInfo/.", xdoc, XPathConstants.NODESET);
        Node nameInfoNode = nameInfoNodeList.getLength() > 0 ? nameInfoNodeList.item(0) : null;
        userDemographicsHashtable.put("KEY_NAME_NEWPERSON01", XmlUtilities.getAttr((Node)nameInfoNode, (String)"newPerson01Name").getValue());
        userDemographicsHashtable.put("KEY_NAME_DISPLAY", XmlUtilities.getAttr((Node)nameInfoNode, (String)"standardConcatenated").getValue());
        userDemographicsHashtable.put("KEY_NAME_FAMILYLAST", XmlUtilities.getAttr((Node)nameInfoNode, (String)"familyLast").getValue());
        userDemographicsHashtable.put("KEY_NAME_GIVENFIRST", XmlUtilities.getAttr((Node)nameInfoNode, (String)"givenFirst").getValue());
        userDemographicsHashtable.put("KEY_NAME_MIDDLE", XmlUtilities.getAttr((Node)nameInfoNode, (String)"middle").getValue());
        userDemographicsHashtable.put("KEY_NAME_PREFIX", XmlUtilities.getAttr((Node)nameInfoNode, (String)"prefix").getValue());
        userDemographicsHashtable.put("KEY_NAME_SUFFIX", XmlUtilities.getAttr((Node)nameInfoNode, (String)"suffix").getValue());
        userDemographicsHashtable.put("KEY_NAME_DEGREE", XmlUtilities.getAttr((Node)nameInfoNode, (String)"degree").getValue());
        xpath = XPathFactory.newInstance().newXPath();
        NodeList userInfoNodeList = (NodeList)xpath.evaluate("/VistaLink/Response/UserInfo/.", xdoc, XPathConstants.NODESET);
        Node userInfoNode = userInfoNodeList.getLength() > 0 ? userInfoNodeList.item(0) : null;
        userDemographicsHashtable.put("KEY_DUZ", XmlUtilities.getAttr((Node)userInfoNode, (String)"duz").getValue());
        userDemographicsHashtable.put("KEY_DTIME", XmlUtilities.getAttr((Node)userInfoNode, (String)"timeout").getValue());
        userDemographicsHashtable.put("KEY_TITLE", XmlUtilities.getAttr((Node)userInfoNode, (String)"title").getValue());
        userDemographicsHashtable.put("KEY_SERVICE_SECTION", XmlUtilities.getAttr((Node)userInfoNode, (String)"serviceSection").getValue());
        userDemographicsHashtable.put("KEY_LANGUAGE", XmlUtilities.getAttr((Node)userInfoNode, (String)"language").getValue());
        userDemographicsHashtable.put("KEY_VPID", XmlUtilities.getAttr((Node)userInfoNode, (String)"vpid").getValue());
        xpath = XPathFactory.newInstance().newXPath();
        NodeList divisionInfoNodeList = (NodeList)xpath.evaluate("/VistaLink/Response/Division/.", xdoc, XPathConstants.NODESET);
        Node divisionInfoNode = divisionInfoNodeList.getLength() > 0 ? divisionInfoNodeList.item(0) : null;
        userDemographicsHashtable.put("KEY_DIVISION_IEN", XmlUtilities.getAttr((Node)divisionInfoNode, (String)"ien").getValue());
        userDemographicsHashtable.put("KEY_DIVISION_STATION_NAME", XmlUtilities.getAttr((Node)divisionInfoNode, (String)"divName").getValue());
        userDemographicsHashtable.put("KEY_DIVISION_STATION_NUMBER", XmlUtilities.getAttr((Node)divisionInfoNode, (String)"divNumber").getValue());
        xpath = XPathFactory.newInstance().newXPath();
        NodeList siteInfoNodeList = (NodeList)xpath.evaluate("/VistaLink/Response/SiteInfo/.", xdoc, XPathConstants.NODESET);
        Node siteInfoNode = siteInfoNodeList.getLength() > 0 ? siteInfoNodeList.item(0) : null;
        userDemographicsHashtable.put("KEY_DOMAIN_NAME", XmlUtilities.getAttr((Node)siteInfoNode, (String)"domainName").getValue());
        SecurityDataUserDemographicsResponse userDemographicsData = new SecurityDataUserDemographicsResponse(userDemographicsHashtable, responseData);
        return userDemographicsData;
    }

    private SecurityDataLogoutResponse getLogoutData(String rawXml, Document xdoc) throws XPathExpressionException, FoundationsException {
        SecurityResponse responseData = this.getBaseInformationFromMessage(rawXml, xdoc, "AV.Logout");
        SecurityDataLogoutResponse logoutData = new SecurityDataLogoutResponse(responseData);
        return logoutData;
    }

    private SecurityDataSetupAndIntroTextResponse getSetupAndIntroTextData(String rawXml, Document xdoc) throws XPathExpressionException, FoundationsException {
        NodeList cdataNodeList;
        SecurityResponse responseData = this.getBaseInformationFromMessage(rawXml, xdoc, "AV.SetupAndIntroText");
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList setupInfoNodeList = (NodeList)xpath.evaluate("/VistaLink/Response/SetupInfo/.", xdoc, XPathConstants.NODESET);
        Node setupInfoNode = setupInfoNodeList.getLength() > 0 ? setupInfoNodeList.item(0) : null;
        SecurityVOSetupAndIntroText setupAndIntroTextInfo = new SecurityVOSetupAndIntroText();
        setupAndIntroTextInfo.setServerName(XmlUtilities.getAttr((Node)setupInfoNode, (String)"serverName").getValue());
        setupAndIntroTextInfo.setVolume(XmlUtilities.getAttr((Node)setupInfoNode, (String)"volume").getValue());
        setupAndIntroTextInfo.setUci(XmlUtilities.getAttr((Node)setupInfoNode, (String)"uci").getValue());
        setupAndIntroTextInfo.setDevice(XmlUtilities.getAttr((Node)setupInfoNode, (String)"device").getValue());
        try {
            setupAndIntroTextInfo.setTimeout(Integer.parseInt(XmlUtilities.getAttr((Node)setupInfoNode, (String)"dtime").getValue()));
        }
        catch (NumberFormatException e) {
            String errMsg = "No timeout value was returned from the M server.";
            if (LOGGER.isEnabledFor((Priority)Level.ERROR)) {
                LOGGER.error((Object)errMsg, (Throwable)e);
            }
            throw new FoundationsException(errMsg, (Throwable)e);
        }
        try {
            setupAndIntroTextInfo.setLogonRetryCount(Integer.parseInt(XmlUtilities.getAttr((Node)setupInfoNode, (String)"numberAttempts").getValue()));
        }
        catch (NumberFormatException e) {
            String errMsg = "No login retry count was returned from the M server.";
            if (LOGGER.isEnabledFor((Priority)Level.ERROR)) {
                LOGGER.error((Object)errMsg, (Throwable)e);
            }
            throw new FoundationsException(errMsg, (Throwable)e);
        }
        NodeList introNodeList = xdoc.getDocumentElement().getElementsByTagName("IntroText");
        if (introNodeList.getLength() == 1 && (cdataNodeList = introNodeList.item(0).getChildNodes()).getLength() == 1 && cdataNodeList.item(0).getNodeType() == 4) {
            setupAndIntroTextInfo.setIntroductoryText(cdataNodeList.item(0).getNodeValue());
        }
        SecurityDataSetupAndIntroTextResponse setupAndIntroTextData = new SecurityDataSetupAndIntroTextResponse(setupAndIntroTextInfo, responseData);
        return setupAndIntroTextData;
    }

    protected VistaLinkFaultException handleSpecificFault(Document xdoc, String messageType, VistaLinkFaultException faultException) throws VistaLinkFaultException, FoundationsException {
        if ("183005".equals(faultException.getErrorCode())) {
            return new SecurityTooManyInvalidLoginAttemptsFaultException(faultException);
        }
        if ("182306".equals(faultException.getErrorCode())) {
            return new SecurityIPLockedFaultException(faultException);
        }
        if ("183007".equals(faultException.getErrorCode())) {
            return new SecurityProductionMismatchException(faultException);
        }
        if ("183008".equals(faultException.getErrorCode())) {
            return new SecurityConnectionProxyException(faultException);
        }
        if ("183010".equals(faultException.getErrorCode())) {
            return new SecurityPrimaryStationMismatchException(faultException);
        }
        if ("183".equals(faultException.getErrorCode().substring(0, 3))) {
            return new SecurityFaultException(faultException);
        }
        return null;
    }
}

