/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.management;

import gov.va.med.environment.Environment;
import gov.va.med.environment.ServerType;
import gov.va.med.vistalink.jmx.IJmxHelper;
import gov.va.med.vistalink.jmx.JmxHelperException;
import gov.va.med.vistalink.jmx.JmxHelperFactory;
import gov.va.med.vistalink.management.VistaLinkConnector;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.log4j.Logger;

public class VistaLinkConnectorNotificationListener
implements NotificationListener {
    private static final Logger logger = Logger.getLogger(VistaLinkConnectorNotificationListener.class);
    private static final String WEBLOGIC_OUTBOUND_CONNECTION_POOL_MBEAN_TYPE = "ConnectorConnectionPoolRuntime";
    private static final String WEBLOGIC_JNDINAME_ATTRIBUTE = "JNDIName";
    private static final String WEBLOGIC_EISTYPE_ATTRIBUTE = "ConnectorEisType";
    private static final String WEBLOGIC_JNDINAME_BACKUP_PROP = "Name";
    private static final String JMX_ONAME_NAME_ATTR = "Name";
    private static final String JMX_ONAME_TYPE_ATTR = "Type";
    private Map connectorMBeanMap = Collections.synchronizedMap(new HashMap());
    private static final String TEXT_PROB_REG = "Problem registering VL MBean ";
    private static final String TEXT_BACKUP_ATTR = "Could not retrieve ConnectorConnectionPoolRuntime jndiName attribute, using Name attribute";
    private static IJmxHelper jmxHelper;
    private static MBeanServer localMBeanServer;

    public void handleNotification(Notification notification, Object obj) {
        MBeanServerNotification mbsNotification;
        ObjectName notificationObjectName;
        String mBeanType;
        if (!ServerType.WEBLOGIC.equals(Environment.getServerType())) {
            logger.warn((Object)"cannot currently create VistaLinkConnector MBeans on non-WebLogic servers");
            return;
        }
        if (notification instanceof MBeanServerNotification && WEBLOGIC_OUTBOUND_CONNECTION_POOL_MBEAN_TYPE.equals(mBeanType = (notificationObjectName = (mbsNotification = (MBeanServerNotification)notification).getMBeanName()).getKeyProperty(JMX_ONAME_TYPE_ATTR))) {
            logger.debug((Object)("MBean type '" + mBeanType + "' was '" + mbsNotification.getType() + "': " + notificationObjectName));
            logger.debug((Object)("Event type: '" + mbsNotification.getType() + "', seq: '" + mbsNotification.getSequenceNumber() + "', tstamp: '" + mbsNotification.getTimeStamp() + "', class: '" + mbsNotification.getClass() + "', source: '" + mbsNotification.getSource() + "', message: '" + mbsNotification.getMessage() + "', userdata: '" + mbsNotification.getUserData()));
            if ("JMX.mbean.registered".equals(mbsNotification.getType())) {
                this.processCandidateMBean(notificationObjectName);
            } else if ("JMX.mbean.unregistered".equals(mbsNotification.getType())) {
                this.removeMBean(notificationObjectName);
            } else {
                logger.warn((Object)("Received unknown MBeanServerNotification type: " + mbsNotification.getType()));
            }
        }
    }

    public void performInitialScan() {
        if (!ServerType.WEBLOGIC.equals(Environment.getServerType())) {
            logger.warn((Object)"cannot currently create VistaLinkConnector MBeans on non-WebLogic servers");
            return;
        }
        try {
            ObjectName connectorQueryName = new ObjectName(jmxHelper.getJmxDomainForPlatform() + ":" + JMX_ONAME_TYPE_ATTR + "=" + WEBLOGIC_OUTBOUND_CONNECTION_POOL_MBEAN_TYPE + ",*");
            Set<ObjectName> connectorMBeanSet = localMBeanServer.queryNames(connectorQueryName, null);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("found " + connectorMBeanSet.size() + " " + WEBLOGIC_OUTBOUND_CONNECTION_POOL_MBEAN_TYPE + " mbeans"));
            }
            Iterator<ObjectName> connectorIter = connectorMBeanSet.iterator();
            while (connectorIter.hasNext()) {
                this.processCandidateMBean(connectorIter.next());
            }
        }
        catch (MalformedObjectNameException e) {
            logger.error((Object)"Error doing notification initial scan.", (Throwable)e);
        }
        catch (NullPointerException e) {
            logger.error((Object)"Error doing notification initial scan.", (Throwable)e);
        }
    }

    private void processCandidateMBean(ObjectName connectorObjectName) {
        block16: {
            if (this.connectorMBeanMap.containsKey(connectorObjectName)) {
                logger.warn((Object)("connector Map already contains connector name '" + connectorObjectName + "'. Skipping."));
            } else {
                ObjectName vlcObjectName = null;
                try {
                    if (!"VistA".equals(localMBeanServer.getAttribute(connectorObjectName, WEBLOGIC_EISTYPE_ATTRIBUTE))) break block16;
                    StringBuffer sb = new StringBuffer(jmxHelper.getJmxDomainForHev()).append(":");
                    String connObjectName = connectorObjectName.getKeyProperty("Name").replace("/", "_");
                    sb.append("Name").append("=VistaLink_").append(connObjectName);
                    sb.append(',').append(JMX_ONAME_TYPE_ATTR).append('=').append(VistaLinkConnector.getMBeanType());
                    String additionalProps = jmxHelper.getServerObjectNamePropertiesForRegistration();
                    if (additionalProps.length() > 0) {
                        sb.append(',').append(additionalProps);
                    }
                    vlcObjectName = new ObjectName(sb.toString());
                    String jndiName = "";
                    try {
                        jndiName = (String)localMBeanServer.getAttribute(connectorObjectName, WEBLOGIC_JNDINAME_ATTRIBUTE);
                        if (jndiName == null || jndiName.length() < 1) {
                            logger.warn((Object)TEXT_BACKUP_ATTR);
                            jndiName = connectorObjectName.getKeyProperty("Name");
                        }
                    }
                    catch (AttributeNotFoundException e) {
                        logger.warn((Object)TEXT_BACKUP_ATTR);
                        jndiName = connectorObjectName.getKeyProperty("Name");
                    }
                    catch (InstanceNotFoundException e) {
                        logger.warn((Object)TEXT_BACKUP_ATTR);
                        jndiName = connectorObjectName.getKeyProperty("Name");
                    }
                    catch (MBeanException e) {
                        logger.warn((Object)TEXT_BACKUP_ATTR);
                        jndiName = connectorObjectName.getKeyProperty("Name");
                    }
                    catch (ReflectionException e) {
                        logger.warn((Object)TEXT_BACKUP_ATTR);
                        jndiName = connectorObjectName.getKeyProperty("Name");
                    }
                    logger.debug((Object)("got JNDI name: '" + jndiName + "'."));
                    VistaLinkConnector vlMBean = new VistaLinkConnector(jndiName, connectorObjectName, localMBeanServer);
                    localMBeanServer.registerMBean(vlMBean, vlcObjectName);
                    logger.debug((Object)("new VL MBean '" + vlcObjectName.getCanonicalName() + "' registered."));
                    this.connectorMBeanMap.put(connectorObjectName, vlcObjectName);
                }
                catch (MalformedObjectNameException e) {
                    logger.error((Object)(TEXT_PROB_REG + vlcObjectName), (Throwable)e);
                }
                catch (InstanceAlreadyExistsException e) {
                    logger.error((Object)(TEXT_PROB_REG + vlcObjectName), (Throwable)e);
                }
                catch (MBeanRegistrationException e) {
                    logger.error((Object)(TEXT_PROB_REG + vlcObjectName), (Throwable)e);
                }
                catch (NotCompliantMBeanException e) {
                    logger.error((Object)(TEXT_PROB_REG + vlcObjectName), (Throwable)e);
                }
                catch (NullPointerException e) {
                    logger.error((Object)(TEXT_PROB_REG + vlcObjectName), (Throwable)e);
                }
                catch (Exception e) {
                    logger.error((Object)(TEXT_PROB_REG + vlcObjectName), (Throwable)e);
                }
            }
        }
    }

    private void removeMBean(ObjectName notificationObjectName) {
        if (this.connectorMBeanMap.containsKey(notificationObjectName)) {
            ObjectName vlObjectName = (ObjectName)this.connectorMBeanMap.get(notificationObjectName);
            logger.debug((Object)("removing from container MBean list: " + notificationObjectName.getCanonicalName()));
            this.connectorMBeanMap.remove(notificationObjectName);
            try {
                localMBeanServer.unregisterMBean(vlObjectName);
                logger.debug((Object)("unregistered VL MBean " + vlObjectName));
            }
            catch (InstanceNotFoundException e) {
                logger.error((Object)("Could not unregister VL MBean " + vlObjectName), (Throwable)e);
            }
            catch (MBeanRegistrationException e) {
                logger.error((Object)("Could not unregister VL MBean " + vlObjectName), (Throwable)e);
            }
        } else {
            logger.warn((Object)("could not match MBean unregistration with list item: " + notificationObjectName.getCanonicalName()));
        }
    }

    static {
        try {
            jmxHelper = JmxHelperFactory.getJmxHelper();
            localMBeanServer = jmxHelper.getLocalMBeanServer();
        }
        catch (JmxHelperException e) {
            logger.error((Object)"Could not get reference to local MBeanServer.", (Throwable)e);
        }
    }
}

