/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.institution;

import gov.va.med.vistalink.institution.IPrimaryStationRules;
import gov.va.med.vistalink.institution.InstitutionMappingBadStationNumberException;

public class PrimaryStationRulesVHA
implements IPrimaryStationRules {
    public String getPrimaryStationLookupString(String division) throws InstitutionMappingBadStationNumberException {
        int nextDigitPosToTest;
        if (division == null) {
            throw new InstitutionMappingBadStationNumberException("input cannot be null");
        }
        if (division.length() < 1) {
            throw new InstitutionMappingBadStationNumberException("input cannot be empty string");
        }
        String returnVal = null;
        for (nextDigitPosToTest = 0; nextDigitPosToTest < division.length() && Character.isDigit(division.charAt(nextDigitPosToTest)); ++nextDigitPosToTest) {
        }
        int lastDigitPos = nextDigitPosToTest - 1;
        if (lastDigitPos == 3 && division.charAt(3) == '9') {
            returnVal = division.substring(0, 3);
        } else if (division.charAt(0) == '2' && lastDigitPos == 2 && division.length() > lastDigitPos) {
            returnVal = division;
        } else if (lastDigitPos == 2 || lastDigitPos >= 4) {
            returnVal = division.substring(0, nextDigitPosToTest);
        } else {
            throw new InstitutionMappingBadStationNumberException("Invalid station number format: '" + division + "'.");
        }
        return returnVal;
    }

    public void validatePrimaryStation(String primaryStation) throws InstitutionMappingBadStationNumberException {
        int nextDigitPosToTest;
        if (primaryStation == null) {
            throw new InstitutionMappingBadStationNumberException("input cannot be null");
        }
        for (nextDigitPosToTest = 0; nextDigitPosToTest < primaryStation.length() && Character.isDigit(primaryStation.charAt(nextDigitPosToTest)); ++nextDigitPosToTest) {
        }
        int lastDigitPos = nextDigitPosToTest - 1;
        if (lastDigitPos < 2) {
            throw new InstitutionMappingBadStationNumberException("Station Number '" + primaryStation + "' not valid; numeric portion must be at least 3 digits.");
        }
        if (lastDigitPos + 1 < primaryStation.length()) {
            if (lastDigitPos != 2) {
                throw new InstitutionMappingBadStationNumberException("Station Number '" + primaryStation + "' not valid; only stations in the 200 range can have a non-numeric suffix.");
            }
            if (primaryStation.charAt(0) != '2') {
                throw new InstitutionMappingBadStationNumberException("Station Number '" + primaryStation + "' not valid; only stations in the 200 range can have a non-numeric suffix.");
            }
        }
        if (lastDigitPos == 3) {
            if (primaryStation.charAt(3) == '9') {
                throw new InstitutionMappingBadStationNumberException("Station Number '" + primaryStation + "' not valid; if 4th digit is '9', it is treated as a suffix and cannot be part of primary station #.");
            }
            throw new InstitutionMappingBadStationNumberException("Station Number '" + primaryStation + "' not valid; 3 or 5+ digits only for VHA station #s.");
        }
    }
}

