/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.institution;

import gov.va.med.vistalink.institution.InstitutionMapNotInitializedException;
import gov.va.med.vistalink.institution.InstitutionMapping;
import gov.va.med.vistalink.institution.InstitutionMappingBadStationNumberException;
import gov.va.med.vistalink.institution.InstitutionMappingFactory;
import gov.va.med.vistalink.institution.InstitutionMappingNotFoundException;
import java.util.Set;

public class InstitutionMappingDelegate {
    private InstitutionMappingDelegate() {
    }

    public static String getJndiConnectorNameForInstitution(String stationNumber) throws InstitutionMapNotInitializedException, InstitutionMappingNotFoundException {
        InstitutionMapping im = InstitutionMappingFactory.getInstitutionMapping();
        try {
            return im.getJndiConnectorNameForInstitution(stationNumber);
        }
        catch (InstitutionMappingBadStationNumberException e) {
            throw new InstitutionMappingNotFoundException("Invalid station number format: '" + stationNumber + "'.");
        }
    }

    public static Set getVistaLinkMappedStationNumberSet() throws InstitutionMapNotInitializedException {
        Set returnVal = null;
        InstitutionMapping im = InstitutionMappingFactory.getInstitutionMapping();
        returnVal = im.getVistaLinkMappedStationNumberSet();
        return returnVal;
    }
}

