/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.cache;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class WeakValueMap
extends AbstractMap {
    private static final Logger logger = Logger.getLogger(WeakValueMap.class);
    private final Map map = new HashMap();
    private final ReferenceQueue queue = new ReferenceQueue();

    public Object get(Object key) {
        Object result = null;
        Reference ref = (Reference)this.map.get(key);
        if (ref != null && (result = ref.get()) == null) {
            logger.debug((Object)("map element <" + this.map.remove(key) + "> has been removed for the key: " + key));
        }
        return result;
    }

    public Set entrySet() {
        this.processQueue();
        return this.map.entrySet();
    }

    public String toString() {
        this.processQueue();
        return super.toString();
    }

    private void processQueue() {
        WeakValue sv = null;
        logger.debug((Object)"Processing the queue ...");
        while ((sv = (WeakValue)this.queue.poll()) != null) {
            this.map.remove(sv.key);
            logger.debug((Object)("Removed WeakValue: " + sv));
        }
    }

    public Object put(Object key, Object value) {
        this.processQueue();
        WeakValue sv = new WeakValue(value, key, this.queue);
        logger.debug((Object)("Putting a WeakValue: " + sv));
        return this.map.put(key, sv);
    }

    public Object remove(Object key) {
        this.processQueue();
        logger.debug((Object)("Removing WeakValue, based on key: " + key));
        return this.map.remove(key);
    }

    public void clear() {
        this.processQueue();
        this.map.clear();
    }

    public int size() {
        this.processQueue();
        return this.map.size();
    }

    private static class WeakValue
    extends WeakReference {
        private final Object key;

        private WeakValue(Object referent, Object key, ReferenceQueue q) {
            super(referent, q);
            this.key = key;
        }

        public String toString() {
            return "Key: " + this.key + ", Value: " + this.get();
        }
    }
}

