/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.adapter.spi;

import gov.va.med.exception.ExceptionUtils;
import gov.va.med.exception.FoundationsException;
import gov.va.med.vistalink.adapter.record.VistaLinkRequestVO;
import gov.va.med.vistalink.adapter.record.VistaLinkResponseFactoryImpl;
import gov.va.med.vistalink.adapter.record.VistaLinkResponseVO;
import gov.va.med.vistalink.adapter.spi.VistaLinkSystemInfoResponse;
import gov.va.med.vistalink.adapter.spi.VistaLinkSystemInfoVO;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VistaLinkSystemInfoResponseFactory
extends VistaLinkResponseFactoryImpl {
    private static final Logger logger = Logger.getLogger(VistaLinkSystemInfoResponseFactory.class);

    protected VistaLinkResponseVO parseMessageBody(String rawXml, String filteredXml, Document doc, String messageType, VistaLinkRequestVO requestVO) throws FoundationsException {
        try {
            NodeList cdataNodeList;
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList resultsNodeList = (NodeList)xpath.evaluate("/VistaLink/Response/SystemInfo/.", doc, XPathConstants.NODESET);
            Node resultsNode = resultsNodeList.getLength() > 0 ? resultsNodeList.item(0) : null;
            NamedNodeMap attrs = resultsNode.getAttributes();
            String deflt = "unknown";
            VistaLinkSystemInfoVO systemInfoVO = new VistaLinkSystemInfoVO();
            systemInfoVO.setVistalinkVersion(this.getAttributeValue(attrs, "vistalinkVersion", "unknown"));
            systemInfoVO.setVistalinkBuild(this.getAttributeValue(attrs, "vistalinkBuild", "unknown"));
            systemInfoVO.setAppServerTimeout(Long.parseLong(this.getAttributeValue(attrs, "appServerTimeout", "0")));
            systemInfoVO.setReAuthSessionTimeout(Long.parseLong(this.getAttributeValue(attrs, "reAuthSessionTimeout", "0")));
            systemInfoVO.setUci(this.getAttributeValue(attrs, "uci", "unknown"));
            systemInfoVO.setVol(this.getAttributeValue(attrs, "vol", "unknown"));
            systemInfoVO.setBoxVolume(this.getAttributeValue(attrs, "boxVolume", "unknown"));
            systemInfoVO.setMVersion(this.getAttributeValue(attrs, "mVersion", "unknown"));
            systemInfoVO.setOperatingSystem(this.getAttributeValue(attrs, "operatingSystem", "unknown"));
            systemInfoVO.setDomainName(this.getAttributeValue(attrs, "domainName", "unknown"));
            systemInfoVO.setVistaProduction(this.getAttributeValue(attrs, "vistaProduction", "unknown"));
            systemInfoVO.setDefaultInstitution(this.getAttributeValue(attrs, "defaultInstitution", "unknown"));
            systemInfoVO.setCpName(this.getAttributeValue(attrs, "cpName", "unknown"));
            NodeList introNodeList = doc.getDocumentElement().getElementsByTagName("IntroText");
            if (introNodeList.getLength() == 1 && (cdataNodeList = introNodeList.item(0).getChildNodes()).getLength() == 1 && cdataNodeList.item(0).getNodeType() == 4) {
                systemInfoVO.setIntroText(cdataNodeList.item(0).getNodeValue());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Retrieved system information response attributes");
            }
            return new VistaLinkSystemInfoResponse(rawXml, filteredXml, doc, messageType, systemInfoVO.toMap());
        }
        catch (XPathExpressionException e) {
            String errStr = "could not parse xml";
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                String errMsg = new StringBuffer().append(errStr).append("\n\t").append(ExceptionUtils.getFullStackTrace((Throwable)e)).toString();
                logger.error((Object)errMsg);
            }
            throw new FoundationsException(errStr, (Throwable)e);
        }
    }

    private String getAttributeValue(NamedNodeMap attrs, String attrName, String deflt) {
        Attr attr = null;
        attr = (Attr)attrs.getNamedItem(attrName);
        return attr != null ? attr.getValue() : deflt;
    }
}

