/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.adapter.spi;

import gov.va.med.environment.Environment;
import gov.va.med.environment.ServerType;
import gov.va.med.exception.ExceptionUtils;
import gov.va.med.exception.FoundationsException;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionFactory;
import gov.va.med.vistalink.adapter.cci.VistaLinkResourceException;
import gov.va.med.vistalink.adapter.heartbeat.VistaHeartBeatTimerManager;
import gov.va.med.vistalink.adapter.heartbeat.VistaHeartBeatTimerRequest;
import gov.va.med.vistalink.adapter.heartbeat.VistaHeartBeatTimerResponse;
import gov.va.med.vistalink.adapter.heartbeat.VistaHeartBeatTimerResponseFactory;
import gov.va.med.vistalink.adapter.spi.ConfigurationReader;
import gov.va.med.vistalink.adapter.spi.ConnectorConfigurator;
import gov.va.med.vistalink.adapter.spi.EMAdapterEnvironment;
import gov.va.med.vistalink.adapter.spi.VistaLinkConnectionRequestInfo;
import gov.va.med.vistalink.adapter.spi.VistaLinkManagedConnection;
import gov.va.med.vistalink.adapter.spi.VistaLinkSystemInfoVO;
import gov.va.med.vistalink.institution.InstitutionMapping;
import gov.va.med.vistalink.institution.InstitutionMappingFactory;
import gov.va.med.vistalink.jmx.IJmxHelper;
import gov.va.med.vistalink.jmx.JmxHelperException;
import gov.va.med.vistalink.jmx.JmxHelperFactory;
import gov.va.med.vistalink.management.VistaLinkConnectorNotificationListener;
import gov.va.med.vistalink.management.VistaLinkInstitutionMapping;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.security.auth.Subject;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class VistaLinkManagedConnectionFactory
implements ManagedConnectionFactory,
Serializable,
ValidatingManagedConnectionFactory {
    public static final String ADAPTER_VERSION = "1.6";
    public static final String ADAPTER_FULL_VERSION = "1.6.0.028";
    public static final String CONNECTOR_PROPERTY_NAME = "connectorJndiName";
    private static final String JMX_OBJECT_NAME_STRING_TYPE = "Type";
    private static final String JMX_OBJECT_NAME_STRING_NAME = "Name";
    private int hashCode;
    private static final long J2EE_DEFAULT_SOCKET_TIMEOUT = 10000L;
    private static final long J2SE_DEFAULT_SOCKET_TIMEOUT = 10000L;
    private static final Logger logger = Logger.getLogger(VistaLinkManagedConnectionFactory.class);
    private long defaultJ2EETimeOut = 10000L;
    private static long defaultJ2SETimeOut = 10000L;
    private static int socketTimeOutMultipler = 1;
    private boolean alwaysUseDefaultAsMin = true;
    private String hostIpAddress;
    private String primaryStation = "";
    private int hostPort;
    private String accessCode;
    private String verifyCode;
    private String connectorJndiName = "";
    private VistaLinkConnectionFactory cf;
    private boolean connectorEnabled = false;
    private int maxConnectionHandles = 1;
    private transient PrintWriter printWriter;
    private transient VistaHeartBeatTimerManager timerManager;
    private EMAdapterEnvironment adapterEnvironment = EMAdapterEnvironment.J2SE;
    private long managedConnectionCount = 0L;
    private Object mcCountSyncObj = new Object();
    private static long managedFactoryCount = 0L;
    private static Object mfCountSyncObj = new Object();
    private long distinguishedIdentifier = 0L;
    private long connectionFailureCount = 0L;
    private long connectionAuthFailureCount = 0L;
    private long divisionMismatchCount = 0L;
    private long identityFailureCount = 0L;
    private long productionMismatchCount = 0L;
    private Object healthSyncObj = new Object();
    private long createConnectionHandleCount = 0L;
    private long createConnectionHandleTotalMillis = 0L;
    private Object createConnectionHandleAvgSyncObj = new Object();
    private long matchManagedConnectionCount = 0L;
    private long matchManagedConnectionTotalMillis = 0L;
    private Object matchManagedConnectionAvgSyncObj = new Object();
    private String parseConfigFailureMessage = null;
    private HashSet mcSet = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VistaLinkManagedConnectionFactory() {
        Object object = mfCountSyncObj;
        synchronized (object) {
            this.distinguishedIdentifier = ++managedFactoryCount;
        }
        this.setHashCode();
        this.timerManager = new VistaHeartBeatTimerManager();
        this.timerManager.setAdapterEnvironment(this.adapterEnvironment);
        if (logger.isDebugEnabled()) {
            String debugMsg = this.getLoggerFormattedString("Constructed");
            logger.debug((Object)debugMsg);
        }
    }

    public Object createConnectionFactory(ConnectionManager mgr) throws ResourceException {
        if (logger.isDebugEnabled()) {
            String loggerMsg = this.getLoggerFormattedString("createConnectionFactory->managed");
            logger.debug((Object)loggerMsg);
        }
        this.cf = new VistaLinkConnectionFactory(this, mgr);
        return this.cf;
    }

    public Object createConnectionFactory() throws ResourceException {
        if (logger.isDebugEnabled()) {
            String loggerMsg = this.getLoggerFormattedString("createConnectionFactory->unmanaged");
            logger.debug((Object)loggerMsg);
        }
        this.cf = new VistaLinkConnectionFactory(this, null);
        return this.cf;
    }

    public VistaLinkSystemInfoVO getSystemInfo() {
        VistaLinkManagedConnection mc = null;
        VistaLinkSystemInfoVO systemInfoVO = null;
        try {
            mc = (VistaLinkManagedConnection)this.createManagedConnection(null, null);
            systemInfoVO = mc.executeSystemInfoInteraction().getSystemInfoVO();
            mc.destroy();
        }
        catch (Exception e) {
            logger.error((Object)e);
            systemInfoVO = new VistaLinkSystemInfoVO();
            systemInfoVO.setErrorMessage(e.getClass().getName() + ": " + e.getMessage());
        }
        return systemInfoVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        try {
            if (!this.connectorEnabled) {
                StringBuffer failureMessage = new StringBuffer("Connection factory for '");
                failureMessage.append(this.connectorJndiName);
                failureMessage.append("' did not successfully initialize; cannot create connection. Check log files for errors.");
                if (this.parseConfigFailureMessage != null) {
                    failureMessage.append(" Connection factory initialization failure was: '");
                    failureMessage.append(this.parseConfigFailureMessage);
                    failureMessage.append("'.");
                }
                failureMessage.append(" Try fixing condition and then redeploy connector.");
                throw new VistaLinkResourceException(failureMessage.toString());
            }
            long mcDistinguishedIdentifier = 0L;
            Object object = this.mcCountSyncObj;
            synchronized (object) {
                mcDistinguishedIdentifier = ++this.managedConnectionCount;
            }
            if (logger.isDebugEnabled()) {
                String loggerMsg = this.getLoggerFormattedString(new StringBuffer().append("Creating Managed connection->").append(mcDistinguishedIdentifier).toString());
                logger.debug((Object)loggerMsg);
            }
            VistaLinkManagedConnection mc = new VistaLinkManagedConnection(this, mcDistinguishedIdentifier);
            if (logger.isDebugEnabled()) {
                String loggerMsg = this.getLoggerFormattedString(new StringBuffer().append("Created Managed connection->").append(mcDistinguishedIdentifier).toString());
                logger.debug((Object)loggerMsg);
            }
            this.mcSet.add(mc);
            return mc;
        }
        catch (VistaLinkResourceException e) {
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                logger.error((Object)e.getMessage());
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                String loggerMsg = this.getLoggerFormattedStringWStackTrace("Unexpected exception occured in creatingManagedConnection()", e);
                logger.error((Object)loggerMsg);
            }
            throw new VistaLinkResourceException(e);
        }
    }

    protected void removeMc(VistaLinkManagedConnection mc) {
        this.mcSet.remove(mc);
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        String loggerMsg;
        long beginTimeMillis = System.currentTimeMillis();
        VistaLinkManagedConnection nullConnSpecConnection = null;
        VistaLinkManagedConnection lastConnection = null;
        VistaLinkManagedConnection returnConnection = null;
        boolean foundMatchWithOutConnSpec = false;
        if (logger.isDebugEnabled()) {
            loggerMsg = this.getLoggerFormattedString("matchManagedConnection: Pool Size: " + connectionSet.size());
            logger.debug((Object)loggerMsg);
        }
        VistaLinkConnectionRequestInfo vlConReqInfo = (VistaLinkConnectionRequestInfo)info;
        if (info != null && logger.isDebugEnabled()) {
            loggerMsg = this.getLoggerFormattedString(new StringBuffer().append("matchManagedConnection->").append(info.toString()).toString());
            logger.debug((Object)loggerMsg);
        }
        for (Object obj : connectionSet) {
            if (!(obj instanceof VistaLinkManagedConnection)) continue;
            VistaLinkManagedConnection mc = (VistaLinkManagedConnection)obj;
            if (logger.isDebugEnabled()) {
                loggerMsg = this.getLoggerFormattedString(new StringBuffer().append("matchManagedConnection->").append(mc.toString()).append("->").append(mc.getConnReqInfoString()).toString());
                logger.debug((Object)loggerMsg);
            }
            if (!this.mcSet.contains(mc)) continue;
            lastConnection = mc;
            if (vlConReqInfo.equals(mc.getConnReqInfo())) {
                if (logger.isDebugEnabled()) {
                    loggerMsg = this.getLoggerFormattedString(new StringBuffer().append("matchManagedConnection->Found match with matching connection request info->").append(mc.toString()).append("->").append(mc.getConnReqInfoString()).toString());
                    logger.debug((Object)loggerMsg);
                }
                long elapsedMillis = System.currentTimeMillis() - beginTimeMillis;
                this.addMatchManagedConnectionTime(elapsedMillis);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)this.getLoggerFormattedString(new StringBuffer().append("matchManagedConnections(...) processing time [match found] == ").append(elapsedMillis).toString()));
                }
                return mc;
            }
            if (foundMatchWithOutConnSpec) continue;
            if (mc.getConnReqInfo() == null) {
                foundMatchWithOutConnSpec = true;
                nullConnSpecConnection = mc;
            }
            if (!logger.isDebugEnabled()) continue;
            loggerMsg = this.getLoggerFormattedString(new StringBuffer().append("matchManagedConnection->no match on request info->").append(mc.toString()).append("->").append(mc.getConnReqInfoString()).toString());
            logger.debug((Object)loggerMsg);
        }
        returnConnection = nullConnSpecConnection != null ? nullConnSpecConnection : lastConnection;
        long elapsedMillis = System.currentTimeMillis() - beginTimeMillis;
        this.addMatchManagedConnectionTime(elapsedMillis);
        if (logger.isInfoEnabled()) {
            logger.info((Object)this.getLoggerFormattedString(new StringBuffer().append("matchManagedConnections(...) processing time [match not found] == ").append(elapsedMillis).toString()));
        }
        return returnConnection;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        if (this.printWriter == null) {
            String errMsg = "Log writer is null";
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                String loggerMsg = this.getLoggerFormattedString(errMsg);
                logger.error((Object)loggerMsg);
            }
            throw new VistaLinkResourceException(errMsg);
        }
        return this.printWriter;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.printWriter = out;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VistaLinkManagedConnectionFactory)) {
            return false;
        }
        VistaLinkManagedConnectionFactory objMcf = (VistaLinkManagedConnectionFactory)obj;
        return objMcf.distinguishedIdentifier == this.distinguishedIdentifier;
    }

    private void setHashCode() {
        int HASHCODE_SEED;
        int returnVal = HASHCODE_SEED = 17;
        int distIdHashCode = (int)(this.distinguishedIdentifier ^ this.distinguishedIdentifier >>> 32);
        this.hashCode = returnVal = 37 * returnVal + distIdHashCode;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public final String toString() {
        String adapterEnvironmentString = "";
        if (this.adapterEnvironment != null) {
            adapterEnvironmentString = this.adapterEnvironment.toString();
        }
        return new StringBuffer().append(this.getClass().getName()).append("[]").append(this.hostIpAddress).append("[]").append(this.hostPort).append("[]").append(this.maxConnectionHandles).append("[adapterversion]").append(ADAPTER_FULL_VERSION).append("[]").append(adapterEnvironmentString).append("[fdi]").append(this.distinguishedIdentifier).toString();
    }

    public int getMaxConnectionHandles() {
        return this.maxConnectionHandles;
    }

    private void setMaxConnectionHandles(int maxConnectionHandles) {
        this.maxConnectionHandles = maxConnectionHandles;
    }

    public int getHostPort() {
        return this.hostPort;
    }

    public void setNonManagedHostPort(int hostPort) {
        this.hostPort = hostPort;
        this.setJ2SEProperties();
    }

    public void setNonManagedHostIPAddress(String hostipaddress) {
        this.hostIpAddress = hostipaddress;
        this.setJ2SEProperties();
    }

    private String getHostIPAddress() {
        return this.hostIpAddress;
    }

    private String getLoggerFormattedString(String log) {
        return new StringBuffer().append(this.toString()).append("\n\t").append(log).toString();
    }

    private String getLoggerFormattedStringWStackTrace(Throwable e) {
        return this.getLoggerFormattedString(ExceptionUtils.getFullStackTrace((Throwable)e));
    }

    private String getLoggerFormattedStringWStackTrace(String log, Throwable e) {
        return this.getLoggerFormattedString(new StringBuffer().append(log).append("\n\t").append(ExceptionUtils.getFullStackTrace((Throwable)e)).toString());
    }

    protected long getSocketTimeOut() {
        if (this.adapterEnvironment.equals(EMAdapterEnvironment.J2SE)) {
            return VistaLinkManagedConnectionFactory.getDefaultJ2SETimeOut();
        }
        return this.getDefaultJ2EETimeOut();
    }

    protected VistaHeartBeatTimerManager getHeartBeatTimerManager() {
        return this.timerManager;
    }

    public String getAccessCode() {
        return this.accessCode;
    }

    public String getVerifyCode() {
        return this.verifyCode;
    }

    public void setNonManagedAccessCode(String string) {
        this.accessCode = string;
        this.setJ2SEProperties();
    }

    public void setNonManagedVerifyCode(String string) {
        this.verifyCode = string;
        this.setJ2SEProperties();
    }

    public InetAddress getHostIpAddressResolved() {
        try {
            return InetAddress.getByName(this.hostIpAddress);
        }
        catch (UnknownHostException e) {
            logger.error((Object)("could not resolve IP address '" + this.hostIpAddress + "': "), (Throwable)e);
            return null;
        }
    }

    protected InetAddress getHostIpAddressResolvedWithException() throws VistaLinkResourceException {
        try {
            InetAddress returnValue = InetAddress.getByName(this.hostIpAddress);
            logger.debug((Object)("resolved DNS address '" + this.hostIpAddress + "' as IP address '" + returnValue.getHostAddress() + "'."));
            return returnValue;
        }
        catch (UnknownHostException e) {
            logger.error((Object)("could not resolve IP address '" + this.hostIpAddress + "': "), (Throwable)e);
            throw new VistaLinkResourceException(e);
        }
    }

    public String getHostIpAddressUnresolved() {
        return this.hostIpAddress;
    }

    public EMAdapterEnvironment getAdapterEnvironment() {
        return this.adapterEnvironment;
    }

    public void setAdapterEnvironment(EMAdapterEnvironment adapterEnvironment) {
        this.adapterEnvironment = adapterEnvironment;
        this.timerManager.setAdapterEnvironment(this.adapterEnvironment);
    }

    protected long getManagedConnectionCount() {
        return this.managedConnectionCount;
    }

    public long getDistinguishedIdentifier() {
        return this.distinguishedIdentifier;
    }

    public void setConnectorJndiName(String connectorJndiName) {
        ConnectorConfigurator cc = new ConnectorConfigurator();
        this.setConnectorJndiNameInternal(connectorJndiName, cc);
    }

    public void setConnectorJndiNameInternal(String connectorJndiName, ConnectorConfigurator cc) {
        logger.debug((Object)"in setConnectorJndiName.");
        this.connectorJndiName = connectorJndiName;
        this.setAdapterEnvironment(EMAdapterEnvironment.J2EE);
        this.parseConfigFailureMessage = null;
        try {
            ConfigurationReader.loadConfigForMcf(this, cc);
            if (logger.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer("connector Config JndiName: '");
                sb.append(connectorJndiName);
                sb.append("'; connector Config IP: '");
                sb.append(this.hostIpAddress);
                sb.append("'; connector Config Port: '");
                sb.append(this.hostPort);
                sb.append("; 'connector Config Access code: <masked>;connector Config Verify code: <masked>; connector Config Status: '");
                sb.append(this.connectorEnabled);
                sb.append('\'');
                logger.debug((Object)sb.toString());
            }
        }
        catch (VistaLinkResourceException e) {
            this.parseConfigFailureMessage = e.getMessage();
            logger.error((Object)"Resource exception occurred reading configuration: ", (Throwable)((Object)e));
        }
    }

    public void setconnectorJndiName(String connectorJndiName) {
        this.setConnectorJndiName(connectorJndiName);
    }

    public String getConnectorJndiName() {
        return this.connectorJndiName;
    }

    private void setJ2SEProperties() {
        if (!this.adapterEnvironment.equals(EMAdapterEnvironment.J2SE)) {
            this.setAdapterEnvironment(EMAdapterEnvironment.J2SE);
        }
        this.connectorEnabled = true;
    }

    void setAlwaysUseDefaultAsMin(boolean value) {
        this.alwaysUseDefaultAsMin = value;
    }

    public boolean isAlwaysUseDefaultAsMin() {
        return this.alwaysUseDefaultAsMin;
    }

    void setDefaultJ2EETimeOut(long timeOut) {
        if (timeOut > 10000L) {
            this.defaultJ2EETimeOut = timeOut;
        } else {
            this.defaultJ2EETimeOut = 10000L;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)this.getLoggerFormattedString(new StringBuffer().append("J2EE timeOut configuration attribute value is too short [").append(timeOut).append("ms]. The following default value is being used instead: ").append(10000L).append("ms").toString()));
            }
        }
    }

    public long getDefaultJ2EETimeOut() {
        return this.defaultJ2EETimeOut;
    }

    private static void setDefaultJ2SETimeOut(long timeOut) {
        if (timeOut > 10000L) {
            defaultJ2SETimeOut = timeOut;
        } else {
            defaultJ2SETimeOut = 10000L;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)new StringBuffer().append("J2SE timeOut configuration attribute value is too short [").append(timeOut).append("ms]. The following default value is being used instead: ").append(10000L).append("ms").toString());
            }
        }
    }

    private static long getDefaultJ2SETimeOut() {
        return defaultJ2SETimeOut;
    }

    private static void setSocketTimeOutMultipler(int socketTimeOutMultipler) {
        if (socketTimeOutMultipler > 0) {
            VistaLinkManagedConnectionFactory.socketTimeOutMultipler = socketTimeOutMultipler;
        }
    }

    static int getSocketTimeOutMultipler() {
        return socketTimeOutMultipler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementConnectionFailureCount() {
        Object object = this.healthSyncObj;
        synchronized (object) {
            ++this.connectionFailureCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getConnectionFailureCount() {
        Object object = this.healthSyncObj;
        synchronized (object) {
            return this.connectionFailureCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementConnectionAuthFailureCount() {
        Object object = this.healthSyncObj;
        synchronized (object) {
            ++this.connectionAuthFailureCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getConnectionAuthFailureCount() {
        Object object = this.healthSyncObj;
        synchronized (object) {
            return this.connectionAuthFailureCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementIdentityFailureCount() {
        Object object = this.healthSyncObj;
        synchronized (object) {
            ++this.identityFailureCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getIdentityFailureCount() {
        Object object = this.healthSyncObj;
        synchronized (object) {
            return this.identityFailureCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementdivisionMismatchCount() {
        Object object = this.healthSyncObj;
        synchronized (object) {
            ++this.divisionMismatchCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDivisionMismatchCount() {
        Object object = this.healthSyncObj;
        synchronized (object) {
            return this.divisionMismatchCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementProductionMismatchCount() {
        Object object = this.healthSyncObj;
        synchronized (object) {
            ++this.productionMismatchCount;
        }
    }

    protected void setConnectorEnabled(boolean connectorEnabled) {
        this.connectorEnabled = connectorEnabled;
    }

    public boolean isConnectorEnabled() {
        return this.connectorEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getProductionMismatchCount() {
        Object object = this.healthSyncObj;
        synchronized (object) {
            return this.productionMismatchCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCreateConnectionHandleTime(long elapsedMillis) {
        Object object = this.createConnectionHandleAvgSyncObj;
        synchronized (object) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("elapsedMillis to add: " + Long.toString(elapsedMillis)));
            }
            if (elapsedMillis < Long.MAX_VALUE - this.createConnectionHandleTotalMillis) {
                ++this.createConnectionHandleCount;
                this.createConnectionHandleTotalMillis += elapsedMillis;
            } else {
                logger.error((Object)"CreateConnectionHandle time total exceeded LONG MAX_VALUE");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getCreateConnectionHandleAvgMillis() {
        Object object = this.createConnectionHandleAvgSyncObj;
        synchronized (object) {
            if (this.createConnectionHandleCount > 0L) {
                return (double)this.createConnectionHandleTotalMillis / (double)this.createConnectionHandleCount;
            }
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMatchManagedConnectionTime(long elapsedMillis) {
        Object object = this.matchManagedConnectionAvgSyncObj;
        synchronized (object) {
            if (elapsedMillis < Long.MAX_VALUE - this.matchManagedConnectionTotalMillis) {
                ++this.matchManagedConnectionCount;
                this.matchManagedConnectionTotalMillis += elapsedMillis;
            } else {
                logger.error((Object)"MatchManagedConnection time total exceeded LONG MAX_VALUE");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMatchManagedConnectionAvgMillis() {
        Object object = this.matchManagedConnectionAvgSyncObj;
        synchronized (object) {
            if (this.matchManagedConnectionCount > 0L) {
                return (double)this.matchManagedConnectionTotalMillis / (double)this.matchManagedConnectionCount;
            }
            return 0.0;
        }
    }

    public String getPrimaryStation() {
        return this.primaryStation;
    }

    protected void setAccessCode(String accessCode) {
        this.accessCode = accessCode;
    }

    protected void setHostIpAddress(String hostIpAddress) {
        this.hostIpAddress = hostIpAddress;
    }

    protected void setHostPort(int hostPort) {
        this.hostPort = hostPort;
    }

    protected void setPrimaryStation(String primaryStation) {
        this.primaryStation = primaryStation;
    }

    protected void setVerifyCode(String verifyCode) {
        this.verifyCode = verifyCode;
    }

    public Set getInvalidConnections(Set managedConnections) throws ResourceException {
        block5: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executing connection test for " + this.getConnectorJndiName()));
            }
            VistaHeartBeatTimerRequest req = null;
            VistaHeartBeatTimerResponse resp = null;
            VistaHeartBeatTimerResponseFactory resFactory = null;
            VistaLinkManagedConnection mc = null;
            Iterator iter = managedConnections.iterator();
            boolean success = false;
            try {
                req = new VistaHeartBeatTimerRequest(this.adapterEnvironment);
                resFactory = new VistaHeartBeatTimerResponseFactory();
                while (iter.hasNext()) {
                    success = false;
                    mc = (VistaLinkManagedConnection)iter.next();
                    resp = (VistaHeartBeatTimerResponse)mc.executeInteraction(req, resFactory);
                    if (resp.isHeartBeatSuccessful()) {
                        iter.remove();
                        success = true;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)this.buildTestLoggerMessage(mc, success));
                }
            }
            catch (FoundationsException e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug((Object)this.buildTestLoggerMessage(mc, false));
            }
        }
        return managedConnections;
    }

    private String buildTestLoggerMessage(VistaLinkManagedConnection mc, boolean success) {
        return new StringBuffer().append("Managed connection ").append(success ? "passed" : "failed").append(" test.").append("  Connector Information >>> JNDI Name:").append(this.getConnectorJndiName()).append("  Host:").append(this.getHostIPAddress()).append("  Port:").append(this.getHostPort()).append("  Connection Information >>> MJob:").append(mc.getMJob()).append("  Distinguisheded ID:").append(mc.getDistinguishedIdentifier()).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.adapterEnvironment == EMAdapterEnvironment.J2EE) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("considering removing mappings for JNDI Name '" + this.connectorJndiName + "', distinguished identifier '" + this.distinguishedIdentifier + "."));
                }
                InstitutionMapping instMap = InstitutionMappingFactory.getInstitutionMapping();
                instMap.removeMappingsForJndiName(this.connectorJndiName, new String[]{this.primaryStation}, this.distinguishedIdentifier);
            }
        }
        finally {
            super.finalize();
        }
    }

    static {
        String INST_MBEAN_COULD_NOT_REG_MSG = "Could not register institution mapping MBean: ";
        logger.info((Object)"running static initializer, VistALink adapter version 1.6.0.028.");
        ServerType serverType = Environment.getServerType();
        if (!serverType.equals(ServerType.JAVA_SE) && !serverType.equals(ServerType.UNKNOWN)) {
            VistaLinkConnectorNotificationListener delegateListener = new VistaLinkConnectorNotificationListener();
            IJmxHelper jmxHelper = JmxHelperFactory.getJmxHelper();
            MBeanServer localMBeanServer = null;
            try {
                localMBeanServer = jmxHelper.getLocalMBeanServer();
            }
            catch (JmxHelperException e) {
                logger.error((Object)"Could not retrieve local MBean Server. VistaLinkConnector and Institution MBeans cannot be registered: ", (Throwable)e);
            }
            if (localMBeanServer != null) {
                try {
                    ObjectName delegate = new ObjectName("JMImplementation:type=MBeanServerDelegate");
                    localMBeanServer.addNotificationListener(delegate, delegateListener, null, null);
                    logger.debug((Object)"registered VistaLinkConnectorNotificationListener!");
                    delegateListener.performInitialScan();
                }
                catch (MalformedObjectNameException e) {
                    logger.error((Object)"Problem registering notification listener: ", (Throwable)e);
                }
                catch (InstanceNotFoundException e) {
                    logger.error((Object)"Problem registering notification listener: ", (Throwable)e);
                }
                try {
                    VistaLinkInstitutionMapping instMapMBean = new VistaLinkInstitutionMapping();
                    StringBuffer sb = new StringBuffer(jmxHelper.getJmxDomainForHev()).append(":");
                    sb.append(JMX_OBJECT_NAME_STRING_NAME).append('=').append(VistaLinkInstitutionMapping.getMBeanName());
                    sb.append(',').append(JMX_OBJECT_NAME_STRING_TYPE).append('=').append(VistaLinkInstitutionMapping.getMBeanType());
                    String additionalProps = jmxHelper.getServerObjectNamePropertiesForRegistration();
                    if (additionalProps.length() > 0) {
                        sb.append(',').append(additionalProps);
                    }
                    ObjectName instMappingObjectName = new ObjectName(sb.toString());
                    localMBeanServer.registerMBean(instMapMBean, instMappingObjectName);
                    logger.debug((Object)("MBean '" + instMappingObjectName + "' registered."));
                }
                catch (MalformedObjectNameException e) {
                    logger.error((Object)INST_MBEAN_COULD_NOT_REG_MSG, (Throwable)e);
                }
                catch (InstanceAlreadyExistsException e) {
                    logger.error((Object)INST_MBEAN_COULD_NOT_REG_MSG, (Throwable)e);
                }
                catch (MBeanRegistrationException e) {
                    logger.error((Object)INST_MBEAN_COULD_NOT_REG_MSG, (Throwable)e);
                }
                catch (NotCompliantMBeanException e) {
                    logger.error((Object)INST_MBEAN_COULD_NOT_REG_MSG, (Throwable)e);
                }
                catch (NullPointerException e) {
                    logger.error((Object)INST_MBEAN_COULD_NOT_REG_MSG, (Throwable)e);
                }
            }
        } else {
            String property = "gov.va.med.vistalink.socket-timeout-multipler";
            String timeOutMultipler = System.getProperty(property);
            if (timeOutMultipler != null) {
                try {
                    VistaLinkManagedConnectionFactory.setSocketTimeOutMultipler(Integer.parseInt(timeOutMultipler));
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)("The value of the JVM property " + property + " [" + timeOutMultipler + "] is not a valid number. Default will be used."));
                }
            }
            logger.debug((Object)("J2SE socket time-out multipler set to " + VistaLinkManagedConnectionFactory.getSocketTimeOutMultipler() + "."));
            property = "gov.va.med.vistalink.socket-timeout-default";
            String j2seDefaultSocketTimeout = System.getProperty(property);
            if (j2seDefaultSocketTimeout != null) {
                try {
                    VistaLinkManagedConnectionFactory.setDefaultJ2SETimeOut(Long.parseLong(j2seDefaultSocketTimeout));
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)("The value of the JVM property " + property + " [" + j2seDefaultSocketTimeout + "] is not a valid number. Default will be used."));
                }
            }
            logger.debug((Object)("J2SE default socket time-out set to " + VistaLinkManagedConnectionFactory.getDefaultJ2SETimeOut() + " ms."));
        }
    }
}

