/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.adapter.spi;

import gov.va.med.exception.ExceptionUtils;
import gov.va.med.exception.FoundationsException;
import gov.va.med.vistalink.adapter.record.VistaLinkRequestVO;
import gov.va.med.vistalink.adapter.record.VistaLinkResponseFactoryImpl;
import gov.va.med.vistalink.adapter.record.VistaLinkResponseVO;
import gov.va.med.vistalink.adapter.spi.VistaLinkInitSocketResponse;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VistaLinkInitSocketResponseFactory
extends VistaLinkResponseFactoryImpl {
    private static final Logger logger = Logger.getLogger(VistaLinkInitSocketResponseFactory.class);

    protected VistaLinkInitSocketResponseFactory() {
    }

    protected VistaLinkResponseVO parseMessageBody(String rawXml, String filteredXml, Document doc, String messageType, VistaLinkRequestVO requestVO) throws FoundationsException {
        try {
            Attr attr = null;
            long heartBeatRateMillis = 0L;
            String mJob = "";
            long reAuthSessionTimeout = 600L;
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList resultsNodeList = (NodeList)xpath.evaluate("/VistaLink/Response/.", doc, XPathConstants.NODESET);
            Node resultsNode = resultsNodeList.getLength() > 0 ? resultsNodeList.item(0) : null;
            NamedNodeMap attrs = resultsNode.getAttributes();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"got response attributes");
            }
            heartBeatRateMillis = 1000L * Long.parseLong(((Attr)attrs.getNamedItem("rate")).getValue());
            attr = (Attr)attrs.getNamedItem("mJob");
            mJob = attr != null ? attr.getValue() : "[$JOB not returned]";
            attr = (Attr)attrs.getNamedItem("reAuthSessionTimeout");
            long l = reAuthSessionTimeout = attr != null ? 1000L * Long.parseLong(attr.getValue()) : 600000L;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)new StringBuffer().append("Retrieved Initial Socket Response: \n\theartbeat rate = ").append(heartBeatRateMillis).append("\n\tM $JOB = ").append(mJob).append("\n\tReauth session Timeout = ").append(reAuthSessionTimeout).toString());
            }
            return new VistaLinkInitSocketResponse(rawXml, filteredXml, doc, messageType, heartBeatRateMillis, mJob, reAuthSessionTimeout);
        }
        catch (XPathExpressionException e) {
            String errStr = "could not parse xml";
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                String errMsg = new StringBuffer().append(errStr).append("\n\t").append(ExceptionUtils.getFullStackTrace((Throwable)e)).toString();
                logger.error((Object)errMsg);
            }
            throw new FoundationsException(errStr, (Throwable)e);
        }
    }
}

