/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.adapter.spi;

import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionSpec;
import gov.va.med.vistalink.adapter.cci.VistaLinkResourceException;
import javax.resource.cci.ConnectionSpec;
import javax.resource.spi.ConnectionRequestInfo;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class VistaLinkConnectionRequestInfo
implements ConnectionRequestInfo {
    private static final Logger logger = Logger.getLogger(VistaLinkConnectionRequestInfo.class);
    private VistaLinkConnectionSpec connectionSpec;

    public VistaLinkConnectionRequestInfo(ConnectionSpec connectionSpec) throws VistaLinkResourceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Constructing request info");
        }
        if (!(connectionSpec instanceof VistaLinkConnectionSpec)) {
            String errMsg = "the connection spec is not the right type";
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                logger.error((Object)errMsg);
            }
            throw new VistaLinkResourceException(errMsg);
        }
        this.connectionSpec = (VistaLinkConnectionSpec)connectionSpec;
    }

    public VistaLinkConnectionSpec getConnectionSpec() {
        return this.connectionSpec;
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getName()).append("->").append(this.connectionSpec.getClass().getName()).append("->").append(this.connectionSpec.getSecurityType()).toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof VistaLinkConnectionRequestInfo) {
            VistaLinkConnectionRequestInfo other = (VistaLinkConnectionRequestInfo)obj;
            return this.getConnectionSpec().equals(other.getConnectionSpec());
        }
        return false;
    }

    public int hashCode() {
        int HASHCODE_SEED;
        int returnVal = HASHCODE_SEED = 17;
        int connSpecHashCode = this.connectionSpec.hashCode();
        returnVal = 37 * returnVal + connSpecHashCode;
        return returnVal;
    }
}

