/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.adapter.spi;

import java.util.Vector;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import org.apache.log4j.Logger;

public class VistaLinkConnectionEventNotifier {
    private static final Logger logger = Logger.getLogger(VistaLinkConnectionEventNotifier.class);
    private Vector listeners;

    public VistaLinkConnectionEventNotifier() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Constructing");
        }
        this.listeners = new Vector();
    }

    public void connectionClosed(ConnectionEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Connection closed");
        }
        this.sendEvent(event, 1);
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Connection Error");
        }
        this.sendEvent(event, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvent(ConnectionEvent ce, int eventType) {
        Object[] list;
        Vector vector = this.listeners;
        synchronized (vector) {
            list = this.listeners.toArray();
        }
        int size = list.length;
        block7: for (int i = 0; i < size; ++i) {
            ConnectionEventListener l = (ConnectionEventListener)list[i];
            switch (eventType) {
                case 1: {
                    l.connectionClosed(ce);
                    continue block7;
                }
                case 5: {
                    l.connectionErrorOccurred(ce);
                    continue block7;
                }
                default: {
                    if (!logger.isDebugEnabled()) continue block7;
                    logger.debug((Object)new StringBuffer().append("Event type not supported->").append(eventType));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectorListener(ConnectionEventListener l) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"addConnectionEventListener");
        }
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectorListener(ConnectionEventListener l) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"removeConnectionEventListener");
        }
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(l);
        }
    }
}

