/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.adapter.spi;

import gov.va.med.crypto.DESPassPhraseEncrypter;
import gov.va.med.crypto.DESScopedEncrypter;
import gov.va.med.crypto.EncrypterRegistry;
import gov.va.med.vistalink.adapter.cci.VistaLinkResourceException;
import gov.va.med.vistalink.adapter.config.Connector;
import gov.va.med.vistalink.adapter.config.ConnectorsDocument;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

public class ConnectorConfigurator {
    private URL configUrl = null;
    private ConnectorsDocument configDocument;
    private static final Logger logger = Logger.getLogger(ConnectorConfigurator.class);
    private static final String CONFIG_FILE_PATH = "/gov.va.med.vistalink.connectorConfig.xml";

    public ConnectorConfigurator() {
        this.configUrl = this.getClass().getResource(CONFIG_FILE_PATH);
    }

    public ConnectorConfigurator(URL url) {
        this.configUrl = url;
    }

    void readFile() throws VistaLinkResourceException {
        if (this.configUrl == null) {
            String error = "Missing configuration file path.";
            logger.error((Object)error);
            throw new VistaLinkResourceException(error);
        }
        try {
            logger.debug((Object)("parsing XML doc from URL: " + this.configUrl));
            ConnectorsDocument xo = ConnectorsDocument.Factory.parse(this.configUrl);
            if (xo instanceof ConnectorsDocument) {
                HashSet errors = new HashSet();
                XmlOptions vOptions = new XmlOptions();
                vOptions.setErrorListener(errors);
                if (!xo.validate(vOptions)) {
                    throw new VistaLinkResourceException("Not a valid Connectors document.\n" + errors.toString() + "\n");
                }
            } else {
                throw new VistaLinkResourceException("Not a \"Connectors\" document");
            }
            this.configDocument = xo;
        }
        catch (XmlException e) {
            String error = "Problem parsing config file. ";
            logger.error((Object)error, (Throwable)e);
            throw new VistaLinkResourceException(error, (Exception)((Object)e));
        }
        catch (IOException e) {
            String error = "Problem opening config file.";
            logger.error((Object)error, (Throwable)e);
            throw new VistaLinkResourceException(error, e);
        }
    }

    boolean isFileRead() {
        return this.configDocument != null;
    }

    public String getConfigUrlStr() {
        if (this.configUrl != null) {
            return this.configUrl.toExternalForm();
        }
        return null;
    }

    public Connector[] getConnectorArray() throws VistaLinkResourceException {
        if (!this.isFileRead()) {
            this.readFile();
        }
        return this.configDocument.getConnectors().getConnectorArray();
    }

    public int getConfigFileEntrySize() throws VistaLinkResourceException {
        if (!this.isFileRead()) {
            this.readFile();
        }
        return this.configDocument.getConnectors().sizeOfConnectorArray();
    }

    public Connector getConnectorByName(String lName) throws VistaLinkResourceException {
        if (!this.isFileRead()) {
            this.readFile();
        }
        Connector result = null;
        Connector[] ls = this.getConnectorArray();
        for (int inx = 0; inx < ls.length && !(result = ls[inx]).getJndiName().equals(lName); ++inx) {
            result = null;
        }
        return result;
    }

    public boolean save() throws VistaLinkResourceException {
        if (!this.isFileRead()) {
            this.readFile();
        }
        boolean saveResult = false;
        HashSet errors = new HashSet();
        if (this.validateMemoryArr(errors)) {
            logger.debug((Object)"validateFile succeeded.");
            try {
                this.configDocument.save(new File(new URI(this.configUrl.toExternalForm())));
                saveResult = true;
                logger.debug((Object)"save config file succeeded.");
            }
            catch (IOException e) {
                logger.error((Object)"save config file failed: ", (Throwable)e);
                throw new VistaLinkResourceException("Error saving configuration file: " + e.getMessage());
            }
            catch (URISyntaxException e) {
                logger.error((Object)"save config file failed: ", (Throwable)e);
                throw new VistaLinkResourceException("Error saving configuration file: " + e.getMessage());
            }
        } else {
            logger.error((Object)("validateFile failed: " + errors.toString()));
            throw new VistaLinkResourceException("Error validating configuration file: " + errors.toString());
        }
        return saveResult;
    }

    public int getUnencryptedCount() throws VistaLinkResourceException {
        int count = 0;
        if (!this.isFileRead()) {
            this.readFile();
        }
        Connector[] connectorArray = this.configDocument.getConnectors().getConnectorArray();
        for (int i = 0; i < connectorArray.length; ++i) {
            if (connectorArray[i].getEncrypted()) continue;
            ++count;
        }
        return count;
    }

    public int encryptAllUnencryptedEntries() throws VistaLinkResourceException {
        if (!this.isFileRead()) {
            this.readFile();
        }
        Connector[] conns = this.getConnectorArray();
        int count = 0;
        for (int i = 0; i < conns.length; ++i) {
            if (conns[i].getEncrypted()) continue;
            this.updateEncryptionIfNeeded(conns[i]);
            ++count;
        }
        return count;
    }

    public int changeEncryptionType(boolean isNewEncryptionTypeScoped) throws VistaLinkResourceException {
        boolean currentEncryptionScoped;
        int count = 0;
        if (!this.isFileRead()) {
            this.readFile();
        }
        if ((currentEncryptionScoped = this.isEncryptionScoped()) != isNewEncryptionTypeScoped) {
            Connector[] conns = this.getConnectorArray();
            for (int i = 0; i < conns.length; ++i) {
                if (!conns[i].getEncrypted()) continue;
                this.updateEncryption(conns[i], currentEncryptionScoped, isNewEncryptionTypeScoped);
                ++count;
            }
            this.configDocument.getConnectors().setEncryptionScoped(isNewEncryptionTypeScoped);
        }
        return count;
    }

    public boolean isEncryptionScoped() throws VistaLinkResourceException {
        if (!this.isFileRead()) {
            this.readFile();
        }
        return this.configDocument.getConnectors().getEncryptionScoped();
    }

    public boolean updateEncryptionIfNeeded(Connector conn) throws VistaLinkResourceException {
        if (!conn.getEncrypted()) {
            this.updateEncryption(conn);
            return true;
        }
        return false;
    }

    private void updateEncryption(Connector conn) throws VistaLinkResourceException {
        boolean currentScoping = this.isEncryptionScoped();
        this.updateEncryption(conn, currentScoping, currentScoping);
    }

    private void updateEncryption(Connector conn, boolean isExistingEncryptionScoped, boolean isNewEncryptionScoped) {
        String accessCode = null;
        String verifyCode = null;
        if (conn.getEncrypted()) {
            accessCode = this.getDecryptedValue(conn.getAccessCode(), isExistingEncryptionScoped);
            verifyCode = this.getDecryptedValue(conn.getVerifyCode(), isExistingEncryptionScoped);
        } else {
            accessCode = conn.getAccessCode();
            verifyCode = conn.getVerifyCode();
        }
        conn.setAccessCode(this.getEncryptedValue(accessCode, isNewEncryptionScoped));
        conn.setVerifyCode(this.getEncryptedValue(verifyCode, isNewEncryptionScoped));
        conn.setEncrypted(true);
        logger.debug((Object)("updated encryption for connector: '" + conn.getJndiName() + "'."));
    }

    public void setEncryptedAccessCode(Connector conn, String accessCode) throws VistaLinkResourceException {
        this.setEncryptedAccessCode(conn, accessCode, this.isEncryptionScoped());
    }

    private void setEncryptedAccessCode(Connector conn, String accessCode, boolean useScopedEncryption) {
        conn.setAccessCode(this.getEncryptedValue(accessCode, useScopedEncryption));
        if (!conn.getEncrypted()) {
            conn.setVerifyCode(this.getEncryptedValue(conn.getVerifyCode(), useScopedEncryption));
            conn.setEncrypted(true);
        }
    }

    public void setEncryptedVerifyCode(Connector conn, String verifyCode) throws VistaLinkResourceException {
        this.setEncryptedVerifyCode(conn, verifyCode, this.isEncryptionScoped());
    }

    private void setEncryptedVerifyCode(Connector conn, String verifyCode, boolean useScopedEncryption) {
        conn.setVerifyCode(this.getEncryptedValue(verifyCode, useScopedEncryption));
        if (!conn.getEncrypted()) {
            conn.setAccessCode(this.getEncryptedValue(conn.getAccessCode(), useScopedEncryption));
            conn.setEncrypted(true);
        }
    }

    public Connector addConnector(String lName) throws VistaLinkResourceException {
        if (!this.isFileRead()) {
            this.readFile();
        }
        Connector result = null;
        if (this.getConnectorByName(lName) != null) {
            throw new VistaLinkResourceException("Duplicate Connector Name!");
        }
        result = this.configDocument.getConnectors().addNewConnector();
        result.setJndiName(lName);
        result.setAlwaysUseDefaultAsMin(true);
        return result;
    }

    public void deleteConnector(String lName) throws VistaLinkResourceException {
        if (!this.isFileRead()) {
            this.readFile();
        }
        Connector[] la = this.getConnectorArray();
        for (int inx = 0; inx < la.length; ++inx) {
            if (!lName.equals(la[inx].getJndiName())) continue;
            this.configDocument.getConnectors().removeConnector(inx);
            logger.debug((Object)("just removed connector " + lName));
            this.save();
            break;
        }
    }

    public boolean validateMemoryArr(Collection errors) throws VistaLinkResourceException {
        if (!this.isFileRead()) {
            this.readFile();
        }
        boolean fileRead = this.isFileRead();
        logger.debug((Object)("in validateFile. isFileRead: " + fileRead));
        if (fileRead) {
            if (errors != null) {
                XmlOptions vOptions = new XmlOptions();
                vOptions.setErrorListener(errors);
                fileRead = this.configDocument.validate(vOptions);
                logger.debug((Object)("configDocument.validate(vOptions) result: " + fileRead));
            } else {
                fileRead = this.configDocument.validate();
            }
            logger.debug((Object)("configDocument.validate() result: " + fileRead));
        }
        return fileRead;
    }

    private String getEncryptedValue(String original, boolean isScoped) {
        if (original != null && original.length() > 0) {
            return EncrypterRegistry.getInstance(isScoped ? DESScopedEncrypter.class : DESPassPhraseEncrypter.class).encrypt(original);
        }
        return original;
    }

    public String getDecryptedValue(String encrypted, boolean isScoped) {
        if (encrypted != null && encrypted.length() > 0) {
            return EncrypterRegistry.getInstance(isScoped ? DESScopedEncrypter.class : DESPassPhraseEncrypter.class).decrypt(encrypted);
        }
        return encrypted;
    }
}

