/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.adapter.record;

import gov.va.med.exception.ExceptionUtils;
import gov.va.med.exception.FoundationsException;
import gov.va.med.vistalink.adapter.record.LoginsDisabledFaultException;
import gov.va.med.vistalink.adapter.record.NoJobSlotsAvailableFaultException;
import gov.va.med.vistalink.adapter.record.VistaLinkFaultException;
import gov.va.med.vistalink.adapter.record.VistaLinkRequestVO;
import gov.va.med.vistalink.adapter.record.VistaLinkResponseFactory;
import gov.va.med.vistalink.adapter.record.VistaLinkResponseVO;
import gov.va.med.vistalink.adapter.record.VistaLinkResponseVOImpl;
import gov.va.med.xml.XmlUtilities;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class VistaLinkResponseFactoryImpl
implements VistaLinkResponseFactory {
    private static final Logger logger = Logger.getLogger(VistaLinkResponseFactoryImpl.class);
    protected static final String GOV_VA_MED_FOUNDATIONS_FAULT = "gov.va.med.foundations.vistalink.system.fault";
    protected static final String ERROR_MSG_GEN = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><VistaLink messageType=\"gov.va.med.foundations.vistalink.system.fault";
    protected static final String SUFFIX = "</Response></VistaLink>";
    protected static final String VISTALINK_ROOT_ELEMENT = "VistaLink";

    public VistaLinkResponseVO handleResponse(String response, VistaLinkRequestVO requestVO) throws FoundationsException {
        try {
            return this.parseMessageHeader(response, requestVO);
        }
        catch (VistaLinkFaultException e) {
            throw e;
        }
        catch (FoundationsException e) {
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                String errMsg = new StringBuffer().append("Exception occured parsing response.").append("\n\t").append(ExceptionUtils.getFullStackTrace((Throwable)e)).toString();
                logger.error((Object)errMsg);
            }
            throw e;
        }
    }

    private VistaLinkResponseVO parseMessageHeader(String rawXml, VistaLinkRequestVO requestVO) throws VistaLinkFaultException, FoundationsException {
        boolean isFault = this.doesResponseIndicateFaultCommon(rawXml) || this.doesResponseIndicateFault(rawXml);
        VistaLinkResponseVO resp = null;
        Document doc = null;
        String filteredXml = this.filterResponseXmlString(rawXml, isFault);
        doc = XmlUtilities.getDocumentForXmlString((String)filteredXml);
        if (!doc.getDocumentElement().getNodeName().equals(VISTALINK_ROOT_ELEMENT)) {
            throw new FoundationsException("Root element of response is not VistaLink.");
        }
        String version = ((Attr)doc.getDocumentElement().getAttributes().getNamedItem("version")).getValue();
        if (!version.equals("1.6") && !version.equals("1.5")) {
            throw new FoundationsException(new StringBuffer().append("The response version [").append(version).append("] is incompatible with this version of the adapter [").append("1.6").append("]").toString());
        }
        String messageType = ((Attr)doc.getDocumentElement().getAttributes().getNamedItem("messageType")).getValue();
        if (isFault) {
            this.handleFault(doc, messageType);
        } else {
            resp = this.parseMessageBody(rawXml, filteredXml, doc, messageType, requestVO);
        }
        return resp;
    }

    private boolean doesResponseIndicateFaultCommon(String rawXml) {
        return rawXml.startsWith(ERROR_MSG_GEN);
    }

    protected boolean doesResponseIndicateFault(String rawXml) {
        return false;
    }

    protected String filterResponseXmlString(String rawXml, boolean isFault) {
        return rawXml;
    }

    protected VistaLinkResponseVO parseMessageBody(String rawXml, String filteredXml, Document doc, String messageType, VistaLinkRequestVO requestVO) throws FoundationsException {
        return new VistaLinkResponseVOImpl(rawXml, filteredXml, doc, messageType);
    }

    protected final void handleFault(Document xdoc, String messageType) throws VistaLinkFaultException, FoundationsException {
        String faultCode = "";
        String faultString = "";
        String faultActor = "";
        String errorCode = "";
        String errorType = "";
        String errorMessage = "";
        try {
            NodeList msgNodeList;
            Node msgNode;
            NodeList errorNodeList;
            NodeList faultActorNodeList;
            Node faultActorNode;
            NodeList faultStringNodeList;
            Node faultStringNode;
            Node faultCodeNode;
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList faultCodeNodeList = (NodeList)xpath.evaluate("VistaLink/Fault/FaultCode/text()", xdoc, XPathConstants.NODESET);
            Node node = faultCodeNode = faultCodeNodeList.getLength() > 0 ? faultCodeNodeList.item(0) : null;
            if (faultCodeNode != null && faultCodeNode.getNodeType() == 3) {
                faultCode = ((Text)faultCodeNode).getData();
            }
            Node node2 = faultStringNode = (faultStringNodeList = (NodeList)(xpath = XPathFactory.newInstance().newXPath()).evaluate("VistaLink/Fault/FaultString/text()", xdoc, XPathConstants.NODESET)).getLength() > 0 ? faultStringNodeList.item(0) : null;
            if (faultStringNode != null && faultStringNode.getNodeType() == 3) {
                faultString = ((Text)faultStringNode).getData();
            }
            Node node3 = faultActorNode = (faultActorNodeList = (NodeList)(xpath = XPathFactory.newInstance().newXPath()).evaluate("VistaLink/Fault/FaultActor/text()", xdoc, XPathConstants.NODESET)).getLength() > 0 ? faultActorNodeList.item(0) : null;
            if (faultActorNode != null && faultActorNode.getNodeType() == 3) {
                faultActor = ((Text)faultActorNode).getData();
            }
            Node errorNode = (errorNodeList = (NodeList)(xpath = XPathFactory.newInstance().newXPath()).evaluate("/VistaLink/Fault/Detail/Error/.", xdoc, XPathConstants.NODESET)).getLength() > 0 ? errorNodeList.item(0) : null;
            errorCode = ((Attr)errorNode.getAttributes().getNamedItem("code")).getValue();
            Attr errorTypeAttr = (Attr)errorNode.getAttributes().getNamedItem("type");
            if (errorTypeAttr != null) {
                errorType = errorTypeAttr.getValue();
            }
            Node node4 = msgNode = (msgNodeList = (NodeList)(xpath = XPathFactory.newInstance().newXPath()).evaluate("/VistaLink/Fault/Detail/Error/Message/text()", xdoc, XPathConstants.NODESET)).getLength() > 0 ? msgNodeList.item(0) : null;
            if (msgNode != null) {
                errorMessage = msgNode.getNodeValue();
            }
            VistaLinkFaultException faultException = new VistaLinkFaultException(errorCode, errorMessage, errorType, faultActor, faultCode, faultString);
            VistaLinkFaultException specificFaultException = this.handleAndDelegateSpecificFault(xdoc, messageType, faultException);
            throw specificFaultException;
        }
        catch (XPathExpressionException e) {
            throw new FoundationsException("Exception parsing XML.", (Throwable)e);
        }
    }

    private VistaLinkFaultException handleAndDelegateSpecificFault(Document xdoc, String messageType, VistaLinkFaultException faultException) throws VistaLinkFaultException, FoundationsException {
        if ("181003".equals(faultException.getErrorCode())) {
            return new NoJobSlotsAvailableFaultException(faultException);
        }
        if ("181004".endsWith(faultException.getErrorCode())) {
            return new LoginsDisabledFaultException(faultException);
        }
        VistaLinkFaultException returnFaultException = this.handleSpecificFault(xdoc, messageType, faultException);
        if (returnFaultException == null) {
            returnFaultException = faultException;
        }
        return returnFaultException;
    }

    protected VistaLinkFaultException handleSpecificFault(Document xdoc, String messageType, VistaLinkFaultException faultException) throws VistaLinkFaultException, FoundationsException {
        return null;
    }
}

