/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.security;

import gov.va.med.crypto.VistaKernelHashCountLimitExceededException;
import gov.va.med.exception.ExceptionUtils;
import gov.va.med.exception.FoundationsException;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnection;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionFactory;
import gov.va.med.vistalink.adapter.cci.VistaLinkResourceException;
import gov.va.med.vistalink.adapter.record.LoginsDisabledFaultException;
import gov.va.med.vistalink.adapter.record.NoJobSlotsAvailableFaultException;
import gov.va.med.vistalink.adapter.record.VistaLinkFaultException;
import gov.va.med.vistalink.rpc.RpcRequest;
import gov.va.med.vistalink.rpc.RpcRequestFactory;
import gov.va.med.vistalink.rpc.RpcResponse;
import gov.va.med.vistalink.security.VistaKernelPrincipalImpl;
import gov.va.med.vistalink.security.VistaLoginModuleException;
import gov.va.med.vistalink.security.VistaLoginModuleIPLockedException;
import gov.va.med.vistalink.security.VistaLoginModuleLoginsDisabledException;
import gov.va.med.vistalink.security.VistaLoginModuleNoJobSlotsAvailableException;
import gov.va.med.vistalink.security.VistaLoginModuleNoPathToListenerException;
import gov.va.med.vistalink.security.VistaLoginModuleSPI;
import gov.va.med.vistalink.security.VistaLoginModuleTooManyInvalidAttemptsException;
import gov.va.med.vistalink.security.m.KernelSecurityHandshake;
import gov.va.med.vistalink.security.m.SecurityDataLogonResponse;
import gov.va.med.vistalink.security.m.SecurityDataLogoutResponse;
import gov.va.med.vistalink.security.m.SecurityDataSetupAndIntroTextResponse;
import gov.va.med.vistalink.security.m.SecurityFaultException;
import gov.va.med.vistalink.security.m.SecurityIPLockedFaultException;
import gov.va.med.vistalink.security.m.SecurityResponse;
import gov.va.med.vistalink.security.m.SecurityResponseFactory;
import gov.va.med.vistalink.security.m.SecurityTooManyInvalidLoginAttemptsFaultException;
import gov.va.med.vistalink.security.m.SecurityVOChangeVc;
import gov.va.med.vistalink.security.m.SecurityVOLogon;
import gov.va.med.vistalink.security.m.SecurityVOSelectDivision;
import gov.va.med.vistalink.security.m.SecurityVOSetupAndIntroText;
import gov.va.med.vistalink.security.m.SecurityVOUserDemographics;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Map;
import java.util.StringTokenizer;
import javax.resource.ResourceException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;

class VistaLoginModuleSPIClientServer
implements VistaLoginModuleSPI {
    private VistaLinkConnectionFactory myVCF;
    private VistaLinkConnection myConnection;
    private SecurityResponseFactory mySecurityResponseFactory;
    private static final Logger logger = Logger.getLogger(VistaLoginModuleSPIClientServer.class);

    VistaLoginModuleSPIClientServer() {
    }

    public void initialize(Map jaasOptions, Map jaasSharedState) throws VistaLoginModuleException {
        this.myConnection = null;
        String serverAddress = "";
        int serverPort = -1;
        String exceptionMessage = "Could not create connection. ";
        try {
            serverAddress = (String)jaasOptions.get("gov.va.med.vistalink.security.ServerAddressKey");
            serverPort = Integer.parseInt((String)jaasOptions.get("gov.va.med.vistalink.security.ServerPortKey"));
        }
        catch (NumberFormatException e) {
            try {
                serverAddress = (String)jaasOptions.get("gov.va.med.foundations.security.vistalink.ServerAddressKey");
                serverPort = Integer.parseInt((String)jaasOptions.get("gov.va.med.foundations.security.vistalink.ServerPortKey"));
            }
            catch (NumberFormatException e1) {
                String errMsg = "Error converting port string to integer from the login configuration; port string was '" + (String)jaasOptions.get("gov.va.med.vistalink.security.ServerPortKey");
                logger.error((Object)errMsg, (Throwable)e);
                throw new VistaLoginModuleException(errMsg, e);
            }
        }
        try {
            this.myVCF = VistaLinkConnectionFactory.getVistaLinkConnectionFactory((String)serverAddress, (Integer)serverPort);
            logger.debug((Object)"Ggetting J2SE connection.");
            this.myConnection = (VistaLinkConnection)this.myVCF.getConnection();
            logger.debug((Object)("VistaLoginModuleSPIClientServer's connection: " + this.myConnection));
            this.mySecurityResponseFactory = new SecurityResponseFactory();
        }
        catch (VistaLinkResourceException e) {
            this.logoutConnectionBeforeLoginComplete();
            if (ExceptionUtils.getNestedExceptionByClass((Throwable)e, NoJobSlotsAvailableFaultException.class) != null) {
                throw new VistaLoginModuleNoJobSlotsAvailableException(exceptionMessage, e);
            }
            if (ExceptionUtils.getNestedExceptionByClass((Throwable)e, LoginsDisabledFaultException.class) != null) {
                throw new VistaLoginModuleLoginsDisabledException(exceptionMessage, e);
            }
            if (ExceptionUtils.getNestedExceptionByClass((Throwable)e, ConnectException.class) != null) {
                throw new VistaLoginModuleNoPathToListenerException(exceptionMessage, e);
            }
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
        catch (ResourceException e) {
            this.logoutConnectionBeforeLoginComplete();
            logger.error((Object)exceptionMessage, (Throwable)e);
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
    }

    public Object getSetupAndIntroTextInfo() throws VistaLoginModuleException {
        String exceptionMessage = "Error doing M setup/introduction text retrieval: ";
        try {
            SecurityVOSetupAndIntroText returnVal;
            SecurityResponse response = KernelSecurityHandshake.doSetupAndGetIntroText((VistaLinkConnection)this.myConnection, (SecurityResponseFactory)this.mySecurityResponseFactory);
            if (response instanceof SecurityDataSetupAndIntroTextResponse) {
                returnVal = new SecurityVOSetupAndIntroText((SecurityDataSetupAndIntroTextResponse)response);
                returnVal.setPort(this.myConnection.getConnectionInfo().getPort());
            } else if (response instanceof SecurityDataLogonResponse) {
                returnVal = ((SecurityDataLogonResponse)response).getSecurityVOLogon();
            } else {
                throw new VistaLoginModuleException("unexpected response type to setup/intro text request: '" + response.getClass().getName() + "'.");
            }
            return returnVal;
        }
        catch (SecurityFaultException e) {
            this.logoutConnectionBeforeLoginComplete();
            String errMsg = "Security fault occured on the M system.";
            throw new VistaLoginModuleException(exceptionMessage + errMsg, e);
        }
        catch (VistaLinkFaultException e) {
            this.logoutConnectionBeforeLoginComplete();
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
        catch (FoundationsException e) {
            this.logoutConnectionBeforeLoginComplete();
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
        catch (ParserConfigurationException e) {
            this.logoutConnectionBeforeLoginComplete();
            logger.error((Object)exceptionMessage, (Throwable)e);
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
    }

    public SecurityVOLogon doKernelLogon(String kernelCcowLogonToken) throws VistaLoginModuleException {
        return this.doKernelLogonInternal(null, null, kernelCcowLogonToken, false);
    }

    public SecurityVOLogon doKernelLogon(String accessCode, String verifyCode, boolean requestCvc) throws VistaLoginModuleException {
        return this.doKernelLogonInternal(accessCode, verifyCode, null, requestCvc);
    }

    private SecurityVOLogon doKernelLogonInternal(String accessCode, String verifyCode, String kernelCcowLogonToken, boolean requestCvc) throws VistaLoginModuleException {
        String exceptionMessage = "Error during login: ";
        try {
            if (accessCode == null) {
                return KernelSecurityHandshake.doAVLogon((VistaLinkConnection)this.myConnection, (SecurityResponseFactory)this.mySecurityResponseFactory, (String)kernelCcowLogonToken).getSecurityVOLogon();
            }
            return KernelSecurityHandshake.doAVLogon((VistaLinkConnection)this.myConnection, (SecurityResponseFactory)this.mySecurityResponseFactory, (String)accessCode, (String)verifyCode, (boolean)requestCvc).getSecurityVOLogon();
        }
        catch (VistaKernelHashCountLimitExceededException e) {
            this.logoutConnectionBeforeLoginComplete();
            logger.error((Object)exceptionMessage, (Throwable)e);
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
        catch (SecurityTooManyInvalidLoginAttemptsFaultException e) {
            this.logoutConnectionBeforeLoginComplete();
            String errMsg = "Login failed due to too many invalid login attempts.";
            throw new VistaLoginModuleTooManyInvalidAttemptsException(exceptionMessage + errMsg);
        }
        catch (SecurityIPLockedFaultException e) {
            this.logoutConnectionBeforeLoginComplete();
            String errMsg = "Login failed and IP locked due to too many invalid login attempts.";
            throw new VistaLoginModuleIPLockedException(exceptionMessage + errMsg);
        }
        catch (SecurityFaultException e) {
            this.logoutConnectionBeforeLoginComplete();
            String errMsg = "Security fault occured on the M system.";
            throw new VistaLoginModuleException(exceptionMessage + errMsg, e);
        }
        catch (VistaLinkFaultException e) {
            this.logoutConnectionBeforeLoginComplete();
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
        catch (FoundationsException e) {
            this.logoutConnectionBeforeLoginComplete();
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
        catch (ParserConfigurationException e) {
            this.logoutConnectionBeforeLoginComplete();
            logger.error((Object)exceptionMessage, (Throwable)e);
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
    }

    public SecurityVOChangeVc changeVerifyCode(String oldVerifyCode, String newVerifyCode, String newVerifyCodeCheck) throws VistaLoginModuleException {
        String exceptionMessage = "Change verify code failed: ";
        try {
            return KernelSecurityHandshake.doChangeVerifyCode((VistaLinkConnection)this.myConnection, (SecurityResponseFactory)this.mySecurityResponseFactory, (String)oldVerifyCode.toUpperCase(), (String)newVerifyCode.toUpperCase(), (String)newVerifyCodeCheck.toUpperCase()).getSecurityVOChangeVc();
        }
        catch (VistaLinkFaultException e) {
            this.logoutConnectionBeforeLoginComplete();
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
        catch (ParserConfigurationException e) {
            this.logoutConnectionBeforeLoginComplete();
            logger.error((Object)exceptionMessage, (Throwable)e);
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
        catch (FoundationsException e) {
            this.logoutConnectionBeforeLoginComplete();
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
    }

    public SecurityVOSelectDivision selectDivision(String selectedDivisionIen) throws VistaLoginModuleException {
        String exceptionMessage = "Select Division failed: ";
        try {
            return KernelSecurityHandshake.doSelectDivision((VistaLinkConnection)this.myConnection, (SecurityResponseFactory)this.mySecurityResponseFactory, (String)selectedDivisionIen).getSecurityVOSelectDivision();
        }
        catch (VistaLinkFaultException e) {
            this.logoutConnectionBeforeLoginComplete();
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
        catch (ParserConfigurationException e) {
            this.logoutConnectionBeforeLoginComplete();
            logger.error((Object)exceptionMessage, (Throwable)e);
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
        catch (FoundationsException e) {
            this.logoutConnectionBeforeLoginComplete();
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
    }

    public SecurityVOUserDemographics getUserDemographicsData() throws VistaLoginModuleException {
        String exceptionMessage = "User Demographic retrieval failure: ";
        try {
            return KernelSecurityHandshake.doGetUserDemographics((VistaLinkConnection)this.myConnection, (SecurityResponseFactory)this.mySecurityResponseFactory).getSecurityVOUserDemographics();
        }
        catch (VistaLinkFaultException e) {
            this.logoutConnectionBeforeLoginComplete();
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
        catch (ParserConfigurationException e) {
            this.logoutConnectionBeforeLoginComplete();
            logger.error((Object)exceptionMessage, (Throwable)e);
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
        catch (FoundationsException e) {
            this.logoutConnectionBeforeLoginComplete();
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
    }

    public String getKernelCcowToken() throws VistaLoginModuleException {
        String exceptionMessage = "Failed to retrieve Kernel CCOW token. ";
        if (this.myConnection == null) {
            throw new VistaLoginModuleException(exceptionMessage + "Connection is null.");
        }
        try {
            RpcRequest vReq = RpcRequestFactory.getRpcRequest((String)"XUS SIGNON", (String)"XUS GET CCOW TOKEN");
            vReq.setUseProprietaryMessageFormat(true);
            RpcResponse vResp = this.myConnection.executeRPC(vReq);
            return vResp.getResults();
        }
        catch (VistaLinkFaultException e) {
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
        catch (FoundationsException e) {
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
    }

    public String getSecureCcowPasscode() throws VistaLoginModuleException {
        logger.debug((Object)"in getSecureCcowPasscode.");
        String returnVal = "";
        String exceptionString = "Failed to retrieve CCOW passcode. ";
        if (this.myConnection == null) {
            throw new VistaLoginModuleException(exceptionString + "Connection is null.");
        }
        try {
            RpcRequest vReq = RpcRequestFactory.getRpcRequest((String)"XUS SIGNON", (String)"XUS CCOW VAULT PARAM");
            vReq.setUseProprietaryMessageFormat(true);
            RpcResponse vResp = this.myConnection.executeRPC(vReq);
            StringTokenizer st = new StringTokenizer(vResp.getResults(), "\n");
            if (st.countTokens() == 2) {
                returnVal = st.nextToken() + st.nextToken();
            } else {
                logger.warn((Object)"Attempted to get a secure CCOW passcode from M, was not able to correctly retrieve.");
            }
        }
        catch (VistaLinkFaultException e) {
            throw new VistaLoginModuleException(exceptionString, e);
        }
        catch (FoundationsException e) {
            throw new VistaLoginModuleException(exceptionString, e);
        }
        return returnVal;
    }

    public void addSPISpecificInformationToPrincipal(VistaKernelPrincipalImpl principal) {
        principal.setAuthenticatedConnection(this.myConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void logout() throws VistaLoginModuleException {
        String exceptionMessage = "Error while logging out: ";
        try {
            SecurityDataLogoutResponse responseData = null;
            if (this.myConnection == null) return;
            if (this.mySecurityResponseFactory == null) return;
            responseData = KernelSecurityHandshake.doLogout((VistaLinkConnection)this.myConnection, (SecurityResponseFactory)this.mySecurityResponseFactory);
            logger.debug((Object)("Result: " + responseData.getResultType()));
            if (responseData.getResultType() == 1) return;
            logger.error((Object)("Logout failure: " + responseData.getResultMessage()));
            return;
        }
        catch (VistaLinkFaultException e) {
            logger.error((Object)exceptionMessage, (Throwable)e);
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)exceptionMessage, (Throwable)e);
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
        catch (FoundationsException e) {
            logger.error((Object)exceptionMessage, (Throwable)e);
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
        catch (ResourceException e) {
            logger.error((Object)exceptionMessage, (Throwable)e);
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
        catch (IOException e) {
            logger.error((Object)exceptionMessage, (Throwable)e);
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
        finally {
            if (this.myConnection != null) {
                try {
                    this.myConnection.close();
                }
                catch (ResourceException err) {
                    logger.error((Object)exceptionMessage, (Throwable)err);
                }
                finally {
                    this.myConnection = null;
                }
            }
            this.myVCF = null;
        }
    }

    private void logoutConnectionBeforeLoginComplete() {
        try {
            this.logout();
        }
        catch (VistaLoginModuleException vistaLoginModuleException) {
            // empty catch block
        }
    }
}

