/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.security;

import gov.va.med.exception.FoundationsException;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnection;
import gov.va.med.vistalink.security.m.VistaKernelPrincipal;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class VistaKernelPrincipalImpl
implements Serializable,
VistaKernelPrincipal {
    private Hashtable userDemographicsHashTable;
    private transient VistaLinkConnection authenticatedConnection;
    private static final Logger LOGGER = Logger.getLogger(VistaKernelPrincipalImpl.class);
    private static final long serialVersionUID = 1L;

    VistaKernelPrincipalImpl(String nameNewPerson01) throws FoundationsException {
        if (nameNewPerson01 == null) {
            throw new FoundationsException("VistaKernelPrincipalImpl constructor: nameNewPerson01 cannot be null");
        }
        this.userDemographicsHashTable = new Hashtable();
        this.userDemographicsHashTable.put("KEY_NAME_NEWPERSON01", nameNewPerson01);
        this.authenticatedConnection = null;
    }

    VistaKernelPrincipalImpl(Hashtable userDemographicsHashtable) {
        this.userDemographicsHashTable = userDemographicsHashtable;
        this.authenticatedConnection = null;
    }

    public String getName() {
        return (String)this.userDemographicsHashTable.get("KEY_NAME_NEWPERSON01");
    }

    public VistaLinkConnection getAuthenticatedConnection() {
        return this.authenticatedConnection;
    }

    void setAuthenticatedConnection(VistaLinkConnection vistaConnection) {
        this.authenticatedConnection = vistaConnection;
    }

    void setUserDemographicValue(String key, String value) {
        this.userDemographicsHashTable.put(key, value);
    }

    public String getUserDemographicValue(String key) {
        return (String)this.userDemographicsHashTable.get(key);
    }

    public String toString() {
        return "VistaKernelPrincipalImpl Name:  " + this.getName() + " Division: " + this.userDemographicsHashTable.get("KEY_DIVISION_STATION_NAME") + " " + this.userDemographicsHashTable.get("KEY_DIVISION_STATION_NUMBER") + " Timeout: " + this.userDemographicsHashTable.get("KEY_DTIME");
    }

    public static VistaKernelPrincipalImpl getKernelPrincipal(Subject jaasSubject) throws FoundationsException {
        VistaKernelPrincipalImpl myPrincipal = null;
        Set<VistaKernelPrincipal> setPrincipals = jaasSubject.getPrincipals(VistaKernelPrincipal.class);
        if (setPrincipals.size() != 1) {
            if (setPrincipals.isEmpty()) {
                String errMsg = "Error getting Kernel Principal: No Kernel Principals Found";
                FoundationsException e = new FoundationsException(errMsg);
                if (LOGGER.isEnabledFor((Priority)Level.ERROR)) {
                    LOGGER.error((Object)errMsg, (Throwable)e);
                }
                throw e;
            }
            String errMsg = "Error getting Kernel Principal: Multiple Kernel Principals Found";
            FoundationsException e = new FoundationsException(errMsg);
            if (LOGGER.isEnabledFor((Priority)Level.ERROR)) {
                LOGGER.error((Object)errMsg, (Throwable)e);
            }
            throw e;
        }
        myPrincipal = (VistaKernelPrincipalImpl)setPrincipals.iterator().next();
        return myPrincipal;
    }
}

