/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.security;

import gov.va.med.vistalink.security.CallbackSelectDivision;
import gov.va.med.vistalink.security.DialogConfirm;
import gov.va.med.vistalink.security.VistaLoginSwingUtilities;
import gov.va.med.vistalink.security.m.VistaInstitutionVO;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;

final class DialogSelectDivision
extends JDialog {
    private static final String DEFAULT_TITLE = "Select Division";
    private static final String OK_BUTTON_LABEL = "OK";
    private static final char OK_BUTTON_MNEMONIC = 'O';
    private static final String OK_BUTTON_TOOLTIP = "Submit your division choice to the server";
    private static final String HELP_BUTTON_LABEL = "Help";
    private static final char HELP_BUTTON_MNEMONIC = 'H';
    private static final String HELP_BUTTON_TOOLTIP = "Ask for help on this dialog";
    private static final String CANCEL_BUTTON_LABEL = "Cancel";
    private static final char CANCEL_BUTTON_MNEMONIC = 'C';
    private static final String CANCEL_BUTTON_TOOLTIP = "Cancel the login";
    private static final String DEFAULT_LABEL = "Must Select Division to Continue Sign On!";
    private static final String DEFAULT_LABEL_TOOLTIP = "You must select a division for this sign on";
    private static final String LIST_TOOLTIP = "List of Valid Divisions to select for Sign On";
    private static final char LIST_MNEMONIC = 'D';
    private static final String HELP_MSG_1 = "Select a division from the list and click OK.";
    private static final String HELP_MSG_2 = "To abort the logon click Cancel, but sign on will not be completed.";
    private JList jListDivisions;
    private Frame parentFrame;
    private CallbackSelectDivision divCbh;

    static void showVistaAVSwingSelectDivision(Frame parent, CallbackSelectDivision divCbh) {
        DialogSelectDivision dialog = new DialogSelectDivision(parent, divCbh);
        if (parent != null && !"".equals(parent.getTitle())) {
            dialog.setTitle(parent.getTitle() + ": " + "Sign-on" + " " + DEFAULT_TITLE);
        } else {
            dialog.setTitle("HealtheVet-VistA Sign-on: Select Division");
        }
        VistaLoginSwingUtilities.goldenMeanCenterDialog(parent, dialog);
        dialog.setVisible(true);
    }

    private DialogSelectDivision(Frame parentFrame, CallbackSelectDivision divCbh) {
        super(parentFrame, DEFAULT_TITLE, true);
        this.divCbh = divCbh;
        this.parentFrame = parentFrame;
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.createLabelAndListPane(), "Center");
        contentPane.add((Component)this.createButtonPane(), "South");
        this.pack();
        VistaLoginSwingUtilities.goldenMeanCenterDialog(parentFrame, this);
        int timeout = 1000 * this.divCbh.getTimeoutInSeconds();
        ActionListener taskPerformer = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogSelectDivision.this.doTimeout();
            }
        };
        this.getAccessibleContext().setAccessibleDescription(DEFAULT_LABEL_TOOLTIP);
        new Timer(timeout, taskPerformer).start();
        this.jListDivisions.requestFocusInWindow();
    }

    private JComponent createLabelAndListPane() {
        JPanel listPane = new JPanel();
        listPane.setLayout(new BoxLayout(listPane, 1));
        JLabel label = new JLabel(DEFAULT_LABEL);
        label.setToolTipText(DEFAULT_LABEL_TOOLTIP);
        listPane.add(label);
        listPane.add(Box.createRigidArea(new Dimension(0, 5)));
        listPane.add(this.createListScrollPane());
        label.setDisplayedMnemonic('D');
        label.setLabelFor(this.jListDivisions);
        listPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        return listPane;
    }

    private JComponent createButtonPane() {
        JPanel myPanel = new JPanel();
        GridLayout myGridLayout = new GridLayout(1, 3);
        myPanel.setLayout(myGridLayout);
        myPanel.add(this.createOkButtonPane());
        myPanel.add(this.createCancelButtonPane());
        myPanel.add(this.createHelpButtonPane());
        return myPanel;
    }

    private JScrollPane createListScrollPane() {
        JScrollPane listScroller = new JScrollPane(this.createDivisionJList());
        listScroller.setAlignmentX(0.0f);
        listScroller.setToolTipText(LIST_TOOLTIP);
        return listScroller;
    }

    private JComponent createHelpButtonPane() {
        JPanel p = new JPanel();
        FlowLayout myFlowLayout = new FlowLayout();
        myFlowLayout.setAlignment(0);
        p.add(this.createHelpButton());
        return p;
    }

    private JComponent createOkButtonPane() {
        JPanel p = new JPanel();
        FlowLayout myFlowLayout = new FlowLayout();
        myFlowLayout.setAlignment(0);
        p.add(this.createOkButton());
        return p;
    }

    private JComponent createCancelButtonPane() {
        JPanel p = new JPanel();
        FlowLayout myFlowLayout = new FlowLayout();
        myFlowLayout.setAlignment(1);
        p.add(this.createCancelButton());
        return p;
    }

    private JButton createHelpButton() {
        JButton help = new JButton(HELP_BUTTON_LABEL);
        help.setMnemonic('H');
        help.setToolTipText(HELP_BUTTON_TOOLTIP);
        help.setFont(help.getFont().deriveFont(1));
        help.addActionListener(new HelpButtonActionListener());
        return help;
    }

    private JButton createOkButton() {
        JButton ok = new JButton(OK_BUTTON_LABEL);
        ok.setMnemonic('O');
        ok.setToolTipText(OK_BUTTON_TOOLTIP);
        ok.setFont(ok.getFont().deriveFont(1));
        this.getRootPane().setDefaultButton(ok);
        ok.setAlignmentX(1.0f);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogSelectDivision.this.okActionPerformed();
            }
        });
        return ok;
    }

    private JButton createCancelButton() {
        JButton cancel = new JButton(CANCEL_BUTTON_LABEL);
        cancel.setMnemonic('C');
        cancel.setToolTipText(CANCEL_BUTTON_TOOLTIP);
        cancel.setFont(cancel.getFont().deriveFont(1));
        cancel.setAlignmentX(1.0f);
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogSelectDivision.this.cancelActionPerformed();
            }
        });
        return cancel;
    }

    private JComponent createDivisionJList() {
        TreeMap divisionList = (TreeMap)this.divCbh.getDivisionList();
        Vector<String> divisionListData = new Vector<String>();
        String defaultListString = "";
        for (Map.Entry entry : divisionList.entrySet()) {
            VistaInstitutionVO myDivision = (VistaInstitutionVO)entry.getValue();
            String listString = "(" + myDivision.getNumber() + ") " + myDivision.getName();
            divisionListData.add(listString);
            if (!myDivision.getIsDefaultLogonDivision()) continue;
            defaultListString = listString;
        }
        this.jListDivisions = new JList();
        this.jListDivisions.setSelectionMode(0);
        this.jListDivisions.setListData(divisionListData);
        this.jListDivisions.setToolTipText(LIST_TOOLTIP);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && DialogSelectDivision.this.jListDivisions.locationToIndex(e.getPoint()) == DialogSelectDivision.this.jListDivisions.getSelectedIndex()) {
                    DialogSelectDivision.this.storeSelectedDivision(DialogSelectDivision.this.jListDivisions.getSelectedIndex(), DialogSelectDivision.this.jListDivisions.getSelectedValue());
                    DialogSelectDivision.this.divCbh.setSelectedOption(1);
                    DialogSelectDivision.this.setVisible(false);
                    DialogSelectDivision.this.dispose();
                }
            }
        };
        this.jListDivisions.addMouseListener(mouseListener);
        for (int i = 0; i < this.jListDivisions.getModel().getSize(); ++i) {
            if (!((String)this.jListDivisions.getModel().getElementAt(i)).equalsIgnoreCase(defaultListString)) continue;
            this.jListDivisions.setSelectedIndex(i);
            break;
        }
        return this.jListDivisions;
    }

    private void okActionPerformed() {
        this.storeSelectedDivision(this.jListDivisions.getSelectedIndex(), this.jListDivisions.getSelectedValue());
        this.divCbh.setSelectedOption(1);
        this.setVisible(false);
        this.dispose();
    }

    private boolean storeSelectedDivision(int selectedIndex, Object selectedValue) {
        boolean returnVal = false;
        TreeMap divisionList = (TreeMap)this.divCbh.getDivisionList();
        this.divCbh.setSelectedDivisionIen("-1");
        int index = -1;
        for (Map.Entry entry : divisionList.entrySet()) {
            VistaInstitutionVO myDivision = (VistaInstitutionVO)entry.getValue();
            if (selectedIndex != ++index || !selectedValue.equals("(" + myDivision.getNumber() + ") " + myDivision.getName())) continue;
            this.divCbh.setSelectedDivisionIen(myDivision.getIen());
            returnVal = true;
        }
        return returnVal;
    }

    private void cancelActionPerformed() {
        this.divCbh.setSelectedDivisionIen("-1");
        this.divCbh.setSelectedOption(0);
        this.setVisible(false);
        this.dispose();
    }

    private void doTimeout() {
        this.divCbh.setSelectedDivisionIen("-1");
        this.divCbh.setSelectedOption(2);
        this.setVisible(false);
        this.dispose();
    }

    class HelpButtonActionListener
    implements ActionListener {
        HelpButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            StringBuffer sb = new StringBuffer(DialogSelectDivision.HELP_MSG_1);
            sb.append('\n');
            sb.append(DialogSelectDivision.HELP_MSG_2);
            int returnVal = DialogConfirm.showDialogConfirm(DialogSelectDivision.this.parentFrame, sb.toString(), "Sign-on Select Division Help", 2, DialogSelectDivision.this.divCbh.getTimeoutInSeconds());
            if (returnVal == 12) {
                DialogSelectDivision.this.doTimeout();
            } else {
                DialogSelectDivision.this.jListDivisions.requestFocusInWindow();
            }
        }
    }
}

