/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.security;

import gov.va.med.vistalink.security.CallbackLogon;
import gov.va.med.vistalink.security.DialogConfirm;
import gov.va.med.vistalink.security.VistaLoginSwingUtilities;
import gov.va.med.vistalink.security.m.SecurityVOSetupAndIntroText;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;

final class DialogLogon
extends JDialog {
    static final String DEFAULT_TITLE = "HealtheVet-VistA Sign-on";
    static final String SIGNON_STRING = "Sign-on";
    private static final String ACCESS_LABEL = "Access Code: ";
    private static final char ACCESS_MNEMONIC = 'A';
    private static final String ACCESS_TOOLTIP = "Enter your VistA access code";
    private static final String VERIFY_LABEL = "Verify Code: ";
    private static final char VERIFY_MNEMONIC = 'V';
    private static final String VERIFY_TOOLTIP = "Enter your VistA Verify code";
    private static final String OK_BUTTON_LABEL = "OK";
    private static final char OK_BUTTON_MNEMONIC = 'O';
    private static final String OK_BUTTON_TOOLTIP = "Submits your login request to the server";
    private static final String CANCEL_BUTTON_LABEL = "Cancel";
    private static final char CANCEL_BUTTON_MNEMONIC = 'C';
    private static final String CANCEL_BUTTON_TOOLTIP = "Cancels your login request";
    private static final String CVC_CHECKBOX_LABEL = "Change Verify Code";
    private static final char CVC_CHECKBOX_MNEMONIC = 'E';
    private static final String CVC_CHECKBOX_TOOLTIP = "Ask to change your verify code";
    private static final String VA_LOGO = "images/HealtheVetVistaSmallBlueSm.gif";
    private static final String VA_LOGO_TOOLTIP = "HealtheVet-VistA logo";
    private static final String SERVER_LABEL = "Server: ";
    private static final String VOLUME_LABEL = "Volume: ";
    private static final String UCI_LABEL = "U C I: ";
    private static final String DEVICE_LABEL = "Device: ";
    private static final String SERVER_INFO_LABEL = "Server Information: ";
    private static final String SERVER_INFO_TOOLTIP = "Information about the M server in use for the current connection";
    private static final char SERVER_INFO_MNEMONIC = 'S';
    private static final String BUTTON_508_TEXT = "Section 508 Information";
    private static final String BUTTON_508_TOOLTIP = "Display Section 508 compliance information for this application";
    private static final int BUTTON_508_MNEMONIC = 53;
    private static final String[] TEXT_508_DISCLAIMER = new String[]{"V A's Office of Information & Technology, Veteran Health Information Technology staff have made", "every effort during the design, development and testing of this login screen to ensure full", "accessibility to all users in compliance with Section 508 of the Rehabilitation Act of 1973, as", "amended. Please send any comments, questions or concerns regarding the accessibility of this", "login module to Section508 @ v a dot gov [Section508@va.gov]."};
    private static final String JTEXTAREA_TOOLTIP = "System Announcements";
    private static final String JTEXTAREA_LABEL = "System Announcements:";
    private static final char JTEXTAREA_MNEMONIC = 'N';
    private static final int CODE_FIELD_COLUMNS = 13;
    private JScrollPane introScrollPane;
    private JPasswordField accessPasswordField;
    private JPasswordField verifyPasswordField;
    private JLabel accessLabel;
    private JLabel verifyLabel;
    private JLabel introLabel;
    private JCheckBox cvcCheckBox;
    private JButton okButton;
    private JButton cancelButton;
    private JButton section508Button;
    private JTextArea introTextArea;
    private Border introFocusBorder;
    private Border introNoFocusBorder;
    private Border serverInfoFocusBorder;
    private Border serverInfoNoFocusBorder;
    private Frame parentFrame;
    private JLabel serverInfoLabel;
    private JTextField serverInfoTextField;
    private CallbackLogon callbackAV;

    static void showVistaAVSwingGetAV(Frame parent, CallbackLogon callbackAV) {
        DialogLogon dialog = new DialogLogon(parent, callbackAV);
        if (parent != null && !"".equals(parent.getTitle())) {
            dialog.setTitle(parent.getTitle() + ": " + DEFAULT_TITLE);
        } else {
            dialog.setTitle(DEFAULT_TITLE);
        }
        VistaLoginSwingUtilities.goldenMeanCenterDialog(parent, dialog);
        dialog.setVisible(true);
    }

    private DialogLogon(Frame parent, CallbackLogon callbackAV) {
        super(parent, DEFAULT_TITLE, true);
        this.callbackAV = callbackAV;
        this.parentFrame = parent;
        BoxLayout mainLayout = new BoxLayout(this.getContentPane(), 1);
        this.getContentPane().setLayout(mainLayout);
        this.createIntroPane();
        JPanel annLabelPanel = this.createIntroLabelPane();
        JPanel contentPane = this.createContentPane();
        this.getContentPane().add(annLabelPanel);
        this.getContentPane().add(this.introScrollPane);
        this.getContentPane().add(contentPane);
        this.getContentPane().setFocusCycleRoot(true);
        this.getContentPane().setFocusTraversalPolicy(new DialogLogonFocusTraversalPolicy());
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        if (this.getSize().width > screenSize.width || this.getSize().height > screenSize.height) {
            this.setSize(screenSize);
        }
        VistaLoginSwingUtilities.goldenMeanCenterDialog(parent, this);
        this.getAccessibleContext().setAccessibleDescription("This dialog asks you to enter your access and verify codes to log into the computer system.");
        int timeout = 1000 * this.callbackAV.getTimeoutInSeconds();
        ActionListener taskPerformer = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogLogon.this.doTimeout();
            }
        };
        new Timer(timeout, taskPerformer).start();
        this.accessPasswordField.requestFocusInWindow();
    }

    private JPanel createIntroLabelPane() {
        this.introLabel = new JLabel(JTEXTAREA_LABEL);
        this.introLabel.setDisplayedMnemonic('N');
        this.introLabel.setToolTipText(JTEXTAREA_TOOLTIP);
        this.introLabel.setLabelFor(this.introTextArea);
        this.introLabel.setFocusable(true);
        this.introLabel.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                DialogLogon.this.introTextArea.requestFocusInWindow();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        JPanel annPanel = new JPanel();
        FlowLayout myLayout = new FlowLayout();
        myLayout.setAlignment(0);
        annPanel.setLayout(myLayout);
        annPanel.add(this.introLabel);
        return annPanel;
    }

    private void createIntroPane() {
        Border defaultBorder = UIManager.getBorder("TextField.border");
        this.introFocusBorder = BorderFactory.createCompoundBorder(UIManager.getBorder("List.focusCellHighlightBorder"), defaultBorder);
        this.introNoFocusBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getColor("control"), 1), defaultBorder);
        this.introTextArea = new JTextArea(this.callbackAV.getSetupAndIntroTextInfo().getIntroductoryText());
        this.introTextArea.setCaretPosition(0);
        this.introTextArea.setToolTipText(JTEXTAREA_TOOLTIP);
        this.introTextArea.setEditable(false);
        this.introTextArea.setMargin(new Insets(3, 3, 3, 3));
        this.introTextArea.setColumns(80);
        if (this.introTextArea.getLineCount() > 20) {
            this.introTextArea.setRows(20);
        }
        this.introTextArea.setFocusable(true);
        this.introTextArea.getAccessibleContext().setAccessibleName(JTEXTAREA_LABEL + this.callbackAV.getSetupAndIntroTextInfo().getIntroductoryText());
        this.introTextArea.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                DialogLogon.this.introScrollPane.setBorder(DialogLogon.this.introFocusBorder);
            }

            public void focusLost(FocusEvent e) {
                DialogLogon.this.introScrollPane.setBorder(DialogLogon.this.introNoFocusBorder);
            }
        });
        Font currentFont = this.introTextArea.getFont();
        this.introTextArea.setFont(new Font("monospaced", currentFont.getStyle(), currentFont.getSize()));
        this.introScrollPane = new JScrollPane(this.introTextArea);
        this.introScrollPane.setBorder(this.introNoFocusBorder);
    }

    private JPanel createContentPane() {
        GridBagLayout gridbag = new GridBagLayout();
        this.accessPasswordField = new JPasswordField("", 13);
        this.accessPasswordField.setToolTipText(ACCESS_TOOLTIP);
        this.accessLabel = new JLabel(ACCESS_LABEL);
        this.accessLabel.setHorizontalAlignment(4);
        this.accessLabel.setFont(this.accessLabel.getFont().deriveFont(1));
        this.accessLabel.setToolTipText(ACCESS_TOOLTIP);
        this.accessLabel.setDisplayedMnemonic('A');
        this.accessLabel.setLabelFor(this.accessPasswordField);
        this.accessLabel.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                DialogLogon.this.accessPasswordField.requestFocusInWindow();
            }
        });
        this.verifyPasswordField = new JPasswordField("", 13);
        this.verifyPasswordField.setToolTipText(VERIFY_TOOLTIP);
        this.verifyLabel = new JLabel(VERIFY_LABEL);
        this.verifyLabel.setHorizontalAlignment(4);
        this.verifyLabel.setFont(this.verifyLabel.getFont().deriveFont(1));
        this.verifyLabel.setToolTipText(VERIFY_TOOLTIP);
        this.verifyLabel.setDisplayedMnemonic('V');
        this.verifyLabel.setLabelFor(this.verifyPasswordField);
        this.verifyLabel.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                DialogLogon.this.verifyPasswordField.requestFocusInWindow();
            }
        });
        Dimension minimumDimension = new Dimension(this.accessPasswordField.getFontMetrics(this.accessPasswordField.getFont()).charWidth('a') * 8, this.accessPasswordField.getFontMetrics(this.accessPasswordField.getFont()).getHeight());
        this.accessPasswordField.setMinimumSize(minimumDimension);
        this.verifyPasswordField.setMinimumSize(minimumDimension);
        JPanel p = new JPanel();
        p.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.insets = new Insets(5, 5, 5, 5);
        c.ipady = 0;
        c.ipadx = 0;
        c.weightx = 0.0;
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 3;
        c.weightx = 10.0;
        p.add((Component)this.createLogoLabel(), c);
        c.gridy = 3;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 2.0;
        p.add((Component)this.create508Button(), c);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 4.0;
        p.add((Component)this.accessLabel, c);
        c.weightx = 4.0;
        c.gridy = 1;
        p.add((Component)this.verifyLabel, c);
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 4.0;
        c.ipady = 3;
        c.ipadx = 3;
        p.add((Component)this.accessPasswordField, c);
        c.gridy = 1;
        c.weightx = 4.0;
        c.ipady = 3;
        c.ipadx = 3;
        p.add((Component)this.verifyPasswordField, c);
        this.createOKButton();
        c.gridx = 3;
        c.gridy = 0;
        c.fill = 2;
        c.ipady = 3;
        c.ipadx = 3;
        c.weightx = 2.0;
        p.add((Component)this.okButton, c);
        this.createCancelButton();
        c.gridy = 1;
        c.fill = 2;
        c.ipady = 3;
        c.ipadx = 3;
        c.weightx = 2.0;
        p.add((Component)this.cancelButton, c);
        c.gridx = 2;
        c.gridy = 2;
        c.ipady = 0;
        c.ipadx = 0;
        c.gridheight = 1;
        c.gridwidth = 2;
        c.weightx = 2.0;
        c.fill = 0;
        c.anchor = 18;
        p.add((Component)this.createCvcPanel(), c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 4;
        c.weightx = 2.0;
        c.anchor = 10;
        JPanel serverInfoPanel = this.createServerInfoPanel(this.callbackAV.getSetupAndIntroTextInfo());
        p.add((Component)serverInfoPanel, c);
        return p;
    }

    private JComponent createCvcPanel() {
        JPanel myPanel = new JPanel();
        FlowLayout myLayout = new FlowLayout();
        myLayout.setAlignment(0);
        myPanel.setLayout(myLayout);
        this.cvcCheckBox = new JCheckBox(CVC_CHECKBOX_LABEL, false);
        this.cvcCheckBox.setMnemonic('E');
        this.cvcCheckBox.setToolTipText(CVC_CHECKBOX_TOOLTIP);
        this.cvcCheckBox.setBorder(BorderFactory.createEmptyBorder());
        this.cvcCheckBox.setOpaque(false);
        myPanel.add(this.cvcCheckBox);
        return myPanel;
    }

    private void createCancelButton() {
        this.cancelButton = new JButton(CANCEL_BUTTON_LABEL);
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setToolTipText(CANCEL_BUTTON_TOOLTIP);
        this.cancelButton.setFont(this.cancelButton.getFont().deriveFont(1));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogLogon.this.cancelActionPerformed();
            }
        });
    }

    private void createOKButton() {
        this.okButton = new JButton(OK_BUTTON_LABEL);
        this.okButton.setMnemonic('O');
        this.okButton.setToolTipText(OK_BUTTON_TOOLTIP);
        this.okButton.setFont(this.okButton.getFont().deriveFont(1));
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogLogon.this.okActionPerformed();
            }
        });
    }

    private JPanel createServerInfoPanel(SecurityVOSetupAndIntroText setupInfo) {
        StringBuffer sb = new StringBuffer(" ");
        sb.append(SERVER_LABEL);
        sb.append(setupInfo.getServerName());
        sb.append("; ");
        sb.append(VOLUME_LABEL);
        sb.append(setupInfo.getVolume());
        sb.append("; ");
        sb.append(UCI_LABEL);
        sb.append(setupInfo.getUci());
        sb.append("; ");
        sb.append(DEVICE_LABEL);
        sb.append(setupInfo.getDevice());
        Border defaultBorder = UIManager.getBorder("TextField.border");
        this.serverInfoFocusBorder = BorderFactory.createCompoundBorder(UIManager.getBorder("List.focusCellHighlightBorder"), defaultBorder);
        this.serverInfoNoFocusBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getColor("control"), 1), defaultBorder);
        this.serverInfoTextField = new JTextField(sb.toString());
        this.serverInfoTextField.setToolTipText(SERVER_INFO_TOOLTIP);
        this.serverInfoTextField.setEditable(false);
        this.serverInfoTextField.setFocusable(true);
        this.serverInfoTextField.setMargin(new Insets(1, 4, 1, 4));
        Dimension minimumDimension = new Dimension(this.serverInfoTextField.getFontMetrics(this.serverInfoTextField.getFont()).charWidth('a') * sb.length(), this.serverInfoTextField.getFontMetrics(this.serverInfoTextField.getFont()).getHeight() + 4);
        this.serverInfoTextField.setMinimumSize(minimumDimension);
        this.serverInfoTextField.getAccessibleContext().setAccessibleName(SERVER_INFO_LABEL + sb.toString());
        this.serverInfoTextField.setBorder(this.serverInfoNoFocusBorder);
        this.serverInfoTextField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                DialogLogon.this.serverInfoTextField.setBorder(DialogLogon.this.serverInfoFocusBorder);
            }

            public void focusLost(FocusEvent e) {
                DialogLogon.this.serverInfoTextField.setBorder(DialogLogon.this.serverInfoNoFocusBorder);
            }
        });
        this.serverInfoLabel = new JLabel(SERVER_INFO_LABEL);
        this.serverInfoLabel.setToolTipText(SERVER_INFO_TOOLTIP);
        this.serverInfoLabel.setFocusable(true);
        this.serverInfoLabel.setDisplayedMnemonic('S');
        this.serverInfoLabel.setLabelFor(this.serverInfoTextField);
        JPanel p = new JPanel();
        BoxLayout myBoxLayout = new BoxLayout(p, 0);
        p.setLayout(myBoxLayout);
        p.add(this.serverInfoLabel);
        p.add(this.serverInfoTextField);
        return p;
    }

    private JLabel createLogoLabel() {
        ImageIcon vaIcon = new ImageIcon(this.getClass().getResource(VA_LOGO));
        vaIcon.setDescription(VA_LOGO_TOOLTIP);
        vaIcon.getAccessibleContext().setAccessibleName("VA Logo");
        vaIcon.getAccessibleContext().setAccessibleDescription("VA Logo");
        JLabel l = new JLabel(vaIcon);
        l.setFocusable(false);
        l.setToolTipText(VA_LOGO_TOOLTIP);
        return l;
    }

    private JButton create508Button() {
        this.section508Button = new JButton(BUTTON_508_TEXT);
        this.section508Button.setToolTipText(BUTTON_508_TOOLTIP);
        this.section508Button.setMnemonic(53);
        this.section508Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < TEXT_508_DISCLAIMER.length; ++i) {
                    sb.append(TEXT_508_DISCLAIMER[i]);
                    sb.append('\n');
                }
                int returnVal = DialogConfirm.showDialogConfirm(DialogLogon.this.parentFrame, sb.toString(), "Sign-on Section 508 Information", 1, DialogLogon.this.callbackAV.getTimeoutInSeconds());
                if (returnVal == 12) {
                    DialogLogon.this.doTimeout();
                }
            }
        });
        return this.section508Button;
    }

    private void okActionPerformed() {
        this.callbackAV.setAccessCode(this.accessPasswordField.getPassword());
        this.callbackAV.setVerifyCode(this.verifyPasswordField.getPassword());
        this.callbackAV.setRequestCvc(this.cvcCheckBox.isSelected());
        this.callbackAV.setSelectedOption(1);
        this.setVisible(false);
        this.dispose();
    }

    private void cancelActionPerformed() {
        this.callbackAV.setAccessCode(null);
        this.callbackAV.setVerifyCode(null);
        this.callbackAV.setSelectedOption(0);
        this.setVisible(false);
        this.dispose();
    }

    private void doTimeout() {
        this.callbackAV.setAccessCode(null);
        this.callbackAV.setVerifyCode(null);
        this.callbackAV.setSelectedOption(2);
        this.setVisible(false);
        this.dispose();
    }

    class DialogLogonFocusTraversalPolicy
    extends FocusTraversalPolicy {
        DialogLogonFocusTraversalPolicy() {
        }

        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(DialogLogon.this.accessPasswordField)) {
                return DialogLogon.this.verifyPasswordField;
            }
            if (aComponent.equals(DialogLogon.this.verifyPasswordField)) {
                return DialogLogon.this.okButton;
            }
            if (aComponent.equals(DialogLogon.this.okButton)) {
                return DialogLogon.this.cancelButton;
            }
            if (aComponent.equals(DialogLogon.this.cancelButton)) {
                return DialogLogon.this.cvcCheckBox;
            }
            if (aComponent.equals(DialogLogon.this.cvcCheckBox)) {
                return DialogLogon.this.section508Button;
            }
            if (aComponent.equals(DialogLogon.this.section508Button)) {
                return DialogLogon.this.serverInfoTextField;
            }
            if (aComponent.equals(DialogLogon.this.serverInfoTextField)) {
                return DialogLogon.this.introTextArea;
            }
            if (aComponent.equals(DialogLogon.this.introTextArea)) {
                return DialogLogon.this.accessPasswordField;
            }
            if (aComponent.equals(DialogLogon.this.accessLabel)) {
                return DialogLogon.this.accessPasswordField;
            }
            if (aComponent.equals(DialogLogon.this.verifyLabel)) {
                return DialogLogon.this.verifyPasswordField;
            }
            if (aComponent.equals(DialogLogon.this.introLabel)) {
                return DialogLogon.this.introTextArea;
            }
            return DialogLogon.this.accessPasswordField;
        }

        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(DialogLogon.this.introTextArea)) {
                return DialogLogon.this.serverInfoTextField;
            }
            if (aComponent.equals(DialogLogon.this.serverInfoTextField)) {
                return DialogLogon.this.section508Button;
            }
            if (aComponent.equals(DialogLogon.this.section508Button)) {
                return DialogLogon.this.cvcCheckBox;
            }
            if (aComponent.equals(DialogLogon.this.cvcCheckBox)) {
                return DialogLogon.this.cancelButton;
            }
            if (aComponent.equals(DialogLogon.this.cancelButton)) {
                return DialogLogon.this.okButton;
            }
            if (aComponent.equals(DialogLogon.this.okButton)) {
                return DialogLogon.this.verifyPasswordField;
            }
            if (aComponent.equals(DialogLogon.this.verifyPasswordField)) {
                return DialogLogon.this.accessPasswordField;
            }
            if (aComponent.equals(DialogLogon.this.accessPasswordField)) {
                return DialogLogon.this.introTextArea;
            }
            if (aComponent.equals(DialogLogon.this.accessLabel)) {
                return DialogLogon.this.cvcCheckBox;
            }
            if (aComponent.equals(DialogLogon.this.verifyLabel)) {
                return DialogLogon.this.accessPasswordField;
            }
            if (aComponent.equals(DialogLogon.this.introLabel)) {
                return DialogLogon.this.serverInfoTextField;
            }
            return DialogLogon.this.accessPasswordField;
        }

        public Component getDefaultComponent(Container focusCycleRoot) {
            return DialogLogon.this.accessPasswordField;
        }

        public Component getLastComponent(Container focusCycleRoot) {
            return DialogLogon.this.introTextArea;
        }

        public Component getFirstComponent(Container focusCycleRoot) {
            return DialogLogon.this.accessPasswordField;
        }
    }
}

