/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.security;

import gov.va.med.vistalink.security.VistaLoginSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;

public final class DialogConfirm
extends JDialog {
    public static final int MODE_ERROR_MESSAGE = 0;
    public static final int MODE_INFORMATION_MESSAGE = 1;
    public static final int MODE_HELP_MESSAGE = 2;
    public static final int OK_OPTION = 10;
    public static final int CANCEL_OPTION = 11;
    public static final int TIMEOUT_OPTION = 12;
    private static final String OK_BUTTON_LABEL = "OK";
    private static final char OK_BUTTON_MNEMONIC = 'O';
    private static final String OK_BUTTON_TOOLTIP = "Sends OK confirmation";
    private static final String MESSAGE_AREA_TOOLTIP = "Message displayed by this dialog.";
    private static final String CANCEL_BUTTON_LABEL = "Cancel";
    private static final char CANCEL_BUTTON_MNEMONIC = 'C';
    private static final String CANCEL_BUTTON_TOOLTIP = "Sends cancel request";
    private static final String ERROR_LABEL = "Error:";
    private static final char ERROR_MNEMONIC = 'E';
    private static final String ERROR_LOGO = "images/error.gif";
    private static final String ERROR_LOGO_TOOLTIP = "Error logo";
    private static final String SUCCESS_LABEL = "Information:";
    private static final char SUCCESS_MNEMONIC = 'I';
    private static final String SUCCESS_LOGO = "images/yes1a.gif";
    private static final String SUCCESS_LOGO_TOOLTIP = "Informational logo";
    private static final String HELP_LABEL = "Help:";
    private static final char HELP_MNEMONIC = 'H';
    private static final String HELP_LOGO = "images/helpbook07.gif";
    private static final String HELP_LOGO_TOOLTIP = "Help logo";
    private String message;
    private int messageMode;
    private int returnVal;
    private Border focusBorder;
    private Border noFocusBorder;
    private JScrollPane messageScrollPane;
    private JButton okButton;
    private JButton cancelButton;
    private JLabel logoLabel;
    private JLabel messageTypeLabel;
    private JTextArea messageTextArea;

    public static int showDialogConfirm(Frame parent, String message, String windowTitle, int messageMode, int timeoutInSeconds) {
        String newWindowTitle = null;
        newWindowTitle = parent != null && !"".equals(parent.getTitle()) ? parent.getTitle() + ": " + windowTitle : "HealtheVet-VistA Sign-on: " + windowTitle;
        DialogConfirm dialog = new DialogConfirm(parent, message, newWindowTitle, messageMode, timeoutInSeconds);
        dialog.setVisible(true);
        return dialog.returnVal;
    }

    private DialogConfirm(Frame parent, String message, String windowTitle, int messageMode, int timeoutInSeconds) {
        super(parent, windowTitle, true);
        this.message = message;
        this.messageMode = messageMode;
        this.createContentPane();
        this.pack();
        VistaLoginSwingUtilities.goldenMeanCenterDialog(parent, this);
        this.setFocusTraversalPolicy(new DialogConfirmFocusTraversalPolicy());
        this.getAccessibleContext().setAccessibleDescription(this.messageTextArea.getText());
        int timeout = -1;
        timeout = 1000 * timeoutInSeconds;
        ActionListener taskPerformer = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DialogConfirm.this.doTimeout();
            }
        };
        new Timer(timeout, taskPerformer).start();
    }

    private void createContentPane() {
        JPanel logoPanel = this.createLogoPanel();
        this.createTextAreaComponents();
        JPanel buttonPanel = this.createButtonPanel();
        StringBuffer sb = new StringBuffer();
        sb.append(this.okButton.getText());
        sb.append(" button: ");
        sb.append(this.messageTypeLabel.getText());
        sb.append(this.messageTextArea.getText());
        this.okButton.getAccessibleContext().setAccessibleName(sb.toString());
        this.messageTypeLabel.setLabelFor(this.messageTextArea);
        this.messageTypeLabel.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                DialogConfirm.this.messageTextArea.requestFocusInWindow();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        Container contentPane = this.getContentPane();
        BorderLayout contentLayout = new BorderLayout();
        contentLayout.setHgap(5);
        contentLayout.setVgap(5);
        contentPane.setLayout(contentLayout);
        contentPane.add((Component)logoPanel, "North");
        contentPane.add((Component)this.messageScrollPane, "Center");
        contentPane.add((Component)buttonPanel, "South");
    }

    private void createTextAreaComponents() {
        Border defaultBorder = UIManager.getBorder("TextField.border");
        this.focusBorder = BorderFactory.createCompoundBorder(UIManager.getBorder("List.focusCellHighlightBorder"), defaultBorder);
        this.noFocusBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getColor("control"), 1), defaultBorder);
        this.messageTextArea = new JTextArea(this.message);
        this.messageTextArea.setEditable(false);
        this.messageTextArea.setFocusable(true);
        this.messageTextArea.setCaretPosition(0);
        this.messageTextArea.setMargin(new Insets(5, 5, 5, 5));
        this.messageTextArea.setToolTipText(MESSAGE_AREA_TOOLTIP);
        this.messageTextArea.getAccessibleContext().setAccessibleName(MESSAGE_AREA_TOOLTIP);
        this.messageTextArea.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                DialogConfirm.this.messageScrollPane.setBorder(DialogConfirm.this.focusBorder);
            }

            public void focusLost(FocusEvent e) {
                DialogConfirm.this.messageScrollPane.setBorder(DialogConfirm.this.noFocusBorder);
            }
        });
        if (this.messageTextArea.getLineCount() < 3) {
            this.messageTextArea.append("\n\n");
        }
        this.messageScrollPane = new JScrollPane(this.messageTextArea);
        this.messageScrollPane.setBorder(this.noFocusBorder);
    }

    private JPanel createLogoPanel() {
        if (this.messageMode == 0) {
            this.logoLabel = new JLabel(new ImageIcon(this.getClass().getResource(ERROR_LOGO)));
            this.logoLabel.setToolTipText(ERROR_LOGO_TOOLTIP);
            this.messageTypeLabel = new JLabel(ERROR_LABEL);
            this.messageTypeLabel.setDisplayedMnemonic('E');
        } else if (this.messageMode == 1) {
            this.logoLabel = new JLabel(new ImageIcon(this.getClass().getResource(SUCCESS_LOGO)));
            this.logoLabel.setToolTipText(SUCCESS_LOGO_TOOLTIP);
            this.messageTypeLabel = new JLabel(SUCCESS_LABEL);
            this.messageTypeLabel.setDisplayedMnemonic('I');
        } else if (this.messageMode == 2) {
            this.logoLabel = new JLabel(new ImageIcon(this.getClass().getResource(HELP_LOGO)));
            this.logoLabel.setToolTipText(HELP_LOGO_TOOLTIP);
            this.messageTypeLabel = new JLabel(HELP_LABEL);
            this.messageTypeLabel.setDisplayedMnemonic('H');
        }
        this.logoLabel.setFocusable(false);
        this.messageTypeLabel.setFont(this.messageTypeLabel.getFont().deriveFont(1));
        JPanel logoPanel = new JPanel();
        FlowLayout logoLayout = new FlowLayout();
        logoLayout.setAlignment(0);
        logoPanel.setLayout(logoLayout);
        logoPanel.add(this.logoLabel);
        logoPanel.add(this.messageTypeLabel);
        return logoPanel;
    }

    private JPanel createButtonPanel() {
        JPanel p = new JPanel();
        FlowLayout myFlowLayout = new FlowLayout();
        myFlowLayout.setAlignment(1);
        myFlowLayout.setHgap(5);
        myFlowLayout.setVgap(5);
        p.setLayout(myFlowLayout);
        this.createOKButton();
        p.add(this.okButton);
        if (this.messageMode == 0) {
            this.createCancelButton();
            p.add(Box.createRigidArea(new Dimension(10, 0)));
            p.add(this.cancelButton);
        }
        return p;
    }

    private void createOKButton() {
        this.okButton = new JButton(OK_BUTTON_LABEL);
        this.okButton.setMnemonic('O');
        this.okButton.setToolTipText(OK_BUTTON_TOOLTIP);
        this.okButton.setFont(this.okButton.getFont().deriveFont(1));
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.setAlignmentX(1.0f);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogConfirm.this.okActionPerformed();
            }
        });
    }

    private void createCancelButton() {
        this.cancelButton = new JButton(CANCEL_BUTTON_LABEL);
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setToolTipText(CANCEL_BUTTON_TOOLTIP);
        this.cancelButton.setFont(this.cancelButton.getFont().deriveFont(1));
        this.cancelButton.setAlignmentX(1.0f);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogConfirm.this.cancelActionPerformed();
            }
        });
    }

    private void okActionPerformed() {
        this.returnVal = 10;
        this.setVisible(false);
        this.dispose();
    }

    private void cancelActionPerformed() {
        this.returnVal = 11;
        this.setVisible(false);
        this.dispose();
    }

    private void doTimeout() {
        this.returnVal = 12;
        this.setVisible(false);
        this.dispose();
    }

    public class DialogConfirmFocusTraversalPolicy
    extends FocusTraversalPolicy {
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(DialogConfirm.this.messageTextArea)) {
                return DialogConfirm.this.okButton;
            }
            if (aComponent.equals(DialogConfirm.this.okButton)) {
                if (DialogConfirm.this.cancelButton != null) {
                    return DialogConfirm.this.cancelButton;
                }
                return DialogConfirm.this.messageTextArea;
            }
            if (aComponent.equals(DialogConfirm.this.cancelButton)) {
                return DialogConfirm.this.messageTextArea;
            }
            return DialogConfirm.this.okButton;
        }

        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(DialogConfirm.this.cancelButton)) {
                return DialogConfirm.this.okButton;
            }
            if (aComponent.equals(DialogConfirm.this.okButton)) {
                return DialogConfirm.this.messageTextArea;
            }
            if (aComponent.equals(DialogConfirm.this.messageTextArea)) {
                if (DialogConfirm.this.cancelButton != null) {
                    return DialogConfirm.this.cancelButton;
                }
                return DialogConfirm.this.okButton;
            }
            return DialogConfirm.this.okButton;
        }

        public Component getDefaultComponent(Container focusCycleRoot) {
            return DialogConfirm.this.okButton;
        }

        public Component getLastComponent(Container focusCycleRoot) {
            return DialogConfirm.this.cancelButton;
        }

        public Component getFirstComponent(Container focusCycleRoot) {
            return DialogConfirm.this.okButton;
        }
    }
}

