/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.jmx;

import gov.va.med.vistalink.jmx.IJmxHelper;
import gov.va.med.vistalink.jmx.JmxHelperException;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public final class JmxHelperWebLogic
implements IJmxHelper {
    private static final Logger logger = Logger.getLogger(JmxHelperWebLogic.class);
    private static final String JMX_DOMAIN_FOR_PLATFORM = "com.bea";
    private static final String MBEANSERVER_JNDI_ENV_CONTEXT = "java:comp/env/jmx/runtime";
    private static final String MBEANSERVER_JNDI_CONTEXT = "java:comp/jmx/runtime";
    private static final String OBJECT_NAME_STRING_TYPE = "Type";
    private MBeanServer localRuntimeMBeanServer = null;

    protected JmxHelperWebLogic() {
    }

    public String getServerObjectNamePropertiesForRegistration() {
        return "";
    }

    public MBeanServer getLocalMBeanServer() throws JmxHelperException {
        MBeanServer returnVal;
        block17: {
            logger.debug((Object)"in getLocalMBeanServer");
            returnVal = null;
            InitialContext ctx = null;
            try {
                ctx = new InitialContext();
                returnVal = this.getLocalRuntimeMBeanServer();
                if (returnVal != null) break block17;
                try {
                    returnVal = (MBeanServer)ctx.lookup(MBEANSERVER_JNDI_ENV_CONTEXT);
                }
                catch (NameNotFoundException e) {
                    try {
                        returnVal = (MBeanServer)ctx.lookup(MBEANSERVER_JNDI_CONTEXT);
                    }
                    catch (NameNotFoundException e1) {
                        logger.error((Object)"Could not retrieve local MBeanServer: ", (Throwable)e1);
                        throw new JmxHelperException("Could not retrieve local MBeanServer from JNDI");
                    }
                }
                if (returnVal != null) {
                    this.setLocalRuntimeMBeanServer(returnVal);
                }
            }
            catch (NamingException e) {
                logger.error((Object)"Could not get initial context: ", (Throwable)e);
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (NamingException e1) {
                        logger.error((Object)"Could not close InitialContext: ", (Throwable)e1);
                    }
                }
                throw new JmxHelperException("Could not get initial context: ", e);
            }
            finally {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    logger.error((Object)"error closing JNDI context", (Throwable)e);
                }
            }
        }
        return returnVal;
    }

    public String getComputingDomainName() throws JmxHelperException {
        String domainName = null;
        try {
            MBeanServer localMBeanServer = this.getLocalMBeanServer();
            ObjectName oNamePartial = new ObjectName(this.getJmxDomainForPlatform() + ":" + OBJECT_NAME_STRING_TYPE + "=Domain,*");
            Set<ObjectName> queryResults = localMBeanServer.queryNames(oNamePartial, null);
            if (queryResults.size() != 1) {
                logger.error((Object)("Expected 1 result for local server query, got: " + queryResults.size()));
                throw new JmxHelperException("Could not get domain name, domain query returned result size other than 1:" + queryResults.size());
            }
            ObjectName serverObjectName = queryResults.iterator().next();
            domainName = serverObjectName.getKeyProperty("Name");
        }
        catch (MalformedObjectNameException e) {
            throw new JmxHelperException("Could not get domain name: ", e);
        }
        catch (NullPointerException e) {
            throw new JmxHelperException("Could not get domain name: ", e);
        }
        return domainName;
    }

    public String getJmxDomainForPlatform() {
        return JMX_DOMAIN_FOR_PLATFORM;
    }

    public String getJmxDomainForHev() {
        return "gov.va.med";
    }

    private synchronized MBeanServer getLocalRuntimeMBeanServer() {
        return this.localRuntimeMBeanServer;
    }

    private synchronized void setLocalRuntimeMBeanServer(MBeanServer localRuntimeMBeanServer) {
        this.localRuntimeMBeanServer = localRuntimeMBeanServer;
    }
}

