/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.exception;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

public class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static String getFullStackTrace(Throwable e) {
        ByteArrayOutputStream byteOutStr = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(byteOutStr);
        e.printStackTrace(writer);
        writer.flush();
        writer.close();
        return new String(byteOutStr.toByteArray());
    }

    public static Throwable getNestedExceptionByClass(Throwable e, Class exceptionClass) {
        if (exceptionClass.isInstance(e)) {
            return e;
        }
        Throwable nestedException = e.getCause();
        if (nestedException != null) {
            return ExceptionUtils.getNestedExceptionByClass(nestedException, exceptionClass);
        }
        return null;
    }
}

