/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.pharmacy.persistence.dao.impl;

import gov.va.med.pharmacy.persistence.BaseDao;
import gov.va.med.pharmacy.persistence.dao.UserDao;
import gov.va.med.pharmacy.persistence.model.VaUser;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="userDao")
public class UserDaoImpl
extends BaseDao<Integer, VaUser>
implements UserDao {
    @Override
    public VaUser findById(long id) {
        VaUser user = (VaUser)this.getByKey(id);
        return user;
    }

    @Override
    public VaUser findByVAUserID(String networkID) {
        Criteria crit = this.createEntityCriteria();
        crit.add((Criterion)Restrictions.eq((String)"vaUserid", (Object)networkID));
        VaUser users = (VaUser)crit.uniqueResult();
        return users;
    }

    @Override
    public void save(VaUser user) {
        this.persist(user);
    }

    @Override
    public void deleteByVAUserID(String networkID) {
        Criteria crit = this.createEntityCriteria();
        crit.add((Criterion)Restrictions.eq((String)"vaUserid", (Object)networkID));
        VaUser user = (VaUser)crit.uniqueResult();
        this.delete(user);
    }

    @Override
    public List<VaUser> findAll() {
        Criteria criteria = this.createEntityCriteria().addOrder(Order.asc((String)"vaUserid"));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        List users = criteria.list();
        return users;
    }

    @Override
    public void updateVaUser(VaUser user) {
        this.update(user);
    }

    @Override
    public void deleteVaUser(VaUser user) {
        this.delete(user);
    }
}

