/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.management;

import gov.va.med.environment.Environment;
import gov.va.med.environment.ServerType;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionFactory;
import gov.va.med.vistalink.adapter.spi.VistaLinkSystemInfoVO;
import gov.va.med.vistalink.institution.InstitutionMapping;
import gov.va.med.vistalink.institution.InstitutionMappingFactory;
import gov.va.med.vistalink.institution.InstitutionMappingVO;
import gov.va.med.vistalink.management.VistaLinkConnectorMBean;
import java.lang.ref.WeakReference;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class VistaLinkConnector
implements VistaLinkConnectorMBean {
    private static final Logger logger = Logger.getLogger(VistaLinkConnector.class);
    private static final String WEBLOGIC_STATE_ATTR = "State";
    private static final String WEBLOGIC_EISTYPE_ATTR = "ConnectorEisType";
    private static final String WEBLOGIC_PARENT_ATTR = "Parent";
    private static final String WEBLOGIC_APPNAME_ATTR = "AppDeploymentMBean";
    private static final String WEBLOGIC_APPNAME_PROP = "Name";
    private WeakReference cfWr;
    private String jndiNameActual;
    private MBeanServer localMBeanServer;
    private ObjectName containerMBeanName;

    public VistaLinkConnector(String jndiName, ObjectName containerMBeanName, MBeanServer localMBeanServer) {
        this.jndiNameActual = jndiName;
        this.containerMBeanName = containerMBeanName;
        this.localMBeanServer = localMBeanServer;
        VistaLinkConnectionFactory cf = this.getCfWr();
        logger.debug((Object)("Tried to get CF reference in constructor, got: " + (cf == null ? "null" : cf.toString())));
    }

    public static String getMBeanType() {
        return "VistaLinkConnector";
    }

    public synchronized ObjectName getContainerMBeanName() {
        return this.containerMBeanName;
    }

    public String getCfgIpAddress() {
        VistaLinkConnectionFactory cf = this.getCfWr();
        if (cf != null) {
            return cf.getCfgIpAddress();
        }
        return null;
    }

    public int getCfgPort() {
        VistaLinkConnectionFactory cf = this.getCfWr();
        if (cf != null) {
            return cf.getCfgPort();
        }
        return -1;
    }

    public long getCfgTimeout() {
        VistaLinkConnectionFactory cf = this.getCfWr();
        if (cf != null) {
            return cf.getCfgTimeout();
        }
        return -1L;
    }

    public boolean isCfgTimeoutAlwaysUseDefaultAsMin() {
        VistaLinkConnectionFactory cf = this.getCfWr();
        if (cf != null) {
            return cf.isCfgTimeoutAlwaysUseDefaultAsMin();
        }
        return false;
    }

    public long getDistinguishedIdentifier() {
        VistaLinkConnectionFactory cf = this.getCfWr();
        if (cf != null) {
            return cf.getDistinguishedIdentifier();
        }
        return -1L;
    }

    public long getHlthConnectionAuthFailureCount() {
        VistaLinkConnectionFactory cf = this.getCfWr();
        if (cf != null) {
            return cf.getHlthConnectionAuthFailureCount();
        }
        return 0L;
    }

    public long getHlthConnectionFailureCount() {
        VistaLinkConnectionFactory cf = this.getCfWr();
        if (cf != null) {
            return cf.getHlthConnectionFailureCount();
        }
        return 0L;
    }

    public long getHlthDivisionMismatchCount() {
        VistaLinkConnectionFactory cf = this.getCfWr();
        if (cf != null) {
            return cf.getHlthDivisionMismatchCount();
        }
        return 0L;
    }

    public long getHlthIdentityFailureCount() {
        VistaLinkConnectionFactory cf = this.getCfWr();
        if (cf != null) {
            return cf.getHlthIdentityFailureCount();
        }
        return 0L;
    }

    public long getHlthProductionMismatchCount() {
        VistaLinkConnectionFactory cf = this.getCfWr();
        if (cf != null) {
            return cf.getHlthProductionMismatchCount();
        }
        return 0L;
    }

    public double getPerfCreateConnectionHandleAvgMillis() {
        VistaLinkConnectionFactory cf = this.getCfWr();
        if (cf != null) {
            return cf.getPerfCreateConnectionHandleAvgMillis();
        }
        return 0.0;
    }

    public double getPerfMatchManagedConnectionAvgMillis() {
        VistaLinkConnectionFactory cf = this.getCfWr();
        if (cf != null) {
            return cf.getPerfMatchManagedConnectionAvgMillis();
        }
        return 0.0;
    }

    public Map getQueryMSystemMap() {
        VistaLinkConnectionFactory cf = this.getCfWr();
        if (cf != null) {
            return cf.queryMSystem().toMap();
        }
        return null;
    }

    public String[] getQueryMSystemReport() {
        VistaLinkConnectionFactory cf = this.getCfWr();
        if (cf != null) {
            VistaLinkSystemInfoVO vo = cf.queryMSystem();
            StringBuffer sb = new StringBuffer();
            String errorMessage = vo.getErrorMessage();
            if (errorMessage != null && errorMessage.length() > 0) {
                sb.append("Remote M Error Message: " + vo.getErrorMessage());
                sb.append('\n');
            } else {
                sb.append("Remote VL Version: ").append(vo.getVistalinkVersion()).append('\n');
                sb.append("Remote VL Build: ").append(vo.getVistalinkBuild()).append('\n');
                sb.append("Remote VL Listener Timeout: ").append(vo.getAppServerTimeout()).append('\n');
                sb.append("Remote VL Reauthenticated Session Timeout: ").append(vo.getReAuthSessionTimeout()).append('\n');
                sb.append("Remote VL Connector Proxy Username: ").append(vo.getCpName()).append('\n');
                sb.append("Remote UCI: ").append(vo.getUci()).append('\n');
                sb.append("Remote VOL: ").append(vo.getVol()).append('\n');
                sb.append("Remote BOX-VOLUME: ").append(vo.getBoxVolume()).append('\n');
                sb.append("Remote M Version: ").append(vo.getMumpsVersion()).append('\n');
                sb.append("Remote Operating System: ").append(vo.getOperatingSystem()).append('\n');
                sb.append("Remote Domain: ").append(vo.getDomainName()).append('\n');
                sb.append("Remote is Production?: ").append(vo.getVistaProduction()).append('\n');
                sb.append("Remote Kernel Default Institution: ").append(vo.getDefaultInstitution()).append('\n');
                sb.append("Introductory Text: ").append('\n');
                String[] introText = vo.getIntroText().split("<BR>");
                for (int i = 0; i < introText.length; ++i) {
                    sb.append(introText[i]).append('\n');
                }
            }
            return sb.toString().split("\n");
        }
        return null;
    }

    public String[] getQueryMappedInstitutions() {
        String[] stationNumbers = null;
        InstitutionMapping me = InstitutionMappingFactory.getInstitutionMapping();
        Map institutionMap = me.getMappingClone();
        TreeSet<String> matchingStations = new TreeSet<String>();
        Set keys = institutionMap.keySet();
        for (String stationNumber : keys) {
            InstitutionMappingVO imVO = (InstitutionMappingVO)institutionMap.get(stationNumber);
            String mappingJndiName = imVO.getJndiName();
            if (!mappingJndiName.equals(this.getJndiNameActual())) continue;
            matchingStations.add(stationNumber);
        }
        if (matchingStations.size() > 0) {
            stationNumbers = new String[matchingStations.size()];
            int i = 0;
            Iterator iter = matchingStations.iterator();
            while (iter.hasNext()) {
                stationNumbers[i] = (String)iter.next();
                ++i;
            }
        }
        return stationNumbers;
    }

    public String getEisType() throws RemoteException {
        try {
            return (String)this.getLocalMBeanServer().getAttribute(this.getContainerMBeanName(), WEBLOGIC_EISTYPE_ATTR);
        }
        catch (Exception e) {
            logger.error((Object)"Failure retrieving EisType: ", (Throwable)e);
            throw new RemoteException(e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public final synchronized String getJndiNameActual() {
        return this.jndiNameActual;
    }

    public String getJndiNameCustomProp() {
        VistaLinkConnectionFactory cf = this.getCfWr();
        if (cf != null) {
            return cf.getConnectorJndiName();
        }
        return null;
    }

    public String getDeploymentState() throws RemoteException {
        try {
            return (String)this.getLocalMBeanServer().getAttribute(this.getContainerMBeanName(), WEBLOGIC_STATE_ATTR);
        }
        catch (Exception e) {
            logger.error((Object)"Failure retrieving deployment state: ", (Throwable)e);
            throw new RemoteException(e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public Map getVendorSpecificProperties() throws RemoteException {
        HashMap<String, String> returnVal = new HashMap<String, String>();
        if (ServerType.WEBLOGIC.equals(Environment.getServerType())) {
            try {
                ObjectName connectorComponentRuntimeOName = (ObjectName)this.getLocalMBeanServer().getAttribute(this.getContainerMBeanName(), WEBLOGIC_PARENT_ATTR);
                ObjectName appDeploymentMBeanOName = (ObjectName)this.getLocalMBeanServer().getAttribute(connectorComponentRuntimeOName, WEBLOGIC_APPNAME_ATTR);
                returnVal.put("WebLogic Application Name", appDeploymentMBeanOName.getKeyProperty(WEBLOGIC_APPNAME_PROP));
            }
            catch (Exception e) {
                logger.error((Object)"Failure retrieving WebLogic application name: ", (Throwable)e);
                throw new RemoteException(e.getClass().getName() + ": " + e.getMessage());
            }
        }
        return returnVal;
    }

    private synchronized VistaLinkConnectionFactory getCfWr() {
        VistaLinkConnectionFactory returnVal = null;
        if (this.cfWr != null) {
            returnVal = (VistaLinkConnectionFactory)this.cfWr.get();
        }
        if (returnVal == null) {
            returnVal = this.getCF(this.getJndiNameActual());
            logger.debug((Object)("Tried to get CF reference for MBean, got: " + (returnVal == null ? "null" : returnVal.toString())));
            if (returnVal != null) {
                this.cfWr = new WeakReference<VistaLinkConnectionFactory>(returnVal);
            }
        }
        return returnVal;
    }

    private VistaLinkConnectionFactory getCF(String cfJndiName) {
        VistaLinkConnectionFactory cf = null;
        try {
            InitialContext ctx = new InitialContext();
            cf = (VistaLinkConnectionFactory)ctx.lookup(cfJndiName);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return cf;
    }

    private synchronized MBeanServer getLocalMBeanServer() {
        return this.localMBeanServer;
    }
}

