/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.cache;

import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionFactory;
import gov.va.med.vistalink.cache.VistaLinkCacheException;
import gov.va.med.vistalink.cache.VistaLinkConnectionFactoryNotFoundException;
import gov.va.med.vistalink.cache.WeakValueMap;
import gov.va.med.vistalink.institution.InstitutionMapNotInitializedException;
import gov.va.med.vistalink.institution.InstitutionMappingDelegate;
import gov.va.med.vistalink.institution.InstitutionMappingNotFoundException;
import java.util.Collections;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class VistaLinkConnectionFactoryLocator {
    private static VistaLinkConnectionFactoryLocator me = null;
    Context context;
    Map map = Collections.synchronizedMap(new WeakValueMap());
    private static final Logger logger = Logger.getLogger(VistaLinkConnectionFactoryLocator.class);

    private VistaLinkConnectionFactoryLocator() throws VistaLinkCacheException {
        try {
            this.setContext(new InitialContext());
        }
        catch (Exception e) {
            logger.error((Object)("Unable to create InitialContext: " + e.getMessage()));
        }
    }

    public static synchronized VistaLinkConnectionFactoryLocator getInstance() throws VistaLinkCacheException {
        if (me == null) {
            me = new VistaLinkConnectionFactoryLocator();
        }
        return me;
    }

    public VistaLinkConnectionFactory getFactory(String jndiName) throws VistaLinkConnectionFactoryNotFoundException, VistaLinkCacheException {
        VistaLinkConnectionFactory result = (VistaLinkConnectionFactory)this.map.get(jndiName);
        if (result == null) {
            try {
                if (this.context == null) {
                    throw new VistaLinkCacheException("Context is uninitialized, look in the logger [ERROR] output file for reasons.");
                }
                result = (VistaLinkConnectionFactory)this.context.lookup(jndiName);
                if (result == null) {
                    throw new VistaLinkConnectionFactoryNotFoundException("Unable to find ConnectionFactory, based on the jndiName provided - " + jndiName);
                }
                this.map.put(jndiName, result);
            }
            catch (NamingException e) {
                throw new VistaLinkCacheException("Could not complete the lookup: " + e.getMessage());
            }
        }
        return result;
    }

    public VistaLinkConnectionFactory getFactoryByDivision(String division) throws VistaLinkConnectionFactoryNotFoundException, VistaLinkCacheException, InstitutionMapNotInitializedException, InstitutionMappingNotFoundException {
        String jndiName = InstitutionMappingDelegate.getJndiConnectorNameForInstitution(division);
        VistaLinkConnectionFactory result = this.getFactory(jndiName);
        return result;
    }

    public void setContext(Context ctx) {
        this.context = ctx;
    }
}

