/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.adapter.spi;

import gov.va.med.vistalink.adapter.record.VistaLinkRequestRetryStrategy;
import gov.va.med.vistalink.adapter.record.VistaLinkRequestVO;
import gov.va.med.vistalink.adapter.spi.VistaLinkManagedConnection;
import org.apache.log4j.Logger;

public class VistaLinkRequestRetryStrategyAllowOverride
implements VistaLinkRequestRetryStrategy {
    private static final Logger logger = Logger.getLogger(VistaLinkRequestRetryStrategyAllowOverride.class);
    private VistaLinkManagedConnection mc = null;

    protected VistaLinkRequestRetryStrategyAllowOverride(VistaLinkManagedConnection mc) {
        this.mc = mc;
    }

    public boolean execute(VistaLinkRequestVO request) {
        return this.automaticRequestRetry();
    }

    private boolean automaticRequestRetry() {
        long currentTime = System.currentTimeMillis();
        long lastExecuteTime = this.mc.getLastInteractionTimeMillis();
        long mTimeout = this.mc.getHeartBeatRate();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)new StringBuffer().append("\n\tRetry Current Time: \t").append(currentTime).append("\n\tLast Execution Time: \t").append(lastExecuteTime).append("\n\tDifference: \t").append(currentTime - lastExecuteTime).append("\n\tThreshold: \t").append(mTimeout).toString());
        }
        return currentTime - lastExecuteTime > mTimeout;
    }
}

