/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.adapter.spi;

import gov.va.med.vistalink.adapter.cci.VistaLinkResourceException;
import gov.va.med.vistalink.adapter.config.Connector;
import gov.va.med.vistalink.adapter.spi.ConnectorConfigurator;
import gov.va.med.vistalink.adapter.spi.VistaLinkManagedConnectionFactory;
import gov.va.med.vistalink.institution.InstitutionMapping;
import gov.va.med.vistalink.institution.InstitutionMappingBadStationNumberException;
import gov.va.med.vistalink.institution.InstitutionMappingFactory;
import org.apache.log4j.Logger;

public class ConfigurationReader {
    private static final Logger logger = Logger.getLogger(ConfigurationReader.class);

    private ConfigurationReader() {
    }

    public static String getJndiNameForStationNumber(String stationNumber) throws Exception {
        return ConfigurationReader.getJndiNameForStationNumber(stationNumber, new ConnectorConfigurator());
    }

    public static String getJndiNameForStationNumber(String stationNumber, ConnectorConfigurator cc) throws Exception {
        String matchingJndiName = null;
        if (stationNumber == null || stationNumber.trim().length() < 1) {
            throw new IllegalArgumentException("Station Number argument '" + stationNumber + "' is invalid.'");
        }
        try {
            Connector[] connectors = cc.getConnectorArray();
            int matchCount = 0;
            for (int i = 0; i < connectors.length; ++i) {
                String connectorJndiName;
                String primaryStation;
                if (!connectors[i].getEnabled() || !stationNumber.equals(primaryStation = connectors[i].getPrimaryStation()) || primaryStation.length() < 1 || (connectorJndiName = connectors[i].getJndiName()) == null || connectorJndiName.length() < 1) continue;
                if (++matchCount > 1) {
                    throw new Exception("Multiple enabled connector matches found for station# '" + stationNumber + "'; cannot resolve.");
                }
                matchingJndiName = connectorJndiName;
            }
        }
        catch (Exception e) {
            String error = "Problem parsing config file: ";
            logger.error((Object)error, (Throwable)e);
            throw new Exception(error, e);
        }
        return matchingJndiName;
    }

    public static void loadConfigForMcf(VistaLinkManagedConnectionFactory mcf, ConnectorConfigurator cc) throws VistaLinkResourceException {
        String connectorJndiName = mcf.getConnectorJndiName();
        if (connectorJndiName == null) {
            String error = "Connector descriptor is not configured with connectorJndiName to be retrieved from configuration file.";
            throw new VistaLinkResourceException(error);
        }
        boolean saveFile = false;
        logger.debug((Object)("Looking for connectorJndiName index: " + connectorJndiName));
        int matchEnabledCount = 0;
        String matchFailureMessage = null;
        try {
            Connector[] connectors = cc.getConnectorArray();
            for (int i = 0; i < connectors.length; ++i) {
                block12: {
                    if (!connectorJndiName.equals(connectors[i].getJndiName())) continue;
                    if (!connectors[i].getEnabled()) {
                        logger.debug((Object)("Skipping disabled connector '" + connectorJndiName + "'."));
                        continue;
                    }
                    logger.debug((Object)"found enabled jndiName match.");
                    mcf.setHostIpAddress(connectors[i].getIp());
                    mcf.setHostPort(connectors[i].getPort());
                    mcf.setDefaultJ2EETimeOut(connectors[i].getTimeout() * 1000);
                    mcf.setAlwaysUseDefaultAsMin(connectors[i].getAlwaysUseDefaultAsMin());
                    String primaryStation = connectors[i].getPrimaryStation();
                    if (primaryStation.length() > 0) {
                        mcf.setPrimaryStation(primaryStation);
                        InstitutionMapping instMap = InstitutionMappingFactory.getInstitutionMapping();
                        String[] stationNumbersToMap = new String[]{primaryStation};
                        try {
                            instMap.loadMappingsForJndiName(connectorJndiName, stationNumbersToMap, mcf.getDistinguishedIdentifier());
                            break block12;
                        }
                        catch (InstitutionMappingBadStationNumberException e1) {
                            matchFailureMessage = (matchFailureMessage == null ? "" : "; ") + "skipping configuration '" + connectorJndiName + "', could not load institution mapping due to bad station number(s): '" + e1.getMessage() + "'";
                            logger.error((Object)matchFailureMessage, (Throwable)e1);
                            continue;
                        }
                    }
                    matchFailureMessage = matchFailureMessage == null ? "" : "; Skipping configuration for '" + connectorJndiName + "' because required primary Station attribute not found.";
                    logger.error((Object)matchFailureMessage);
                    continue;
                }
                if (connectors[i].getEncrypted()) {
                    boolean isGlobalScoped = cc.isEncryptionScoped();
                    mcf.setAccessCode(cc.getDecryptedValue(connectors[i].getAccessCode(), isGlobalScoped));
                    mcf.setVerifyCode(cc.getDecryptedValue(connectors[i].getVerifyCode(), isGlobalScoped));
                } else {
                    mcf.setAccessCode(connectors[i].getAccessCode());
                    mcf.setVerifyCode(connectors[i].getVerifyCode());
                    logger.warn((Object)("encrypting unencrypted entry in the config file! - " + connectorJndiName));
                    saveFile = cc.updateEncryptionIfNeeded(connectors[i]) || saveFile;
                }
                mcf.setConnectorEnabled(true);
                ++matchEnabledCount;
                break;
            }
            if (saveFile) {
                cc.save();
                logger.info((Object)"ConfigurationFile saved.");
            }
        }
        catch (Exception e) {
            String error = "Problem loading connector configuration for jndiName '" + connectorJndiName + "': ";
            throw new VistaLinkResourceException(error, e);
        }
        if (matchEnabledCount == 0 || !mcf.isConnectorEnabled()) {
            throw new VistaLinkResourceException("Could not find matching, enabled, valid configuration for connectorJndiName '" + connectorJndiName + "'" + (matchFailureMessage == null ? "." : matchFailureMessage));
        }
    }
}

