/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.pharmacy.persistence.model;

import gov.va.med.pharmacy.persistence.model.Pharmacy;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="VISTA_LOOKUP", schema="ERX")
public class VistaLookup
implements Serializable {
    private static final long serialVersionUID = 5009066842612838065L;
    private long vistaLookupId;
    private String vaStationId;
    private String fqdn;
    private long tcpPort;
    private String service;
    private Date updatedDate;
    private Date createdDate;
    private Set<Pharmacy> pharmacies = new HashSet<Pharmacy>(0);

    public VistaLookup() {
    }

    public VistaLookup(long vistaLookupId) {
        this.vistaLookupId = vistaLookupId;
    }

    public VistaLookup(long vistaLookupId, String vaStationId, String fqdn, long tcpPort, String service, Date updatedDate, Date createdDate, Set<Pharmacy> pharmacies) {
        this.vistaLookupId = vistaLookupId;
        this.vaStationId = vaStationId;
        this.fqdn = fqdn;
        this.tcpPort = tcpPort;
        this.service = service;
        this.updatedDate = updatedDate;
        this.createdDate = createdDate;
        this.pharmacies = pharmacies;
    }

    @Id
    @Column(name="VISTA_LOOKUP_ID", unique=true, nullable=false, precision=22, scale=0)
    public long getVistaLookupId() {
        return this.vistaLookupId;
    }

    public void setVistaLookupId(long vistaLookupId) {
        this.vistaLookupId = vistaLookupId;
    }

    @Column(name="VA_STATION_ID", length=5)
    public String getVaStationId() {
        return this.vaStationId;
    }

    public void setVaStationId(String vaStationId) {
        this.vaStationId = vaStationId;
    }

    @Column(name="FQDN", length=35)
    public String getFqdn() {
        return this.fqdn;
    }

    public void setFqdn(String fqdn) {
        this.fqdn = fqdn;
    }

    @Column(name="TCP_PORT", precision=22, scale=0)
    public long getTcpPort() {
        return this.tcpPort;
    }

    public void setTcpPort(long tcpPort) {
        this.tcpPort = tcpPort;
    }

    @Column(name="SERVICE", length=15)
    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="UPDATED_DATE", length=7)
    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="CREATED_DATE", length=7)
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="vistaLookup")
    public Set<Pharmacy> getPharmacies() {
        return this.pharmacies;
    }

    public void setPharmacies(Set<Pharmacy> pharmacies) {
        this.pharmacies = pharmacies;
    }
}

