/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.pharmacy.persistence.model;

import gov.va.med.pharmacy.persistence.model.Pharmacy;
import gov.va.med.pharmacy.persistence.model.UserRoles;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="USERS", schema="ERX")
public class Users
implements Serializable {
    private static final long serialVersionUID = 7008770123720171913L;
    private long usersId;
    private String vaUserid;
    private long enabled;
    private Date updatedDate;
    private Date createdDate;
    private Set<Pharmacy> pharmaciesForCreatedBy = new HashSet<Pharmacy>(0);
    private Set<Pharmacy> pharmaciesForUpdatedBy = new HashSet<Pharmacy>(0);
    private Set<UserRoles> userRoleses = new HashSet<UserRoles>(0);

    public Users() {
    }

    public Users(long usersId, String vaUserid, long enabled) {
        this.usersId = usersId;
        this.vaUserid = vaUserid;
        this.enabled = enabled;
    }

    public Users(long usersId, String vaUserid, long enabled, Date updatedDate, Date createdDate, Set<Pharmacy> pharmaciesForCreatedBy, Set<Pharmacy> pharmaciesForUpdatedBy, Set<UserRoles> userRoleses) {
        this.usersId = usersId;
        this.vaUserid = vaUserid;
        this.enabled = enabled;
        this.updatedDate = updatedDate;
        this.createdDate = createdDate;
        this.pharmaciesForCreatedBy = pharmaciesForCreatedBy;
        this.pharmaciesForUpdatedBy = pharmaciesForUpdatedBy;
        this.userRoleses = userRoleses;
    }

    @Id
    @Column(name="USERS_ID", unique=true, nullable=false, precision=22, scale=0)
    public long getUsersId() {
        return this.usersId;
    }

    public void setUsersId(long usersId) {
        this.usersId = usersId;
    }

    @Column(name="VA_USERID", nullable=false, length=20)
    public String getVaUserid() {
        return this.vaUserid;
    }

    public void setVaUserid(String vaUserid) {
        this.vaUserid = vaUserid;
    }

    @Column(name="ENABLED", nullable=false, precision=22, scale=0)
    public long getEnabled() {
        return this.enabled;
    }

    public void setEnabled(long enabled) {
        this.enabled = enabled;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="UPDATED_DATE", length=7)
    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="CREATED_DATE", length=7)
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="usersByCreatedBy")
    public Set<Pharmacy> getPharmaciesForCreatedBy() {
        return this.pharmaciesForCreatedBy;
    }

    public void setPharmaciesForCreatedBy(Set<Pharmacy> pharmaciesForCreatedBy) {
        this.pharmaciesForCreatedBy = pharmaciesForCreatedBy;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="usersByUpdatedBy")
    public Set<Pharmacy> getPharmaciesForUpdatedBy() {
        return this.pharmaciesForUpdatedBy;
    }

    public void setPharmaciesForUpdatedBy(Set<Pharmacy> pharmaciesForUpdatedBy) {
        this.pharmaciesForUpdatedBy = pharmaciesForUpdatedBy;
    }

    @OneToMany(fetch=FetchType.EAGER, mappedBy="users")
    public Set<UserRoles> getUserRoleses() {
        return this.userRoleses;
    }

    public void setUserRoleses(Set<UserRoles> userRoleses) {
        this.userRoleses = userRoleses;
    }
}

