/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.pharmacy.persistence.dao.impl;

import gov.va.med.pharmacy.persistence.BaseDao;
import gov.va.med.pharmacy.persistence.dao.UserDao;
import gov.va.med.pharmacy.persistence.model.Users;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="userDao")
public class UserDaoImpl
extends BaseDao<Integer, Users>
implements UserDao {
    @Override
    public Users findById(long id) {
        Users user = (Users)this.getByKey(id);
        if (user != null) {
            Hibernate.initialize(user.getUserRoleses());
        }
        return user;
    }

    @Override
    public Users findByVAUserID(String networkID) {
        Criteria crit = this.createEntityCriteria();
        crit.add((Criterion)Restrictions.eq((String)"vaUserid", (Object)networkID));
        Users users = (Users)crit.uniqueResult();
        if (users != null) {
            Hibernate.initialize(users.getUserRoleses());
        }
        return users;
    }

    @Override
    public void save(Users user) {
        this.persist(user);
    }

    @Override
    public void deleteByVAUserID(String networkID) {
        Criteria crit = this.createEntityCriteria();
        crit.add((Criterion)Restrictions.eq((String)"vaUserid", (Object)networkID));
        Users user = (Users)crit.uniqueResult();
        this.delete(user);
    }

    @Override
    public List<Users> findAllUsers() {
        Criteria criteria = this.createEntityCriteria().addOrder(Order.asc((String)"vaUserid"));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        List users = criteria.list();
        for (Users user : users) {
            Hibernate.initialize(user.getUserRoleses());
        }
        return users;
    }
}

