/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.pharmacy.utility;

import gov.va.med.pharmacy.utility.ESAPIValidationType;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.owasp.esapi.ESAPI;

public final class ESAPIValidator {
    private ESAPIValidator() {
    }

    public static String validateStringInput(String input, ESAPIValidationType type) {
        if (input == null) {
            return null;
        }
        if (input.length() < 1) {
            return "";
        }
        switch (type) {
            case ACCESS_CONTROL_DB: {
                try {
                    return ESAPI.validator().getValidInput("accessControlDb", input, "accessControlDb", Integer.MAX_VALUE, false, false);
                }
                catch (Exception e) {
                    throw new RuntimeException("Invalid characters found in input.  Access Control: DB violation.");
                }
            }
            case COMMAND_INJECTION: {
                try {
                    return ESAPI.validator().getValidInput("commandInjection", input, "commandInjection", Integer.MAX_VALUE, false, false);
                }
                catch (Exception e) {
                    throw new RuntimeException("Invalid characters found in input.  Command Injection violation.");
                }
            }
            case CROSS_SITE_SCRIPTING_PERSISTENT: {
                try {
                    return ESAPI.validator().getValidInput("crossSiteScriptingPersistent", input, "crossSiteScriptingPersistent", Integer.MAX_VALUE, false, false);
                }
                catch (Exception e) {
                    throw new RuntimeException("Invalid characters found in input.  Cross Site Scripting: Persistent violation.");
                }
            }
            case CROSS_SITE_SCRIPTING_REFLECTED: {
                try {
                    return ESAPI.validator().getValidInput("crossSiteScriptingReflected", input, "crossSiteScriptingReflected", Integer.MAX_VALUE, false, false);
                }
                catch (Exception e) {
                    throw new RuntimeException("Invalid characters found in input.  Cross Site Scripting:  Reflected violation.");
                }
            }
            case DENIAL_OF_SERVICE_REG_EXP: {
                try {
                    return ESAPI.validator().getValidInput("denialOfServiceRegExp", input, "denialOfServiceRegExp", Integer.MAX_VALUE, false, false);
                }
                catch (Exception e) {
                    throw new RuntimeException("Invalid characters found in input.  Denial Of Service: Regular Expression violation.");
                }
            }
            case JSON_INJECTION: {
                try {
                    return ESAPI.validator().getValidInput("jsonInjection", input, "jsonInjection", Integer.MAX_VALUE, false, false);
                }
                catch (Exception e) {
                    throw new RuntimeException("Invalid characters found in input.  JSON Injection violation.");
                }
            }
            case LOG_FORGING: {
                input = input.replace('\n', ' ').replace('\r', ' ');
                try {
                    return ESAPI.validator().getValidInput("logForging", input, "logForging", Integer.MAX_VALUE, false, false);
                }
                catch (Exception e) {
                    return null;
                }
            }
            case OPEN_REDIRECT: {
                try {
                    return ESAPI.validator().getValidInput("openRedirect", input, "openRedirect", Integer.MAX_VALUE, false, false);
                }
                catch (Exception e) {
                    throw new RuntimeException("Invalid characters found in input.  Open Redirect violation.");
                }
            }
            case PATH_MANIPULATION: {
                try {
                    return ESAPI.validator().getValidInput("pathManipulation", input, "pathManipulation", Integer.MAX_VALUE, false, false);
                }
                catch (Exception e) {
                    throw new RuntimeException("Invalid characters found in input. Path Manipulation violation.");
                }
            }
            case PORTABILITY_FLAW_FILE_SEPARATOR: {
                try {
                    input = input.replace('\\', File.separator.toCharArray()[0]).replace('/', File.separator.toCharArray()[0]);
                    return ESAPI.validator().getValidInput("portabilityFlawFileSeparator", input, "portabilityFlawFileSeparator", Integer.MAX_VALUE, false, false);
                }
                catch (Exception e) {
                    throw new RuntimeException("Invalid characters found in input. Portability Flaw File Separator violation.");
                }
            }
            case PORTABILITY_FLAW_LOCALE: {
                try {
                    return ESAPI.validator().getValidInput("portabilityFlawLocale", input, "portabilityFlawLocale", Integer.MAX_VALUE, false, false);
                }
                catch (Exception e) {
                    throw new RuntimeException("Invalid characters found in input. Portability Flaw Locale violation.");
                }
            }
            case PRIVACY_VIOLATION: {
                input = input.replace('\n', ' ').replace('\r', ' ');
                try {
                    return ESAPI.validator().getValidInput("privacyViolation", input, "privacyViolation", Integer.MAX_VALUE, false, false);
                }
                catch (Exception e) {
                    return null;
                }
            }
            case SQL_INJECTION: {
                input = input.replace('\n', ' ').replace('\r', ' ');
                try {
                    return ESAPI.validator().getValidInput("sqlInjection", input, "sqlInjection", Integer.MAX_VALUE, false, false);
                }
                catch (Exception e) {
                    return null;
                }
            }
            case SYSTEM_INFORMATION_LEAK_EXTERNAL: {
                try {
                    return ESAPI.validator().getValidInput("systemInformationLeakExternal", input, "systemInformationLeakExternal", Integer.MAX_VALUE, false, false);
                }
                catch (Exception e) {
                    return null;
                }
            }
            case XML_EXT_ENTITY_INJ: {
                try {
                    return ESAPI.validator().getValidInput("xmlExtEntityInj", input, "xmlExtEntityInj", Integer.MAX_VALUE, false, false);
                }
                catch (Exception e) {
                    throw new RuntimeException("Invalid characters found in input.  Open Redirect violation.");
                }
            }
            case IAM_LOGOUT_URL: {
                try {
                    return ESAPI.validator().getValidInput("IAMLogout", input, "IAMLogout", 300, false, false);
                }
                catch (Exception e) {
                    throw new RuntimeException("Invalid VA URL.  Open Redirect violation.");
                }
            }
            case ACCOUNT_NAME: {
                try {
                    return ESAPI.validator().getValidInput("AccountName", input, "AccountName", 20, false, false);
                }
                catch (Exception e) {
                    throw new RuntimeException("Invalid Account Name.");
                }
            }
        }
        return null;
    }

    public static long validateLongInput(String input) {
        try {
            return ESAPI.validator().getValidNumber("validateLong", input, 0L, Long.MAX_VALUE, false).longValue();
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid long value found in input.");
        }
    }

    public static double validateDoubleInput(String input) {
        try {
            return ESAPI.validator().getValidDouble("validateDouble", input, 0.0, Double.MAX_VALUE, false);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid double value found in input.");
        }
    }

    public static String validateFileNameInput(String input, List<String> allowedExtensions) {
        try {
            return ESAPI.validator().getValidFileName("validateFileNameInput", input, allowedExtensions, false);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid file name value found in input.");
        }
    }

    public static String validateFileNameInputWithPath(String input, List<String> allowedExtensions) {
        Path path = Paths.get(ESAPIValidator.validateStringInput(input, ESAPIValidationType.LOG_FORGING), new String[0]);
        String fileName = path.getFileName().toString();
        if (ESAPIValidator.validateFileNameInput(fileName, allowedExtensions).equals(fileName)) {
            return ESAPIValidator.validateStringInput(input, ESAPIValidationType.LOG_FORGING);
        }
        throw new RuntimeException("Invalid file name value found in input.");
    }

    public static boolean isValidInput(String input, ESAPIValidationType type) {
        try {
            ESAPIValidator.validateStringInput(input, type);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

