/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.security;

import gov.va.med.vistalink.security.CallbackChangeVc;
import gov.va.med.vistalink.security.CallbackCommit;
import gov.va.med.vistalink.security.CallbackConfirm;
import gov.va.med.vistalink.security.CallbackSelectDivision;
import gov.va.med.vistalink.security.VistaKernelPrincipalImpl;
import gov.va.med.vistalink.security.VistaLoginModuleException;
import gov.va.med.vistalink.security.VistaLoginModuleLoginsDisabledException;
import gov.va.med.vistalink.security.VistaLoginModuleNoJobSlotsAvailableException;
import gov.va.med.vistalink.security.VistaLoginModuleNoPathToListenerException;
import gov.va.med.vistalink.security.VistaLoginModuleSPI;
import gov.va.med.vistalink.security.VistaLoginModuleTooManyInvalidAttemptsException;
import gov.va.med.vistalink.security.VistaLoginModuleUserCancelledException;
import gov.va.med.vistalink.security.VistaLoginModuleUserTimedOutException;
import gov.va.med.vistalink.security.m.SecurityVOLogon;
import gov.va.med.vistalink.security.m.SecurityVOSelectDivision;
import gov.va.med.vistalink.security.m.SecurityVOSetupAndIntroText;
import gov.va.med.vistalink.security.m.SecurityVOUserDemographics;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.TreeMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.log4j.Logger;

public final class VistaLoginModule
implements LoginModule {
    public static final String SERVER_ADDRESS_KEY = "gov.va.med.vistalink.security.ServerAddressKey";
    public static final String SERVER_ADDRESS_KEY_V1 = "gov.va.med.foundations.security.vistalink.ServerAddressKey";
    public static final String SERVER_PORT_KEY = "gov.va.med.vistalink.security.ServerPortKey";
    public static final String SERVER_PORT_KEY_V1 = "gov.va.med.foundations.security.vistalink.ServerPortKey";
    public static final String SERVER_SPI_KEY = "gov.va.med.vistalink.security.SPIKey";
    private Subject subject;
    private VistaKernelPrincipalImpl userPrincipal;
    private Map options;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private static final Logger logger = Logger.getLogger(VistaLoginModule.class);
    private int timeoutInSeconds = 0;
    private boolean ccowTokenUsedForLogin = false;
    private boolean ccowLoginModeEnabled = false;
    private String domainName = "";
    private String vpid = "";
    private static final int AUTOLOGON_TIMEOUT_VALUE = 200;
    private static final int LOGIN_TRY_COUNT_LIMIT = 10;
    private static final int LOGIN_SPI_MODE_UNKNOWN = 0;
    private static final int LOGIN_SPI_MODE_CLIENT_SERVER = 1;
    private static final int LOGIN_SPI_MODE_MOCK = 2;
    private static final int LOGIN_SPI_MODE_FATKAAT = 3;
    private static final int LOGIN_SPI_MODE_UNITTEST = 4;
    private int loginSPIMode;
    private VistaLoginModuleSPI loginSPI;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.options = options;
        this.sharedState = sharedState;
        this.callbackHandler = callbackHandler;
        String loginSPIClassName = (String)this.options.get(SERVER_SPI_KEY);
        if (loginSPIClassName == null || loginSPIClassName.equals("")) {
            loginSPIClassName = "gov.va.med.vistalink.security.VistaLoginModuleSPIClientServer";
        }
        this.loginSPIMode = 0;
        try {
            this.loginSPI = (VistaLoginModuleSPI)Class.forName(loginSPIClassName).newInstance();
            if (loginSPIClassName.equals("gov.va.med.vistalink.security.VistaLoginModuleSPIClientServer")) {
                this.loginSPIMode = 1;
            } else if (loginSPIClassName.equals("gov.va.med.vistalink.security.VistaLoginModuleSPIMock")) {
                this.loginSPIMode = 2;
            } else if (loginSPIClassName.equals("gov.va.med.authentication.kernel.fatkaat.VistaLoginModuleSPIFatKAAT")) {
                this.loginSPIMode = 3;
            } else if (loginSPIClassName.equals("gov.va.med.vistalink.security.VistaLoginModuleSPIUnitTest")) {
                this.loginSPIMode = 3;
            }
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("VistaLoginModuleSPI error: " + e.getMessage()));
        }
        catch (InstantiationException e) {
            logger.error((Object)("VistaLoginModuleSPI error: " + e.getMessage()));
        }
        catch (IllegalAccessException e) {
            logger.error((Object)("VistaLoginModuleSPI error: " + e.getMessage()));
        }
    }

    public boolean login() throws VistaLoginModuleException, VistaLoginModuleLoginsDisabledException, VistaLoginModuleNoJobSlotsAvailableException, VistaLoginModuleNoPathToListenerException, VistaLoginModuleTooManyInvalidAttemptsException, VistaLoginModuleUserCancelledException, VistaLoginModuleUserTimedOutException {
        String exceptionMessage = "VistaLoginModule login method failed.";
        if (this.loginSPIMode == 0) {
            String loginSPIMode = (String)this.options.get(SERVER_SPI_KEY);
            if (loginSPIMode == null) {
                loginSPIMode = " [null] ";
            }
            String errMessage = "Login SPI provider class '" + loginSPIMode + "' is unsupported.";
            logger.error((Object)exceptionMessage);
            throw new VistaLoginModuleException(errMessage);
        }
        try {
            this.loginSPI.initialize(this.options, this.sharedState);
        }
        catch (IOException e) {
            this.logoutConnectionBeforeLoginComplete();
            logger.error((Object)exceptionMessage, (Throwable)e);
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
        catch (UnsupportedCallbackException e) {
            this.logoutConnectionBeforeLoginComplete();
            logger.error((Object)exceptionMessage, (Throwable)e);
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
        catch (VistaLoginModuleException e) {
            throw e;
        }
        catch (Exception e) {
            this.logoutConnectionBeforeLoginComplete();
            logger.error((Object)exceptionMessage, (Throwable)e);
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
        this.performAllLogonSteps();
        return true;
    }

    /*
     * Exception decompiling
     */
    private void performAllLogonSteps() throws VistaLoginModuleException, VistaLoginModuleTooManyInvalidAttemptsException, VistaLoginModuleUserCancelledException, VistaLoginModuleUserTimedOutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[DOLOOP]], but top level block is 20[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SecurityVOLogon getIntroductoryTextAndSetupInfo(SecurityVOSetupAndIntroText introTextAndServerInfo) throws VistaLoginModuleException {
        SecurityVOLogon returnVal;
        block9: {
            returnVal = null;
            String exceptionMessage = "Error doing M setup/introduction text retrieval: ";
            try {
                Object responseDataObj;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"-> sending AV.SetupAndIntroText");
                }
                if ((responseDataObj = this.loginSPI.getSetupAndIntroTextInfo()) instanceof SecurityVOSetupAndIntroText) {
                    SecurityVOSetupAndIntroText myInfo = (SecurityVOSetupAndIntroText)responseDataObj;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Result: " + myInfo.getResultType()));
                    }
                    introTextAndServerInfo.setDevice(myInfo.getDevice());
                    introTextAndServerInfo.setIntroductoryText(myInfo.getIntroductoryText());
                    introTextAndServerInfo.setServerName(myInfo.getServerName());
                    introTextAndServerInfo.setUci(myInfo.getUci());
                    introTextAndServerInfo.setVolume(myInfo.getVolume());
                    introTextAndServerInfo.setLogonRetryCount(myInfo.getLogonRetryCount());
                    introTextAndServerInfo.setTimeout(myInfo.getTimeout());
                    break block9;
                }
                if (responseDataObj instanceof SecurityVOLogon) {
                    returnVal = (SecurityVOLogon)responseDataObj;
                    break block9;
                }
                String errMessage = exceptionMessage + "; Unexpected response class for " + "AV.SetupAndIntroText" + " request: ";
                errMessage = responseDataObj != null ? errMessage + responseDataObj.getClass().getName() : errMessage + "null";
                logger.error((Object)errMessage);
                this.logoutConnectionBeforeLoginComplete();
                throw new VistaLoginModuleException(errMessage);
            }
            catch (IOException e) {
                logger.error((Object)exceptionMessage, (Throwable)e);
                this.logoutConnectionBeforeLoginComplete();
                throw new VistaLoginModuleException(exceptionMessage, e);
            }
            catch (UnsupportedCallbackException e) {
                logger.error((Object)exceptionMessage, (Throwable)e);
                this.logoutConnectionBeforeLoginComplete();
                throw new VistaLoginModuleException(exceptionMessage, e);
            }
            catch (VistaLoginModuleException e) {
                throw e;
            }
            catch (Exception e) {
                logger.error((Object)exceptionMessage, (Throwable)e);
                this.logoutConnectionBeforeLoginComplete();
                throw new VistaLoginModuleException(exceptionMessage, e);
            }
        }
        return returnVal;
    }

    private void doSelectDivisionAndOrChangeVc(SecurityVOLogon responseData, int retryLogonCount, boolean enteredVerifyCodeWasNull) throws VistaLoginModuleException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Need new Verify Code: " + responseData.getNeedNewVerifyCode() + " Need to select Divisions: " + responseData.getNeedDivisionSelection()));
        }
        if (responseData.getNeedNewVerifyCode()) {
            this.doChangeVC(responseData.getResultMessage(), responseData.getCvcHelpText(), retryLogonCount, enteredVerifyCodeWasNull);
        } else if (responseData.getNeedDivisionSelection()) {
            this.doSelectDivision((TreeMap)responseData.getDivisionList(), retryLogonCount);
        } else {
            this.logoutConnectionBeforeLoginComplete();
            throw new VistaLoginModuleException("Logon response was partial success, but M provided no reason for why login is only a partial success!");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void doChangeVC(String changeVCMessage, String cvcHelpText, int retryLogonCount, boolean enteredVerifyCodeWasNull) throws VistaLoginModuleException, VistaLoginModuleTooManyInvalidAttemptsException, VistaLoginModuleUserCancelledException, VistaLoginModuleUserTimedOutException {
        block15: {
            vcOld = "";
            vcNew = "";
            vcNewCheck = "";
            tryCount = 0;
            exceptionMessage = "Change verify code failed: ";
            try {
                do lbl-1000:
                // 3 sources

                {
                    block16: {
                        calls = new Callback[1];
                        changeVcCbh = new CallbackChangeVc(changeVCMessage, cvcHelpText, this.timeoutInSeconds, enteredVerifyCodeWasNull);
                        calls[0] = changeVcCbh;
                        this.callbackHandler.handle(calls);
                        vcOld = changeVcCbh.getOldVerifyCode();
                        vcNew = changeVcCbh.getNewVerifyCode();
                        vcNewCheck = changeVcCbh.getNewVerifyCodeCheck();
                        if (changeVcCbh.getSelectedOption() == 0) {
                            this.logoutConnectionBeforeLoginComplete();
                            throw new VistaLoginModuleUserCancelledException("User cancelled changing of verify code.");
                        }
                        if (changeVcCbh.getSelectedOption() == 2) {
                            this.logoutConnectionBeforeLoginComplete();
                            throw new VistaLoginModuleUserTimedOutException("User changing of verify code timed out.");
                        }
                        if (changeVcCbh.getSelectedOption() != 1) {
                            this.logoutConnectionBeforeLoginComplete();
                            throw new VistaLoginModuleUserCancelledException("User did not press OK when changing verify code.");
                        }
                        if (vcNew.equals(vcNewCheck)) break block16;
                        this.doCallbackConfirm("The confirmation code does not match.", 0, "Change Verify Code Error");
                        if (++tryCount < retryLogonCount) ** GOTO lbl-1000
                        this.logoutConnectionBeforeLoginComplete();
                        throw new VistaLoginModuleTooManyInvalidAttemptsException("Change verify code failed due to invalid user entry.");
                    }
                    if (VistaLoginModule.logger.isDebugEnabled()) {
                        VistaLoginModule.logger.debug((Object)"-> sending AV.UpdateVC");
                    }
                    responseData = this.loginSPI.changeVerifyCode(vcOld.toUpperCase(), vcNew.toUpperCase(), vcNewCheck.toUpperCase());
                    if (VistaLoginModule.logger.isDebugEnabled()) {
                        VistaLoginModule.logger.debug((Object)("Result: " + responseData.getResultType()));
                    }
                    if (responseData.getResultType() == 2) {
                        this.doCvcConfirm();
                        if (responseData.getNeedDivisionSelection()) {
                            if (VistaLoginModule.logger.isDebugEnabled()) {
                                VistaLoginModule.logger.debug((Object)("Need to select divisions: " + responseData.getNeedDivisionSelection()));
                            }
                            this.doSelectDivision((TreeMap)responseData.getDivisionList(), retryLogonCount);
                        }
                        break block15;
                    }
                    if (responseData.getResultType() == 1) {
                        this.doCvcConfirm();
                        break block15;
                    }
                    sb = new StringBuffer("Change Verify Code failed:\n");
                    sb.append(responseData.getResultMessage());
                    this.doCallbackConfirm(sb.toString(), 0, "Change Verify Code Error");
                } while (++tryCount < retryLogonCount);
                this.logoutConnectionBeforeLoginComplete();
                throw new VistaLoginModuleTooManyInvalidAttemptsException("Change verify code failed due to invalid user entry.");
            }
            catch (UnsupportedCallbackException e) {
                this.logoutConnectionBeforeLoginComplete();
                throw new VistaLoginModuleException(exceptionMessage, e);
            }
            catch (IOException e) {
                this.logoutConnectionBeforeLoginComplete();
                VistaLoginModule.logger.error((Object)exceptionMessage, (Throwable)e);
                throw new VistaLoginModuleException(exceptionMessage, e);
            }
            catch (VistaLoginModuleException e) {
                throw e;
            }
            catch (Exception e) {
                this.logoutConnectionBeforeLoginComplete();
                VistaLoginModule.logger.error((Object)exceptionMessage, (Throwable)e);
                throw new VistaLoginModuleException(exceptionMessage, e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doSelectDivision(TreeMap divisionList, int retryLogonCount) throws VistaLoginModuleException, VistaLoginModuleTooManyInvalidAttemptsException, VistaLoginModuleUserCancelledException, VistaLoginModuleUserTimedOutException {
        if (this.ccowTokenUsedForLogin) return;
        int tryCount = 0;
        String exceptionMessage = "Division selection failed: ";
        try {
            do {
                Callback[] calls = new Callback[1];
                CallbackSelectDivision divCbh = new CallbackSelectDivision(divisionList, this.timeoutInSeconds);
                calls[0] = divCbh;
                this.callbackHandler.handle(calls);
                String selectedDivision = divCbh.getSelectedDivisionIen();
                if (divCbh.getSelectedOption() == 0) {
                    this.logoutConnectionBeforeLoginComplete();
                    throw new VistaLoginModuleUserCancelledException("User cancelled division selection.");
                }
                if (divCbh.getSelectedOption() == 2) {
                    this.logoutConnectionBeforeLoginComplete();
                    throw new VistaLoginModuleUserTimedOutException("User division selection timed out.");
                }
                if (divCbh.getSelectedOption() != 1) {
                    this.logoutConnectionBeforeLoginComplete();
                    throw new VistaLoginModuleUserCancelledException("Select Division failed without user pressing OK.");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"-> sending AV.SelectDivision");
                }
                SecurityVOSelectDivision responseData = this.loginSPI.selectDivision(selectedDivision);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Result: " + responseData.getResultType()));
                }
                if (responseData.getResultType() == 1) return;
                this.doCallbackConfirm(responseData.getResultMessage(), 0, "Select Division Error");
            } while (++tryCount < retryLogonCount);
            this.logoutConnectionBeforeLoginComplete();
            throw new VistaLoginModuleException("Division selection failed due to too many invalid user entries.");
        }
        catch (UnsupportedCallbackException e) {
            this.logoutConnectionBeforeLoginComplete();
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
        catch (IOException e) {
            this.logoutConnectionBeforeLoginComplete();
            logger.error((Object)exceptionMessage, (Throwable)e);
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
        catch (VistaLoginModuleException e) {
            throw e;
        }
        catch (Exception e) {
            this.logoutConnectionBeforeLoginComplete();
            logger.error((Object)exceptionMessage, (Throwable)e);
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
    }

    private void doCvcConfirm() throws VistaLoginModuleException, VistaLoginModuleUserCancelledException, VistaLoginModuleUserTimedOutException {
        this.doCallbackConfirm("Change of Verify Code succeeded.", 1, "Change Verify Code Confirmation");
    }

    private void doCallbackConfirm(String messageText, int messageType, String contextDescription) throws VistaLoginModuleException, VistaLoginModuleUserCancelledException, VistaLoginModuleUserTimedOutException {
        String exceptionMessage = contextDescription + " error: ";
        try {
            Callback[] calls = new Callback[1];
            CallbackConfirm ccCbh = new CallbackConfirm(messageText, messageType, contextDescription, this.timeoutInSeconds);
            calls[0] = ccCbh;
            this.callbackHandler.handle(calls);
            if (ccCbh.getSelectedOption() == 0) {
                this.logoutConnectionBeforeLoginComplete();
                throw new VistaLoginModuleUserCancelledException(contextDescription + ": User cancelled.");
            }
            if (ccCbh.getSelectedOption() == 2) {
                this.logoutConnectionBeforeLoginComplete();
                throw new VistaLoginModuleUserTimedOutException(contextDescription + ": User timed out.");
            }
            if (ccCbh.getSelectedOption() != 1) {
                this.logoutConnectionBeforeLoginComplete();
                throw new VistaLoginModuleUserCancelledException(contextDescription + ": User did not press OK to close dialog.");
            }
        }
        catch (UnsupportedCallbackException e) {
            this.logoutConnectionBeforeLoginComplete();
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
        catch (IOException e) {
            this.logoutConnectionBeforeLoginComplete();
            logger.error((Object)exceptionMessage, (Throwable)e);
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
    }

    private void getUserDemographicsAndBuildPrincipal() throws VistaLoginModuleException {
        String exceptionMessage = "User Demographic retrieval failure: ";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"-> sending AV.GetUserDemographics");
        }
        SecurityVOUserDemographics responseData = null;
        try {
            responseData = this.loginSPI.getUserDemographicsData();
        }
        catch (VistaLoginModuleException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)exceptionMessage, (Throwable)e);
            throw new VistaLoginModuleException(exceptionMessage, e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Result: " + responseData.getResultType()));
        }
        if (responseData.getResultType() != 1) {
            this.logoutConnectionBeforeLoginComplete();
            throw new VistaLoginModuleException(exceptionMessage + responseData.getResultMessage());
        }
        this.domainName = (String)responseData.getUserDemographicsHashtable().get("KEY_DOMAIN_NAME");
        responseData.getUserDemographicsHashtable().remove("KEY_DOMAIN_NAME");
        this.vpid = (String)responseData.getUserDemographicsHashtable().get("KEY_VPID");
        this.userPrincipal = new VistaKernelPrincipalImpl(responseData.getUserDemographicsHashtable());
    }

    public boolean commit() throws LoginException {
        if (!this.subject.getPrincipals().contains(this.userPrincipal)) {
            this.subject.getPrincipals().add((Principal)((Object)this.userPrincipal));
        }
        if (!this.ccowTokenUsedForLogin && this.ccowLoginModeEnabled) {
            StringBuffer errorSb = new StringBuffer("Warning -- could not create CCOW User Context during login.");
            errorSb.append("SSO (Single Sign On) may not be enabled for subsequent applications.");
            Callback[] calls = new Callback[1];
            String ccowSecurePasscode = null;
            String kernelCcowToken = null;
            try {
                ccowSecurePasscode = this.loginSPI.getSecureCcowPasscode();
                kernelCcowToken = this.loginSPI.getKernelCcowToken();
            }
            catch (Exception e) {
                try {
                    errorSb.append(e.getMessage());
                    this.doCallbackConfirm(errorSb.toString(), 1, "CCOW Warning");
                }
                catch (VistaLoginModuleException e1) {
                    this.logoutConnectionBeforeLoginComplete();
                    if (e instanceof VistaLoginModuleException) {
                        throw (VistaLoginModuleException)e;
                    }
                    throw new VistaLoginModuleException(e);
                }
            }
            if (ccowSecurePasscode != null || kernelCcowToken != null) {
                CallbackCommit ccomCbh = new CallbackCommit(this.userPrincipal.getUserDemographicValue("KEY_NAME_NEWPERSON01"), this.domainName, this.vpid, ccowSecurePasscode, kernelCcowToken);
                calls[0] = ccomCbh;
                try {
                    this.callbackHandler.handle(calls);
                }
                catch (Exception e) {
                    errorSb.append(e.getMessage());
                    logger.error((Object)errorSb.toString());
                    try {
                        this.doCallbackConfirm(errorSb.toString(), 1, "CCOW Warning");
                    }
                    catch (VistaLoginModuleException e1) {
                        this.logoutConnectionBeforeLoginComplete();
                        throw e1;
                    }
                }
                if (ccomCbh.wasCancelPressed() || ccomCbh.getErrorMessageToReport().length() > 1) {
                    if (ccomCbh.wasCancelPressed()) {
                        this.logoutConnectionBeforeLoginComplete();
                        throw new VistaLoginModuleUserCancelledException("User cancelled login.");
                    }
                    if (ccomCbh.getErrorMessageToReport().length() > 1) {
                        errorSb.append(ccomCbh.getErrorMessageToReport());
                        logger.error((Object)errorSb.toString());
                        try {
                            this.doCallbackConfirm(errorSb.toString(), 1, "CCOW Warning");
                        }
                        catch (VistaLoginModuleException e1) {
                            this.logoutConnectionBeforeLoginComplete();
                            throw e1;
                        }
                    }
                }
            }
        }
        return true;
    }

    public boolean abort() throws VistaLoginModuleException {
        if (this.userPrincipal != null && this.userPrincipal.getAuthenticatedConnection() != null) {
            this.logout();
        }
        return true;
    }

    private void logoutConnectionBeforeLoginComplete() {
        try {
            this.loginSPI.logout();
        }
        catch (VistaLoginModuleException e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean logout() throws VistaLoginModuleException {
        if (this.userPrincipal != null && this.userPrincipal.getAuthenticatedConnection() != null) {
            try {
                this.loginSPI.logout();
            }
            catch (VistaLoginModuleException e) {
                throw e;
            }
            catch (Exception e) {
                logger.error((Object)"Error logging out: ", (Throwable)e);
                throw new VistaLoginModuleException("Error logging out: ", e);
            }
        }
        return true;
    }
}

