/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.security;

import gov.va.med.vistalink.security.CallbackChangeVc;
import gov.va.med.vistalink.security.CallbackCommit;
import gov.va.med.vistalink.security.CallbackConfirm;
import gov.va.med.vistalink.security.CallbackHandlerBase;
import gov.va.med.vistalink.security.CallbackLogon;
import gov.va.med.vistalink.security.CallbackSelectDivision;
import gov.va.med.vistalink.security.m.SecurityVOSetupAndIntroText;
import gov.va.med.vistalink.security.m.VistaInstitutionVO;
import java.util.Map;
import java.util.TreeMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class CallbackHandlerUnitTest
extends CallbackHandlerBase {
    private static final Logger logger = Logger.getLogger(CallbackHandlerUnitTest.class);
    private char[] accessCode;
    private char[] verifyCode;
    private String divisionIen = "";
    private char[] newVerifyCode;
    private char[] newVerifyCodeCheck;

    public CallbackHandlerUnitTest(String accessCode, String verifyCode, String divisionIen) {
        this.accessCode = accessCode.toCharArray();
        this.verifyCode = verifyCode.toCharArray();
        this.divisionIen = divisionIen;
    }

    public CallbackHandlerUnitTest(String accessCode, String oldVerifyCode, String divisionIen, String newVerifyCode, String newVerifyCodeCheck) {
        this.accessCode = accessCode != null ? accessCode.toCharArray() : "".toCharArray();
        this.verifyCode = oldVerifyCode != null ? oldVerifyCode.toCharArray() : "".toCharArray();
        this.divisionIen = divisionIen;
        this.newVerifyCode = newVerifyCode != null ? newVerifyCode.toCharArray() : "".toCharArray();
        this.newVerifyCodeCheck = newVerifyCodeCheck != null ? newVerifyCodeCheck.toCharArray() : "".toCharArray();
    }

    void doCallbackChangeVc(CallbackChangeVc cvcCallback) throws UnsupportedCallbackException {
        logger.debug((Object)"starting CallbackChangeVc");
        cvcCallback.setNewVerifyCode(this.newVerifyCode);
        cvcCallback.setNewVerifyCodeCheck(this.newVerifyCodeCheck);
        cvcCallback.setOldVerifyCode(this.verifyCode);
        cvcCallback.setSelectedOption(1);
    }

    void doCallbackConfirm(CallbackConfirm confirmCallback) {
        logger.debug((Object)"starting CallbackConfirm");
        String messageText = confirmCallback.getDisplayMessage();
        logger.error((Object)messageText);
        confirmCallback.setSelectedOption(1);
    }

    void doCallbackLogon(CallbackLogon logonCallback) {
        logger.debug((Object)"starting CallbackLogon");
        SecurityVOSetupAndIntroText setupInfo = logonCallback.getSetupAndIntroTextInfo();
        logger.debug((Object)setupInfo);
        String introText = setupInfo.getIntroductoryText();
        logger.debug((Object)introText);
        logonCallback.setAccessCode(this.accessCode);
        logonCallback.setVerifyCode(this.verifyCode);
        logonCallback.setSelectedOption(1);
    }

    void doCallbackSelectDivision(CallbackSelectDivision divisionCallback) {
        logger.debug((Object)"starting CallbackSelectDivision");
        TreeMap divisionList = (TreeMap)divisionCallback.getDivisionList();
        for (Map.Entry entry : divisionList.entrySet()) {
            VistaInstitutionVO myDivision = (VistaInstitutionVO)entry.getValue();
            logger.debug((Object)("candidate login division IEN: " + myDivision.getIen() + " Name: " + myDivision.getName() + " Number: " + myDivision.getNumber()));
        }
        divisionCallback.setSelectedDivisionIen(this.divisionIen);
        divisionCallback.setSelectedOption(1);
    }

    void doCallbackCommit(CallbackCommit commitCallback) {
        logger.debug((Object)"starting CallbackCommit");
    }

    void doUnsupportedCallback(Callback callback) throws UnsupportedCallbackException {
        String errMsg = "Unsupported callback: '" + callback.getClass() + "'";
        UnsupportedCallbackException e = new UnsupportedCallbackException(callback, errMsg);
        if (logger.isEnabledFor((Priority)Level.ERROR)) {
            logger.error((Object)errMsg, (Throwable)e);
        }
        throw e;
    }
}

