/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.vistalink.security;

import gov.va.med.hds.cd.ccow.ContextItemNameFactory;
import gov.va.med.hds.cd.ccow.IClinicalContextBroker;
import gov.va.med.hds.cd.ccow.IContextItemName;
import gov.va.med.hds.cd.ccow.IContextModule;
import gov.va.med.hds.cd.ccow.internal.ContextModule;
import gov.va.med.vistalink.security.CallbackCommit;
import gov.va.med.vistalink.security.CallbackHandlerSwing;
import gov.va.med.vistalink.security.CallbackLogon;
import gov.va.med.vistalink.security.DialogLogon;
import java.awt.Frame;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CallbackHandlerSwingCCOW
extends CallbackHandlerSwing {
    private static final Logger logger = Logger.getLogger(CallbackHandlerSwingCCOW.class);
    private IClinicalContextBroker applicationCcowContextBroker;
    static final String CCOW_BROKER_KEY = "CCOW_BROKER_KEY";
    static final String CCOW_CONTEXT_MODULE_KEY = "CCOW_CONTEXT_MODULE_KEY";
    public static final String VHA_CCOW_LOGON_TOKEN = "user.id.logon.vistatoken";
    public static final String VHA_CCOW_LOGON_NAME = "user.id.logon.vistaname";
    public static final String VHA_CCOW_LOGON_NAME_GENERIC = "user.co.name";
    public static final String VHA_CCOW_LOGON_VPID = "user.id.logon.vpid";
    public static final String VHA_CCOW_LOGON_DOMAIN = "user.id.logon.vistalogon";
    public static final String[] VHA_CCOW_USER_CONTEXT_KEYS = new String[]{"user.id.logon.vistatoken", "user.id.logon.vistaname", "user.co.name", "user.id.logon.vpid", "user.id.logon.vistalogon"};
    private static final String CCOW_APPLICATION_NAME = "VistaLinkLoginModule";
    private IClinicalContextBroker loginModuleContextBroker;
    private ContextModule loginModuleContextModule;
    private static final int RPC_RESULT_DELIMITER = 10;

    public CallbackHandlerSwingCCOW(Frame windowParent, IContextModule applicationCcowContextModule, IClinicalContextBroker applicationCcowContextBroker) {
        super(windowParent);
        this.applicationCcowContextBroker = applicationCcowContextBroker;
    }

    void doCallbackLogon(CallbackLogon logonCallback) {
        logger.debug((Object)"starting CallbackLogon.");
        String user = null;
        String token = null;
        logonCallback.setCcowLogonModeEnabled(true);
        if (this.applicationCcowContextBroker != null && logonCallback.getTryCount() < 2 && this.applicationCcowContextBroker.isConnected()) {
            Map contextItems = this.applicationCcowContextBroker.getContextItems();
            IContextItemName tokenKey = ContextItemNameFactory.getName((String)VHA_CCOW_LOGON_TOKEN);
            IContextItemName nameKey = ContextItemNameFactory.getName((String)VHA_CCOW_LOGON_NAME);
            token = (String)contextItems.get(tokenKey);
            user = (String)contextItems.get(nameKey);
        }
        if (user == null || user.length() < 1 || token == null || token.length() < 1) {
            DialogLogon.showVistaAVSwingGetAV(this.getWindowParent(), logonCallback);
        } else {
            logonCallback.setToken(token);
            logonCallback.setSelectedOption(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doCallbackCommit(CallbackCommit commitCallback) {
        logger.debug((Object)"starting CallbackCommit.");
        if (this.applicationCcowContextBroker != null) {
            if (!this.applicationCcowContextBroker.isConnected()) {
                logger.info((Object)"context Broker is not connected.");
            } else {
                Map contextItems = this.applicationCcowContextBroker.getContextItems();
                IContextItemName tokenKey = ContextItemNameFactory.getName((String)VHA_CCOW_LOGON_TOKEN);
                IContextItemName nameKey = ContextItemNameFactory.getName((String)VHA_CCOW_LOGON_NAME);
                String ccowToken = (String)contextItems.get(tokenKey);
                String ccowName = (String)contextItems.get(nameKey);
                if (ccowToken == null || ccowToken.length() < 1 || ccowName == null || ccowName.length() < 1) {
                    String kernelTokenAndId = commitCallback.getKernelCcowToken();
                    int newlineFirst = kernelTokenAndId.indexOf(10);
                    int newlineSecond = kernelTokenAndId.indexOf(10, newlineFirst + 1);
                    String kernelToken = kernelTokenAndId.substring(0, newlineFirst);
                    String kernelDomain = kernelTokenAndId.substring(newlineFirst + 1, newlineSecond);
                    HashMap<String, String> newContext = new HashMap<String, String>();
                    newContext.put(VHA_CCOW_LOGON_NAME, commitCallback.getNameNewPerson01());
                    newContext.put(VHA_CCOW_LOGON_NAME_GENERIC, commitCallback.getNameNewPerson01());
                    newContext.put(VHA_CCOW_LOGON_TOKEN, kernelToken);
                    newContext.put(VHA_CCOW_LOGON_VPID, commitCallback.getVpid());
                    newContext.put(VHA_CCOW_LOGON_DOMAIN, kernelDomain);
                    this.loginModuleContextModule = new ContextModule(CCOW_APPLICATION_NAME, commitCallback.getCcowSecurePasscode());
                    try {
                        logger.debug((Object)"about to write user context.");
                        this.loginModuleContextBroker = this.loginModuleContextModule.getBroker((Object)this, null);
                        if (!this.loginModuleContextBroker.isConnected()) {
                            String errorMessage = "Login module context broker could not connect to CCOW context, so could not write new user context.";
                            logger.error((Object)errorMessage);
                            commitCallback.setErrorMessageToReport(errorMessage);
                        } else {
                            Object requestToken = this.loginModuleContextBroker.requestChange(newContext.keySet());
                            if (requestToken != null) {
                                if (!this.loginModuleContextBroker.changeContext(requestToken, newContext)) {
                                    String errorMessage = "ContextBroker 'changeContext' request failed, could not write new user context.";
                                    logger.error((Object)errorMessage);
                                    commitCallback.setErrorMessageToReport(errorMessage);
                                }
                            } else {
                                String errorMessage = "requestToken returned by ContextBroker 'requestChange' method is null, could not write new user context.";
                                logger.error((Object)errorMessage);
                                commitCallback.setErrorMessageToReport(errorMessage);
                            }
                        }
                    }
                    catch (Throwable t) {
                        String errorMessage = t.getMessage();
                        logger.error((Object)("Error encountered contacting CCOW context broker: " + t.getMessage()));
                        commitCallback.setErrorMessageToReport(errorMessage);
                    }
                    finally {
                        this.doCcowShutdown();
                    }
                }
            }
        }
        logger.debug((Object)"End CallbackCommit.");
    }

    private void doCcowShutdown() {
        logger.debug((Object)"shutting down login CCOW module");
        if (this.loginModuleContextBroker != null && this.loginModuleContextBroker.isConnected()) {
            logger.debug((Object)"login CCOW context broker breaking external link.");
            this.loginModuleContextBroker.breakExternalLink();
        }
        if (this.loginModuleContextModule != null) {
            logger.debug((Object)"login CCOW module shutdown()");
            this.loginModuleContextModule.shutdown();
        }
        this.loginModuleContextBroker = null;
        this.loginModuleContextModule = null;
    }

    public static boolean hasNonNullUserContext(Map contextItems) {
        boolean returnVal = false;
        if (contextItems != null) {
            Set keySet = contextItems.keySet();
            for (IContextItemName key : keySet) {
                String value;
                if (!"user.id.logon".equals(key.getName().substring(0, 13)) || (value = (String)contextItems.get(key)) == null || value.length() <= 0) continue;
                returnVal = true;
                break;
            }
        }
        return returnVal;
    }
}

