/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.pharmacy.persistence.track.impl;

import gov.va.med.pharmacy.persistence.track.NcpdpMessageListModel;
import gov.va.med.pharmacy.persistence.track.NcpdpMessageModel;
import gov.va.med.pharmacy.persistence.track.NcpdpMessagesDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
public class NcpdpMessagesDaoImpl
implements NcpdpMessagesDao {
    private static final Logger LOG = LogManager.getLogger(NcpdpMessagesDaoImpl.class);
    @Autowired
    private DataSource dataSource;
    @Autowired
    NcpdpMessageModel ncpdpMsg;

    public NcpdpMessagesDaoImpl() {
    }

    public NcpdpMessagesDaoImpl(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public NcpdpMessageModel findById(String id, String inboundOutbound) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        String sql = "";
        sql = inboundOutbound.equalsIgnoreCase("Inbound") ? "select t.inbound_ncpdp_msg_id inbound_ncpdp_msg_id,  \r\n        \t\t  x.message_id rx_messageId,  \r\n        \t\t  x.rel_to_message_id,  \r\n        \t\t  x.message_type,  \r\n\t\t\t\t  (select code_description from erx_status where code = t.message_status) message_status, \r\n        \t\t  to_char(t.received_date,'MM/DD/YYYY') received_date,  \r\n        \t\t  x.pharmacy_name,  \r\n        \t\t  x.pharmacy_addr_1||' '||x.pharmacy_addr_2 pharmacy_addr_1,  \r\n        \t\t  x.pharmacy_city||', '||x.pharmacy_state||'  '||x.pharmacy_zip pharmacy_addr_2,  \r\n        \t\tpharmacy_phone.pharmacy_number pharmacy_phone,  \r\n        \t\tnvl(x.pharmacy_ncpdpid1,x.pharmacy_ncpdpid2) pharmacy_ncpdpid,   \r\n        \t\t  x.prescriber_First_Name,  \r\n        \t\t  x.prescriber_Mid_Name,  \r\n        \t\t  x.prescriber_Last_Name,  \r\n        \t\t  x.prescriber_addr_1||' '||x.prescriber_addr_2 prescriber_addr_1,  \r\n        \t\t  x.prescriber_city||', '||x.prescriber_state||'  '||x.prescriber_zip prescriber_addr_2,  \r\n        \t\t  x.npi1 prescriber_NPI,  \r\n        \t\t  x.npi2 clinic_id,  \r\n        \t\t  x.prescriber_DEA,  \r\n        \t\t  x.prescriber_State_Lic,  \r\n        \t\tprescriber_fax.prescriber_faxnumber prescriber_fax, \r\n        \t\tprescriber_phone.prescriber_number prescriber_phone,  \r\n        \t\t  x.prescriber_agent_first_name||' '||x.prescriber_agent_last_name prescriber_Agent,  \r\n        \t\t  x.patient_First_Name,  \r\n        \t\t  x.patient_Mid_Name,  \r\n        \t\t  x.patient_Last_Name,  \r\n        \t\t  x.patient_addr_1||' '||x.patient_addr_2 patient_addr_1,  \r\n        \t\t  x.patient_city||', '||x.patient_state||'  '||x.patient_zip patient_addr_2,  \r\n        \t\tto_char(to_date(x.patient_dob,'YYYY-MM-DD'),'MM/DD/YYYY') patient_dob,  \r\n        \t\t  x.patient_gender patient_gender,  \r\n        \t\t  benefits1.cardholder_id plan_id,  \r\n        \t\t  x.rx_Drug_Prescribed,  \r\n        \t\t  x.rx_Quantity,  \r\n        \t\t  x.rx_Days_Supply,  \r\n        \t  \tto_char(to_date(x.rx_Date_Written,'YYYY-MM-DD'),'MM/DD/YYYY') rx_Date_Written,  \r\n        \t\t  (select distinct ncit_pref_term from ncpdp_code where ncit_code = x.rx_Potency_Unit_Code) rx_Potency_Unit_Code,  \r\n        \t\t  (select distinct ncit_pref_term from ncpdp_code where ncit_code = x.rx_Drug_Form) rx_Drug_Form,  \r\n        \t\t  x.rx_Drug_Strength||' '||(select distinct ncit_pref_term from ncpdp_code where ncit_code = x.rx_Drug_Strength_Code) rx_Drug_Strength,  \r\n        \t\t  x.rx_Refills,  \r\n        \t\t  x.rx_Sig,\r\n              \t\tdecode(x.rx_Dispense_Notes,'0','0 = No Product Selection Indicated','1','1 = Substitution Not Allowed by Prescriber','2','2 = Substitution Allowed-Patient Requested Product Dispensed','3','3 = Substitution Allowed-Pharmacist Selected Product Dispensed','4','4 = Substitution Allowed-Generic Drug Not in Stock','5','5 = Substitution Allowed-Brand Drug Dispensed as a Generic','6','6 = Override','7','7 = Substitution Not Allowed-Brand Mandated by Law','8','8 = Substitution Allowed-Generic Drug Not Available in Marketplace','9','9 = Substitution Allowed By Prescriber but Plan Requests Brand - Patient''s Plan Requested Brand Product To Be Dispensed') rx_Dispense_Notes,\r\n\t\t\t\t\tx.rx_Comments,  \r\n        \t\t  benefits1.groupID rx_Grp,\r\n        \t\t  benefits1.rx_Bin_Num rx_Bin_Num,  \r\n        \t\t  benefits1.rx_Pcn rx_Pcn, \r\n                 x.res_type, \r\n                 x.req_refno,\r\n                 (select code||':  '||definition from ecl_code where code_type = '1131 \u2013 Code List Qualifier \u2013 Response Code - RES Segment' and code = x.res_aprv_reason_cd) res_aprv_reason_cd, \r\n                 x.res_aprv_refno, \r\n                 x.res_aprv_note, \r\n                 (select code||':  '||definition from ecl_code where code_type = '1131 \u2013 Code List Qualifier \u2013 Response Code - RES Segment' and code = x.res_aprv_w_chng_reason_cd) res_aprv_w_chng_reason_cd, \r\n                 x.res_aprv_w_chng_refno, \r\n                 x.res_aprv_w_chng_note, \r\n                 (select code||':  '||definition from ecl_code where code_type = '1131 \u2013 Code List Qualifier \u2013 Response Code - RES Segment' and code = x.res_denial_reason_cd) res_denial_reason_cd, \r\n                 x.res_denial_refno, \r\n                 x.res_denial_reason, \r\n                 (select code||':  '||definition from ecl_code where code_type = '1131 \u2013 Code List Qualifier \u2013 Response Code - RES Segment' and code = x.res_denial_nrx_reason_cd) res_denial_nrx_reason_cd, \r\n                 x.res_denial_nrx_refno, \r\n                 x.res_denial_nrx_reason,                  x.esv_description_code,                  x.esv_code,                  x.esv_description               from inbound_ncpdp_msg t, xmltable(xmlnamespaces('http://www.ncpdp.org/schema/SCRIPT' as \"ns\"), '/ns:Message'  \r\n        \t\t    passing t.message  \r\n        \t\t    columns   \r\n        \t\t    message_id varchar2(35) path '//ns:Header/ns:MessageID',  \r\n        \t\t    rel_to_message_id varchar2(35) path '//ns:Header/ns:RelatesToMessageID',  \r\n        \t\t    message_type varchar2(35) path 'name(/ns:Body/*[1])',  \r\n        \t\t    pharmacy_name varchar2(35) path '//ns:Pharmacy/ns:StoreName',  \r\n        \t\t    pharmacy_addr_1 varchar2(35) path '//ns:Pharmacy/ns:Address/ns:AddressLine1',  \r\n        \t\t    pharmacy_addr_2 varchar2(35) path '//ns:Pharmacy/ns:Address/ns:AddressLine2',  \r\n        \t\t    pharmacy_city varchar2(35) path '//ns:Pharmacy/ns:Address/ns:City',  \r\n        \t\t    pharmacy_state varchar2(2) path '//ns:Pharmacy/ns:Address/ns:State',  \r\n        \t\t    pharmacy_zip varchar2(14) path '//ns:Pharmacy/ns:Address/ns:ZipCode',  \r\n        \t\t    pharmacy_ncpdpid1 varchar2(35) path '//ns:Pharmacy/ns:Identification/ns:NCPDPID',  \r\n        \t\t    pharmacy_ncpdpid2 varchar2(35) path '//ns:Header/ns:To',  \r\n        \t\t    npi1 varchar2(35) path '//ns:Prescriber/ns:Identification/ns:NPI',  \r\n        \t\t    npi2 varchar2(35) path '//ns:Header/ns:From',  \r\n        \t\t    prescriber_First_Name varchar2(35) path '//ns:Prescriber/ns:Name/ns:FirstName',  \r\n        \t\t    prescriber_Mid_Name varchar2(35) path '//ns:Prescriber/ns:Name/ns:MiddleName',  \r\n        \t\t    prescriber_Last_Name varchar2(35) path '//ns:Prescriber/ns:Name/ns:LastName',  \r\n        \t\t    prescriber_addr_1 varchar2(35) path '//ns:Prescriber/ns:Address/ns:AddressLine1',  \r\n        \t\t    prescriber_addr_2 varchar2(35) path '//ns:Prescriber/ns:Address/ns:AddressLine2',  \r\n        \t\t    prescriber_city varchar2(35) path '//ns:Prescriber/ns:Address/ns:City',  \r\n        \t\t    prescriber_state varchar2(2) path '//ns:Prescriber/ns:Address/ns:State',  \r\n        \t\t    prescriber_zip varchar2(14) path '//ns:Prescriber/ns:Address/ns:ZipCode',  \r\n        \t\t    prescriber_agent_last_name varchar2(35) path '//ns:Prescriber/ns:PrescriberAgent/ns:LastName',  \r\n        \t\t    prescriber_agent_first_name varchar2(35) path '//ns:Prescriber/ns:PrescriberAgent/ns:FirstName',  \r\n        \t\t    prescriber_DEA varchar2(35) path '//ns:Prescriber/ns:Identification/ns:DEANumber',  \r\n        \t\t    prescriber_State_Lic varchar2(35) path '//ns:Prescriber/ns:Identification/ns:StateLicenseNumber',  \r\n        \t\t    patient_First_Name varchar2(35) path '//ns:Patient/ns:Name/ns:FirstName',  \r\n        \t\t    patient_Mid_Name varchar2(35) path '//ns:Patient/ns:Name/ns:MiddleName',  \r\n        \t\t    patient_Last_Name varchar2(35) path '//ns:Patient/ns:Name/ns:LastName',  \r\n        \t\t    patient_addr_1 varchar2(35) path '//ns:Patient/ns:Address/ns:AddressLine1',  \r\n        \t\t    patient_addr_2 varchar2(35) path '//ns:Patient/ns:Address/ns:AddressLine2',  \r\n        \t\t    patient_city varchar2(35) path '//ns:Patient/ns:Address/ns:City',  \r\n        \t\t    patient_state varchar2(2) path '//ns:Patient/ns:Address/ns:State',  \r\n        \t\t    patient_zip varchar2(14) path '//ns:Patient/ns:Address/ns:ZipCode',  \r\n        \t\t    patient_dob varchar2(30) path '//ns:Patient/ns:DateOfBirth/ns:Date',  \r\n        \t\t    patient_gender varchar2(1) path '//ns:Patient/ns:Gender',  \r\n        \t\t    rx_Drug_Prescribed varchar2(105) path '//ns:MedicationPrescribed/ns:DrugDescription',  \r\n        \t\t    rx_Quantity varchar2(30) path '//ns:MedicationPrescribed/ns:Quantity/ns:Value',  \r\n        \t\t    rx_Days_Supply varchar2(30) path '//ns:MedicationPrescribed/ns:DaysSupply',  \r\n        \t\t    rx_Date_Written varchar2(30) path '//ns:MedicationPrescribed/ns:WrittenDate',  \r\n        \t\t    rx_Potency_Unit_Code varchar2(30) path '//ns:MedicationPrescribed/ns:Quantity/ns:PotencyUnitCode',  \r\n        \t\t    rx_Drug_Form varchar2(30) path '//ns:MedicationPrescribed/ns:DrugCoded/ns:FormCode',  \r\n        \t\t    rx_Drug_Strength varchar2(70) path '//ns:MedicationPrescribed/ns:DrugCoded/ns:Strength',  \r\n\t\t\t\t\trx_Drug_Strength_Code varchar2(30) path '//ns:MedicationPrescribed/ns:DrugCoded/ns:StrengthCode',  \r\n        \t\t    rx_Refills varchar2(2) path '//ns:MedicationPrescribed/ns:Refills/ns:Value',  \r\n        \t\t    rx_Sig varchar2(140) path '//ns:MedicationPrescribed/ns:Directions',  \r\n        \t\t    rx_Dispense_Notes varchar2(35) path '//ns:MedicationPrescribed/ns:Substitutions',  \r\n        \t\t    rx_Comments varchar2(210) path '//ns:MedicationPrescribed/ns:Note',  \r\n             \t\tres_type varchar2(70) path 'name(/ns:Body/*/ns:Response/*[1])', \r\n             \t\treq_refno varchar2(70) path '//ns:Request/ns:Request/ns:ReferenceNumber',\r\n             \t\tres_aprv_reason_cd varchar2(70) path '//ns:Response/ns:Approved/ns:ApprovalReasonCode[1]',\r\n             \t\tres_aprv_refno varchar2(70) path '//ns:Response/ns:Approved/ns:ReferenceNumber',\r\n             \t\tres_aprv_note varchar2(70) path '//ns:Response/ns:Approved/ns:Note',\r\n             \t\tres_aprv_w_chng_reason_cd varchar2(70) path '//ns:Response/ns:ApprovedWithChanges/ns:DenialReasonCode[1]',\r\n             \t\tres_aprv_w_chng_refno varchar2(70) path '//ns:Response/ns:ApprovedWithChanges/ns:ReferenceNumber',\r\n             \t\tres_aprv_w_chng_note varchar2(70) path '//ns:Response/ns:ApprovedWithChanges/ns:Note',\r\n             \t\tres_denial_reason_cd varchar2(70) path '//ns:Response/ns:Denied/ns:DenialReasonCode[1]',\r\n             \t\tres_denial_refno varchar2(70) path '//ns:Response/ns:Denied/ns:ReferenceNumber',\r\n              \t\tres_denial_reason varchar2(70) path '//ns:Response/ns:Denied/ns:DenialReason',\r\n              \t\tres_denial_nrx_reason_cd varchar2(70) path '//ns:Response/ns:DeniedNewPrescriptionToFollow/ns:DenialReasonCode[1]',\r\n              \t\tres_denial_nrx_refno varchar2(70) path '//ns:Response/ns:DeniedNewPrescriptionToFollow/ns:ReferenceNumber',\r\n              \t\tres_denial_nrx_reason varchar2(70) path '//ns:Response/ns:DeniedNewPrescriptionToFollow/ns:DenialReason' ,\r\n              \t\tesv_description_code varchar2(70) path '//ns:DescriptionCode[1]',\r\n              \t\tesv_code varchar2(70) path '//ns:Code',\r\n              \t\tesv_description varchar2(70) path '//ns:Description' \r\n        \t\t    ) x,  \r\n        \t\t    (select pharmacy_com.pharmacy_number pharmacy_number,  \r\n        \t\t    pharmacy_com.pharmacy_qualifier pharmacy_qualifier,  \r\n        \t\t    t.inbound_ncpdp_msg_id inbound_ncpdp_msg_id  \r\n        \t\t    from erx.inbound_ncpdp_msg t, xmltable(xmlnamespaces('http://www.ncpdp.org/schema/SCRIPT' as \"ns\"), '/ns:Message'  \r\n        \t\t    passing t.message  \r\n        \t\t    columns records XMLTYPE PATH '//ns:Pharmacy/ns:CommunicationNumbers') r,  \r\n        \t\t    xmltable(xmlnamespaces('http://www.ncpdp.org/schema/SCRIPT' as \"ns\"),'//ns:Communication'  \r\n        \t\t    passing r.records  \r\n        \t\t    columns  \r\n        \t\t    pharmacy_number varchar2(80) path '//ns:Number',  \r\n        \t\t    pharmacy_qualifier varchar2(2) path '//ns:Qualifier') pharmacy_com  \r\n        \t\t    where pharmacy_com.pharmacy_qualifier = 'TE') pharmacy_phone,  \r\n        \t\t    (select prescriber_com.prescriber_number prescriber_number,  \r\n        \t\t    prescriber_com.prescriber_qualifier prescriber_qualifier,  \r\n        \t\t    t.inbound_ncpdp_msg_id inbound_ncpdp_msg_id  \r\n        \t\t    from erx.inbound_ncpdp_msg t, xmltable(xmlnamespaces('http://www.ncpdp.org/schema/SCRIPT' as \"ns\"), '/ns:Message'  \r\n        \t\t    passing t.message  \r\n        \t\t    columns records XMLTYPE PATH '//ns:Prescriber/ns:CommunicationNumbers') r,  \r\n        \t\t    xmltable(xmlnamespaces('http://www.ncpdp.org/schema/SCRIPT' as \"ns\"),'//ns:Communication'  \r\n        \t\t    passing r.records  \r\n        \t\t    columns  \r\n        \t\t    prescriber_number varchar2(80) path '//ns:Number',  \r\n        \t\t    prescriber_qualifier varchar2(2) path '//ns:Qualifier') prescriber_com  \r\n        \t\t    where prescriber_com.prescriber_qualifier = 'TE') prescriber_phone,  \r\n        \t\t    (select prescriber_com.prescriber_number prescriber_faxnumber,  \r\n        \t\t    prescriber_com.prescriber_qualifier prescriber_qualifier,  \r\n        \t\t    t.inbound_ncpdp_msg_id inbound_ncpdp_msg_id  \r\n        \t\t    from erx.inbound_ncpdp_msg t, xmltable(xmlnamespaces('http://www.ncpdp.org/schema/SCRIPT' as \"ns\"), '/ns:Message'  \r\n        \t\t    passing t.message  \r\n        \t\t    columns records XMLTYPE PATH '//ns:Prescriber/ns:CommunicationNumbers') r,  \r\n        \t\t    xmltable(xmlnamespaces('http://www.ncpdp.org/schema/SCRIPT' as \"ns\"),'//ns:Communication'  \r\n        \t\t    passing r.records  \r\n        \t\t    columns  \r\n        \t\t    prescriber_number varchar2(80) path '//ns:Number',  \r\n        \t\t    prescriber_qualifier varchar2(2) path '//ns:Qualifier') prescriber_com  \r\n        \t\t    where prescriber_com.prescriber_qualifier = 'FX') prescriber_fax,  \r\n\t\t\t\t\t(select benefits.cardholder_id cardholder_id ,  \r\n        \t\t    benefits.groupID groupID, \r\n                   benefits.rx_Pcn,\r\n                   benefits.rx_Bin_Num,\r\n        \t\t    t.inbound_ncpdp_msg_id inbound_ncpdp_msg_id  \r\n        \t\t    from erx.inbound_ncpdp_msg t, xmltable(xmlnamespaces('http://www.ncpdp.org/schema/SCRIPT' as \"ns\"), '/ns:Message'  \r\n        \t\t    passing t.message  \r\n        \t\t    columns \r\n                   rx_Pcn varchar2(35) path '//ns:BenefitsCoordination[1]/ns:PayerIdentification/ns:ProcessorIdentificationNumber',  \r\n        \t\t    rx_Bin_Num varchar2(35) path '//ns:BenefitsCoordination[1]/ns:PayerIdentification/ns:BINLocationNumber',\r\n        \t\t    cardholder_id varchar2(35) path '//ns:BenefitsCoordination[1]/ns:CardholderID',  \r\n        \t\t    groupID varchar2(35) path '//ns:BenefitsCoordination[1]/ns:GroupID') benefits) benefits1 \r\n        \t\t    where t.inbound_ncpdp_msg_id = pharmacy_phone.inbound_ncpdp_msg_id (+)  \r\n        \t\t\tand t.inbound_ncpdp_msg_id = prescriber_fax.inbound_ncpdp_msg_id (+)  \r\n        \t\t    and t.inbound_ncpdp_msg_id = prescriber_phone.inbound_ncpdp_msg_id (+)  \r\n\t\t\t\t\tand t.inbound_ncpdp_msg_id = benefits1.inbound_ncpdp_msg_id (+) \r\n         \t\t    and t.inbound_ncpdp_msg_id = ? " : "select t.outbound_ncpdp_msg_id inbound_ncpdp_msg_id,  \r\n        \t\t  x.message_id rx_messageId,  \r\n        \t\t  x.rel_to_message_id,  \r\n        \t\t  x.message_type,  \r\n\t\t\t\t  (select code_description from erx_status where code = t.message_status) message_status, \r\n        \t\t  to_char(t.received_date,'MM/DD/YYYY') received_date,  \r\n        \t\t  x.pharmacy_name,  \r\n        \t\t  x.pharmacy_addr_1||' '||x.pharmacy_addr_2 pharmacy_addr_1,  \r\n        \t\t  x.pharmacy_city||', '||x.pharmacy_state||'  '||x.pharmacy_zip pharmacy_addr_2,  \r\n        \t\tpharmacy_phone.pharmacy_number pharmacy_phone,  \r\n        \t\tnvl(x.pharmacy_ncpdpid1,x.pharmacy_ncpdpid2) pharmacy_ncpdpid,   \r\n        \t\t  x.prescriber_First_Name,  \r\n        \t\t  x.prescriber_Mid_Name,  \r\n        \t\t  x.prescriber_Last_Name,  \r\n        \t\t  x.prescriber_addr_1||' '||x.prescriber_addr_2 prescriber_addr_1,  \r\n        \t\t  x.prescriber_city||', '||x.prescriber_state||'  '||x.prescriber_zip prescriber_addr_2,  \r\n        \t\t  x.npi1 prescriber_NPI,  \r\n        \t\t  x.npi2 clinic_id,  \r\n        \t\t  x.prescriber_DEA,  \r\n        \t\t  x.prescriber_State_Lic,  \r\n        \t\tprescriber_fax.prescriber_faxnumber prescriber_fax, \r\n        \t\tprescriber_phone.prescriber_number prescriber_phone,  \r\n        \t\t  x.prescriber_agent_first_name||' '||x.prescriber_agent_last_name prescriber_Agent,  \r\n        \t\t  x.patient_First_Name,  \r\n        \t\t  x.patient_Mid_Name,  \r\n        \t\t  x.patient_Last_Name,  \r\n        \t\t  x.patient_addr_1||' '||x.patient_addr_2 patient_addr_1,  \r\n        \t\t  x.patient_city||', '||x.patient_state||'  '||x.patient_zip patient_addr_2,  \r\n        \t\tto_char(to_date(x.patient_dob,'YYYY-MM-DD'),'MM/DD/YYYY') patient_dob,  \r\n        \t\t  x.patient_gender patient_gender,  \r\n        \t\t  benefits1.cardholder_id plan_id,  \r\n        \t\t  x.rx_Drug_Prescribed,  \r\n        \t\t  x.rx_Quantity,  \r\n        \t\t  x.rx_Days_Supply,  \r\n        \t  \tto_char(to_date(x.rx_Date_Written,'YYYY-MM-DD'),'MM/DD/YYYY') rx_Date_Written,  \r\n        \t\t  (select distinct ncit_pref_term from ncpdp_code where ncit_code = x.rx_Potency_Unit_Code) rx_Potency_Unit_Code,  \r\n        \t\t  (select distinct ncit_pref_term from ncpdp_code where ncit_code = x.rx_Drug_Form) rx_Drug_Form,  \r\n        \t\t  x.rx_Drug_Strength||' '||(select distinct ncit_pref_term from ncpdp_code where ncit_code = x.rx_Drug_Strength_Code) rx_Drug_Strength,  \r\n        \t\t  x.rx_Refills,  \r\n        \t\t  x.rx_Sig,\r\n              \t\tdecode(x.rx_Dispense_Notes,'0','0 = No Product Selection Indicated','1','1 = Substitution Not Allowed by Prescriber','2','2 = Substitution Allowed-Patient Requested Product Dispensed','3','3 = Substitution Allowed-Pharmacist Selected Product Dispensed','4','4 = Substitution Allowed-Generic Drug Not in Stock','5','5 = Substitution Allowed-Brand Drug Dispensed as a Generic','6','6 = Override','7','7 = Substitution Not Allowed-Brand Mandated by Law','8','8 = Substitution Allowed-Generic Drug Not Available in Marketplace','9','9 = Substitution Allowed By Prescriber but Plan Requests Brand - Patient''s Plan Requested Brand Product To Be Dispensed') rx_Dispense_Notes,\r\n\t\t\t\t\tx.rx_Comments,  \r\n        \t\t  benefits1.groupID rx_Grp,\r\n        \t\t  benefits1.rx_Bin_Num rx_Bin_Num,  \r\n        \t\t  benefits1.rx_Pcn rx_Pcn, \r\n                 x.res_type, \r\n                 x.req_refno,\r\n                 (select code||':  '||definition from ecl_code where code_type = '1131 \u2013 Code List Qualifier \u2013 Response Code - RES Segment' and code = x.res_aprv_reason_cd) res_aprv_reason_cd, \r\n                 x.res_aprv_refno, \r\n                 x.res_aprv_note, \r\n                 (select code||':  '||definition from ecl_code where code_type = '1131 \u2013 Code List Qualifier \u2013 Response Code - RES Segment' and code = x.res_aprv_w_chng_reason_cd) res_aprv_w_chng_reason_cd, \r\n                 x.res_aprv_w_chng_refno, \r\n                 x.res_aprv_w_chng_note, \r\n                 (select code||':  '||definition from ecl_code where code_type = '1131 \u2013 Code List Qualifier \u2013 Response Code - RES Segment' and code = x.res_denial_reason_cd) res_denial_reason_cd, \r\n                 x.res_denial_refno, \r\n                 x.res_denial_reason, \r\n                 (select code||':  '||definition from ecl_code where code_type = '1131 \u2013 Code List Qualifier \u2013 Response Code - RES Segment' and code = x.res_denial_nrx_reason_cd) res_denial_nrx_reason_cd, \r\n                 x.res_denial_nrx_refno, \r\n                 x.res_denial_nrx_reason,                  x.esv_description_code,                  x.esv_code,                  x.esv_description               from outbound_ncpdp_msg t, xmltable(xmlnamespaces('http://www.ncpdp.org/schema/SCRIPT' as \"ns\"), '/ns:Message'  \r\n        \t\t    passing t.message  \r\n        \t\t    columns   \r\n        \t\t    message_id varchar2(35) path '//ns:Header/ns:MessageID',  \r\n        \t\t    rel_to_message_id varchar2(35) path '//ns:Header/ns:RelatesToMessageID',  \r\n        \t\t    message_type varchar2(35) path 'name(/ns:Body/*[1])',  \r\n        \t\t    pharmacy_name varchar2(35) path '//ns:Pharmacy/ns:StoreName',  \r\n        \t\t    pharmacy_addr_1 varchar2(35) path '//ns:Pharmacy/ns:Address/ns:AddressLine1',  \r\n        \t\t    pharmacy_addr_2 varchar2(35) path '//ns:Pharmacy/ns:Address/ns:AddressLine2',  \r\n        \t\t    pharmacy_city varchar2(35) path '//ns:Pharmacy/ns:Address/ns:City',  \r\n        \t\t    pharmacy_state varchar2(2) path '//ns:Pharmacy/ns:Address/ns:State',  \r\n        \t\t    pharmacy_zip varchar2(14) path '//ns:Pharmacy/ns:Address/ns:ZipCode',  \r\n        \t\t    pharmacy_ncpdpid1 varchar2(35) path '//ns:Pharmacy/ns:Identification/ns:NCPDPID',  \r\n        \t\t    pharmacy_ncpdpid2 varchar2(35) path '//ns:Header/ns:From',  \r\n        \t\t    npi1 varchar2(35) path '//ns:Prescriber/ns:Identification/ns:NPI',  \r\n        \t\t    npi2 varchar2(35) path '//ns:Header/ns:To',  \r\n        \t\t    prescriber_First_Name varchar2(35) path '//ns:Prescriber/ns:Name/ns:FirstName',  \r\n        \t\t    prescriber_Mid_Name varchar2(35) path '//ns:Prescriber/ns:Name/ns:MiddleName',  \r\n        \t\t    prescriber_Last_Name varchar2(35) path '//ns:Prescriber/ns:Name/ns:LastName',  \r\n        \t\t    prescriber_addr_1 varchar2(35) path '//ns:Prescriber/ns:Address/ns:AddressLine1',  \r\n        \t\t    prescriber_addr_2 varchar2(35) path '//ns:Prescriber/ns:Address/ns:AddressLine2',  \r\n        \t\t    prescriber_city varchar2(35) path '//ns:Prescriber/ns:Address/ns:City',  \r\n        \t\t    prescriber_state varchar2(2) path '//ns:Prescriber/ns:Address/ns:State',  \r\n        \t\t    prescriber_zip varchar2(14) path '//ns:Prescriber/ns:Address/ns:ZipCode',  \r\n        \t\t    prescriber_agent_last_name varchar2(35) path '//ns:Prescriber/ns:PrescriberAgent/ns:LastName',  \r\n        \t\t    prescriber_agent_first_name varchar2(35) path '//ns:Prescriber/ns:PrescriberAgent/ns:FirstName',  \r\n        \t\t    prescriber_DEA varchar2(35) path '//ns:Prescriber/ns:Identification/ns:DEANumber',  \r\n        \t\t    prescriber_State_Lic varchar2(35) path '//ns:Prescriber/ns:Identification/ns:StateLicenseNumber',  \r\n        \t\t    patient_First_Name varchar2(35) path '//ns:Patient/ns:Name/ns:FirstName',  \r\n        \t\t    patient_Mid_Name varchar2(35) path '//ns:Patient/ns:Name/ns:MiddleName',  \r\n        \t\t    patient_Last_Name varchar2(35) path '//ns:Patient/ns:Name/ns:LastName',  \r\n        \t\t    patient_addr_1 varchar2(35) path '//ns:Patient/ns:Address/ns:AddressLine1',  \r\n        \t\t    patient_addr_2 varchar2(35) path '//ns:Patient/ns:Address/ns:AddressLine2',  \r\n        \t\t    patient_city varchar2(35) path '//ns:Patient/ns:Address/ns:City',  \r\n        \t\t    patient_state varchar2(2) path '//ns:Patient/ns:Address/ns:State',  \r\n        \t\t    patient_zip varchar2(14) path '//ns:Patient/ns:Address/ns:ZipCode',  \r\n        \t\t    patient_dob varchar2(30) path '//ns:Patient/ns:DateOfBirth/ns:Date',  \r\n        \t\t    patient_gender varchar2(1) path '//ns:Patient/ns:Gender',  \r\n        \t\t    rx_Drug_Prescribed varchar2(105) path '//ns:MedicationPrescribed/ns:DrugDescription',  \r\n        \t\t    rx_Quantity varchar2(30) path '//ns:MedicationPrescribed/ns:Quantity/ns:Value',  \r\n        \t\t    rx_Days_Supply varchar2(30) path '//ns:MedicationPrescribed/ns:DaysSupply',  \r\n        \t\t    rx_Date_Written varchar2(30) path '//ns:MedicationPrescribed/ns:WrittenDate',  \r\n        \t\t    rx_Potency_Unit_Code varchar2(30) path '//ns:MedicationPrescribed/ns:Quantity/ns:PotencyUnitCode',  \r\n        \t\t    rx_Drug_Form varchar2(30) path '//ns:MedicationPrescribed/ns:DrugCoded/ns:FormCode',  \r\n        \t\t    rx_Drug_Strength varchar2(70) path '//ns:MedicationPrescribed/ns:DrugCoded/ns:Strength',  \r\n\t\t\t\t\trx_Drug_Strength_Code varchar2(30) path '//ns:MedicationPrescribed/ns:DrugCoded/ns:StrengthCode',  \r\n        \t\t    rx_Refills varchar2(2) path '//ns:MedicationPrescribed/ns:Refills/ns:Value',  \r\n        \t\t    rx_Sig varchar2(140) path '//ns:MedicationPrescribed/ns:Directions',  \r\n        \t\t    rx_Dispense_Notes varchar2(35) path '//ns:MedicationPrescribed/ns:Substitutions',  \r\n        \t\t    rx_Comments varchar2(210) path '//ns:MedicationPrescribed/ns:Note',  \r\n             \t\tres_type varchar2(70) path 'name(/ns:Body/*/ns:Response/*[1])', \r\n             \t\treq_refno varchar2(70) path '//ns:Request/ns:Request/ns:ReferenceNumber',\r\n             \t\tres_aprv_reason_cd varchar2(70) path '//ns:Response/ns:Approved/ns:ApprovalReasonCode[1]',\r\n             \t\tres_aprv_refno varchar2(70) path '//ns:Response/ns:Approved/ns:ReferenceNumber',\r\n             \t\tres_aprv_note varchar2(70) path '//ns:Response/ns:Approved/ns:Note',\r\n             \t\tres_aprv_w_chng_reason_cd varchar2(70) path '//ns:Response/ns:ApprovedWithChanges/ns:DenialReasonCode[1]',\r\n             \t\tres_aprv_w_chng_refno varchar2(70) path '//ns:Response/ns:ApprovedWithChanges/ns:ReferenceNumber',\r\n             \t\tres_aprv_w_chng_note varchar2(70) path '//ns:Response/ns:ApprovedWithChanges/ns:Note',\r\n             \t\tres_denial_reason_cd varchar2(70) path '//ns:Response/ns:Denied/ns:DenialReasonCode[1]',\r\n             \t\tres_denial_refno varchar2(70) path '//ns:Response/ns:Denied/ns:ReferenceNumber',\r\n              \t\tres_denial_reason varchar2(70) path '//ns:Response/ns:Denied/ns:DenialReason',\r\n              \t\tres_denial_nrx_reason_cd varchar2(70) path '//ns:Response/ns:DeniedNewPrescriptionToFollow/ns:DenialReasonCode[1]',\r\n              \t\tres_denial_nrx_refno varchar2(70) path '//ns:Response/ns:DeniedNewPrescriptionToFollow/ns:ReferenceNumber',\r\n              \t\tres_denial_nrx_reason varchar2(70) path '//ns:Response/ns:DeniedNewPrescriptionToFollow/ns:DenialReason' ,\r\n              \t\tesv_description_code varchar2(70) path '//ns:DescriptionCode[1]',\r\n              \t\tesv_code varchar2(70) path '//ns:Code',\r\n              \t\tesv_description varchar2(70) path '//ns:Description' \r\n        \t\t    ) x,  \r\n        \t\t    (select pharmacy_com.pharmacy_number pharmacy_number,  \r\n        \t\t    pharmacy_com.pharmacy_qualifier pharmacy_qualifier,  \r\n        \t\t    t.outbound_ncpdp_msg_id outbound_ncpdp_msg_id  \r\n        \t\t    from outbound_ncpdp_msg t, xmltable(xmlnamespaces('http://www.ncpdp.org/schema/SCRIPT' as \"ns\"), '/ns:Message'  \r\n        \t\t    passing t.message  \r\n        \t\t    columns records XMLTYPE PATH '//ns:Pharmacy/ns:CommunicationNumbers') r,  \r\n        \t\t    xmltable(xmlnamespaces('http://www.ncpdp.org/schema/SCRIPT' as \"ns\"),'//ns:Communication'  \r\n        \t\t    passing r.records  \r\n        \t\t    columns  \r\n        \t\t    pharmacy_number varchar2(80) path '//ns:Number',  \r\n        \t\t    pharmacy_qualifier varchar2(2) path '//ns:Qualifier') pharmacy_com  \r\n        \t\t    where pharmacy_com.pharmacy_qualifier = 'TE') pharmacy_phone,  \r\n        \t\t    (select prescriber_com.prescriber_number prescriber_number,  \r\n        \t\t    prescriber_com.prescriber_qualifier prescriber_qualifier,  \r\n        \t\t    t.outbound_ncpdp_msg_id outbound_ncpdp_msg_id  \r\n        \t\t    from outbound_ncpdp_msg t, xmltable(xmlnamespaces('http://www.ncpdp.org/schema/SCRIPT' as \"ns\"), '/ns:Message'  \r\n        \t\t    passing t.message  \r\n        \t\t    columns records XMLTYPE PATH '//ns:Prescriber/ns:CommunicationNumbers') r,  \r\n        \t\t    xmltable(xmlnamespaces('http://www.ncpdp.org/schema/SCRIPT' as \"ns\"),'//ns:Communication'  \r\n        \t\t    passing r.records  \r\n        \t\t    columns  \r\n        \t\t    prescriber_number varchar2(80) path '//ns:Number',  \r\n        \t\t    prescriber_qualifier varchar2(2) path '//ns:Qualifier') prescriber_com  \r\n        \t\t    where prescriber_com.prescriber_qualifier = 'TE') prescriber_phone,  \r\n        \t\t    (select prescriber_com.prescriber_number prescriber_faxnumber,  \r\n        \t\t    prescriber_com.prescriber_qualifier prescriber_qualifier,  \r\n        \t\t    t.outbound_ncpdp_msg_id outbound_ncpdp_msg_id  \r\n        \t\t    from outbound_ncpdp_msg t, xmltable(xmlnamespaces('http://www.ncpdp.org/schema/SCRIPT' as \"ns\"), '/ns:Message'  \r\n        \t\t    passing t.message  \r\n        \t\t    columns records XMLTYPE PATH '//ns:Prescriber/ns:CommunicationNumbers') r,  \r\n        \t\t    xmltable(xmlnamespaces('http://www.ncpdp.org/schema/SCRIPT' as \"ns\"),'//ns:Communication'  \r\n        \t\t    passing r.records  \r\n        \t\t    columns  \r\n        \t\t    prescriber_number varchar2(80) path '//ns:Number',  \r\n        \t\t    prescriber_qualifier varchar2(2) path '//ns:Qualifier') prescriber_com  \r\n        \t\t    where prescriber_com.prescriber_qualifier = 'FX') prescriber_fax,  \r\n\t\t\t\t\t(select benefits.cardholder_id cardholder_id ,  \r\n        \t\t    benefits.groupID groupID, \r\n                   benefits.rx_Pcn,\r\n                   benefits.rx_Bin_Num,\r\n        \t\t    t.outbound_ncpdp_msg_id outbound_ncpdp_msg_id  \r\n        \t\t    from outbound_ncpdp_msg t, xmltable(xmlnamespaces('http://www.ncpdp.org/schema/SCRIPT' as \"ns\"), '/ns:Message'  \r\n        \t\t    passing t.message  \r\n        \t\t    columns \r\n                   rx_Pcn varchar2(35) path '//ns:BenefitsCoordination[1]/ns:PayerIdentification/ns:ProcessorIdentificationNumber',  \r\n        \t\t    rx_Bin_Num varchar2(35) path '//ns:BenefitsCoordination[1]/ns:PayerIdentification/ns:BINLocationNumber',\r\n        \t\t    cardholder_id varchar2(35) path '//ns:BenefitsCoordination[1]/ns:CardholderID',  \r\n        \t\t    groupID varchar2(35) path '//ns:BenefitsCoordination[1]/ns:GroupID') benefits) benefits1 \r\n        \t\t    where t.outbound_ncpdp_msg_id = pharmacy_phone.outbound_ncpdp_msg_id (+)  \r\n        \t\t\tand t.outbound_ncpdp_msg_id = prescriber_fax.outbound_ncpdp_msg_id (+)  \r\n        \t\t    and t.outbound_ncpdp_msg_id = prescriber_phone.outbound_ncpdp_msg_id (+)  \r\n\t\t\t\t\tand t.outbound_ncpdp_msg_id = benefits1.outbound_ncpdp_msg_id (+) \r\n         \t\t    and t.outbound_ncpdp_msg_id = ? ";
        try {
            LOG.info("Retrieving NCPDP message details.");
            this.ncpdpMsg = (NcpdpMessageModel)jdbcTemplate.queryForObject(sql, new Object[]{id}, (RowMapper)new NcpdpMsgRowMapper());
        }
        catch (DataAccessException e) {
            this.ncpdpMsg.setDataError(e.getMessage());
            LOG.info("Exception retrieving NCPDP message details." + e.getMessage());
        }
        return this.ncpdpMsg;
    }

    @Override
    public List<NcpdpMessageListModel> searchMessages(String messageType, String messageId, String relatesToId, String visn, String vaStationId, String fromDate, String toDate, String patientSsn, String patientLastName, String patientFirstName, String patientDob, String prescriberNpi, String prescribedDrug, String messageStatus, String inboundNcpdpMsgId, String inboundOutbound) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        String sql = "";
        sql = inboundOutbound.equalsIgnoreCase("Inbound") ? "select t.inbound_ncpdp_msg_id inbound_ncpdp_msg_id,\r\nx.pharmacy_name pharmacy_name,\r\nx.pharmacy_addr_1||' '||x.pharmacy_addr_2||' '||x.pharmacy_city||nvl2(x.pharmacy_city,nvl2(x.pharmacy_state,', ',null),null)||x.pharmacy_state||' '||x.pharmacy_zip pharmacy_addr_1,\r\nx.patient_Last_Name||nvl2(x.patient_Last_Name,nvl2(x.patient_First_Name,', ',null),null)||x.patient_First_Name||' '||x.patient_Mid_Name patient_Name,\r\nx.prescriber_Last_Name||nvl2(x.prescriber_Last_Name,nvl2(x.prescriber_First_Name,', ',null),null)||x.prescriber_First_Name||' '||x.prescriber_Mid_Name prescriber_Name,\r\nx.rx_Drug_Prescribed rx_Drug_Prescribed,\r\nt.message_type message_type,\r\nt.rel_to_message_id rel_to_message_id,\r\nt.message_id rx_messageId,\r\nt.received_date received_date,\r\n(select code_description from erx_status where code = t.patient_chk_status) patient_chk_status,\r\n(select code_description from erx_status where code = t.provider_chk_status) provider_chk_status,\r\n(select code_description from erx_status where code = t.drug_chk_status) drug_chk_status,\r\n(select code_description from erx_status where code = t.message_status) message_status\r\nfrom inbound_ncpdp_msg t, xmltable(xmlnamespaces('http://www.ncpdp.org/schema/SCRIPT' as \"ns\"), '/ns:Message'\r\n    passing t.message\r\n    columns \r\n    message_id varchar2(35) path '//ns:Header/ns:MessageID',\r\n    rel_to_message_id varchar2(35) path '//ns:Header/ns:RelatesToMessageID',\r\n    message_type varchar2(35) path 'name(/ns:Body/*[1])',\r\n    pharmacy_name varchar2(30) path '//ns:Pharmacy/ns:StoreName',\r\n    pharmacy_addr_1 varchar2(30) path '//ns:Pharmacy/ns:Address/ns:AddressLine1',\r\n    pharmacy_addr_2 varchar2(30) path '//ns:Pharmacy/ns:Address/ns:AddressLine2',\r\n    pharmacy_city varchar2(30) path '//ns:Pharmacy/ns:Address/ns:City',\r\n    pharmacy_state varchar2(30) path '//ns:Pharmacy/ns:Address/ns:State',\r\n    pharmacy_zip varchar2(30) path '//ns:Pharmacy/ns:Address/ns:ZipCode',\r\n\t npi1 varchar2(35) path '//ns:Prescriber/ns:Identification/ns:NPI',\r\n    npi2 varchar2(35) path '//ns:Header/ns:From',\r\n    prescriber_First_Name varchar2(35) path '//ns:Prescriber/ns:Name/ns:FirstName',\r\n    prescriber_Mid_Name varchar2(35) path '//ns:Prescriber/ns:Name/ns:MiddleName',\r\n    prescriber_Last_Name varchar2(35) path '//ns:Prescriber/ns:Name/ns:LastName',\r\n    patient_First_Name varchar2(35) path '//ns:Patient/ns:Name/ns:FirstName',\r\n    patient_Mid_Name varchar2(35) path '//ns:Patient/ns:Name/ns:MiddleName',\r\n    patient_Last_Name varchar2(35) path '//ns:Patient/ns:Name/ns:LastName',\r\n    patient_addr_1 varchar2(30) path '//ns:Patient/ns:Address/ns:AddressLine1',\r\n    patient_addr_2 varchar2(30) path '//ns:Patient/ns:Address/ns:AddressLine2',\r\n    patient_city varchar2(30) path '//ns:Patient/ns:Address/ns:City',\r\n    patient_state varchar2(30) path '//ns:Patient/ns:Address/ns:State',\r\n    patient_zip varchar2(30) path '//ns:Patient/ns:Address/ns:ZipCode',\r\n    patient_dob date path '//ns:Patient/ns:DateOfBirth/ns:Date',\r\n    patient_ssn varchar2(11) path '//ns:Patient/ns:Identification/ns:SocialSecurity',\r\n    plan_id varchar2(30) path '//ns:Patient/ns:BenefitsCoordination/ns:CardholderID',\r\n    rx_Drug_Prescribed varchar2(30) path '//ns:MedicationPrescribed/ns:DrugDescription'\r\n    ) x\r\n" : "select t.outbound_ncpdp_msg_id inbound_ncpdp_msg_id,\r\nx.pharmacy_name pharmacy_name,\r\nx.pharmacy_addr_1||' '||x.pharmacy_addr_2||' '||x.pharmacy_city||nvl2(x.pharmacy_city,nvl2(x.pharmacy_state,', ',null),null)||x.pharmacy_state||' '||x.pharmacy_zip pharmacy_addr_1,\r\nx.patient_Last_Name||nvl2(x.patient_Last_Name,nvl2(x.patient_First_Name,', ',null),null)||x.patient_First_Name||' '||x.patient_Mid_Name patient_Name,\r\nx.prescriber_Last_Name||nvl2(x.prescriber_Last_Name,nvl2(x.prescriber_First_Name,', ',null),null)||x.prescriber_First_Name||' '||x.prescriber_Mid_Name prescriber_Name,\r\nx.rx_Drug_Prescribed rx_Drug_Prescribed,\r\nt.message_type message_type,\r\nt.rel_to_message_id rel_to_message_id,\r\nt.message_id rx_messageId,\r\nt.received_date received_date,\r\n'N/A' patient_chk_status,\r\n'N/A' provider_chk_status,\r\n'N/A' drug_chk_status,\r\n(select code_description from erx_status where code = t.message_status) message_status\r\nfrom outbound_ncpdp_msg t, xmltable(xmlnamespaces('http://www.ncpdp.org/schema/SCRIPT' as \"ns\"), '/ns:Message'\r\n    passing t.message\r\n    columns \r\n    message_id varchar2(35) path '//ns:Header/ns:MessageID',\r\n    rel_to_message_id varchar2(35) path '//ns:Header/ns:RelatesToMessageID',\r\n    message_type varchar2(35) path 'name(/ns:Body/*[1])',\r\n    pharmacy_name varchar2(30) path '//ns:Pharmacy/ns:StoreName',\r\n    pharmacy_addr_1 varchar2(30) path '//ns:Pharmacy/ns:Address/ns:AddressLine1',\r\n    pharmacy_addr_2 varchar2(30) path '//ns:Pharmacy/ns:Address/ns:AddressLine2',\r\n    pharmacy_city varchar2(30) path '//ns:Pharmacy/ns:Address/ns:City',\r\n    pharmacy_state varchar2(30) path '//ns:Pharmacy/ns:Address/ns:State',\r\n    pharmacy_zip varchar2(30) path '//ns:Pharmacy/ns:Address/ns:ZipCode',\r\n\t npi1 varchar2(35) path '//ns:Prescriber/ns:Identification/ns:NPI',\r\n    npi2 varchar2(35) path '//ns:Header/ns:From',\r\n    prescriber_First_Name varchar2(35) path '//ns:Prescriber/ns:Name/ns:FirstName',\r\n    prescriber_Mid_Name varchar2(35) path '//ns:Prescriber/ns:Name/ns:MiddleName',\r\n    prescriber_Last_Name varchar2(35) path '//ns:Prescriber/ns:Name/ns:LastName',\r\n    patient_First_Name varchar2(35) path '//ns:Patient/ns:Name/ns:FirstName',\r\n    patient_Mid_Name varchar2(35) path '//ns:Patient/ns:Name/ns:MiddleName',\r\n    patient_Last_Name varchar2(35) path '//ns:Patient/ns:Name/ns:LastName',\r\n    patient_addr_1 varchar2(30) path '//ns:Patient/ns:Address/ns:AddressLine1',\r\n    patient_addr_2 varchar2(30) path '//ns:Patient/ns:Address/ns:AddressLine2',\r\n    patient_city varchar2(30) path '//ns:Patient/ns:Address/ns:City',\r\n    patient_state varchar2(30) path '//ns:Patient/ns:Address/ns:State',\r\n    patient_zip varchar2(30) path '//ns:Patient/ns:Address/ns:ZipCode',\r\n    patient_dob date path '//ns:Patient/ns:DateOfBirth/ns:Date',\r\n    patient_ssn varchar2(11) path '//ns:Patient/ns:Identification/ns:SocialSecurity',\r\n    plan_id varchar2(30) path '//ns:Patient/ns:BenefitsCoordination/ns:CardholderID',\r\n    rx_Drug_Prescribed varchar2(30) path '//ns:MedicationPrescribed/ns:DrugDescription'\r\n    ) x\r\n";
        sql = sql + "    where t.message_id like ? \r\n" + "    and nvl(t.rel_to_message_id,' ') like ? \r\n" + "    and t.RECEIVED_DATE between to_date('" + fromDate + "','YYYY-MM-DD') and to_date('" + toDate + "','YYYY-MM-DD') + 1\r\n";
        if (messageType != "") {
            sql = sql + "    and t.message_type = '" + messageType + "' \r\n";
        }
        sql = messageStatus != "" ? sql + "    and t.message_status = '" + messageStatus + "' \r\n" : sql + "    and t.message_status not in ('3006') \r\n";
        if (visn != "") {
            sql = sql + "    and t.pharmacy_id in (select pharmacy_id from pharmacy where visn = '" + visn + "')\r\n";
        }
        sql = sql + "    and t.pharmacy_id in (select pharmacy_id from pharmacy where va_station_id like ? ) \r\n";
        if (patientSsn != "") {
            sql = sql + " and x.patient_ssn = '" + patientSsn + "'\r\n";
        }
        sql = sql + "    and nvl(upper(x.patient_last_name),' ') like ?\r\n" + "    and nvl(upper(x.patient_first_name),' ') like ?\r\n";
        if (patientDob != "") {
            sql = sql + " and x.patient_dob = to_date('" + patientDob + "','YYYY-MM-DD') \r\n";
        }
        sql = sql + "    and nvl(x.npi1, ' ') like ? \r\n" + "    and nvl(upper(x.rx_Drug_Prescribed),' ') like ? \r\n";
        sql = inboundOutbound.equalsIgnoreCase("Inbound") ? sql + "    and t.inbound_ncpdp_msg_id like ? \r\n" : sql + "    and t.outbound_ncpdp_msg_id like ? \r\n";
        sql = sql + "\t order by t.RECEIVED_DATE DESC";
        List<NcpdpMessageListModel> ncpdpMsgList = new ArrayList<NcpdpMessageListModel>();
        try {
            ncpdpMsgList = jdbcTemplate.query(sql, (RowMapper)new NcpdpMsgListRowMapper(), new Object[]{messageId, relatesToId, vaStationId, patientLastName, patientFirstName, prescriberNpi, prescribedDrug, inboundNcpdpMsgId});
        }
        catch (DataAccessException e) {
            LOG.info("Exception retrieving NCPDP message details." + e.getMessage());
        }
        return ncpdpMsgList;
    }

    public class NcpdpMsgRowMapper
    implements RowMapper<NcpdpMessageModel> {
        public NcpdpMessageModel mapRow(ResultSet rs, int rowNum) throws SQLException {
            NcpdpMessageModel ncpdpMessageModel = new NcpdpMessageModel();
            ncpdpMessageModel.setInboundNcpdpMsgId(Long.parseUnsignedLong(rs.getString("inbound_ncpdp_msg_id")));
            ncpdpMessageModel.setRxMessageId(rs.getString("rx_messageId"));
            ncpdpMessageModel.setRelToMessageid(rs.getString("rel_to_message_id"));
            ncpdpMessageModel.setMessage_status(rs.getString("message_status"));
            ncpdpMessageModel.setMessageType(rs.getString("message_type"));
            ncpdpMessageModel.setReceivedDate(rs.getString("received_date"));
            ncpdpMessageModel.setPharmacyName(rs.getString("pharmacy_name"));
            ncpdpMessageModel.setPharmacyAddr1(rs.getString("pharmacy_addr_1"));
            ncpdpMessageModel.setPharmacyAddr2(rs.getString("pharmacy_addr_2"));
            ncpdpMessageModel.setPharmacyPhone(rs.getString("pharmacy_phone"));
            ncpdpMessageModel.setPharmacyNcpdpid(rs.getString("pharmacy_ncpdpid"));
            ncpdpMessageModel.setPrescriberFirstName(rs.getString("prescriber_First_Name"));
            ncpdpMessageModel.setPrescriberMidName(rs.getString("prescriber_Mid_Name"));
            ncpdpMessageModel.setPrescriberLastName(rs.getString("prescriber_Last_Name"));
            ncpdpMessageModel.setPrescriberAddr1(rs.getString("prescriber_addr_1"));
            ncpdpMessageModel.setPrescriberAddr2(rs.getString("prescriber_addr_2"));
            ncpdpMessageModel.setPrescriberNPI(rs.getString("prescriber_NPI"));
            ncpdpMessageModel.setPrescriberDEA(rs.getString("prescriber_DEA"));
            ncpdpMessageModel.setPrescriberStateLic(rs.getString("prescriber_State_Lic"));
            ncpdpMessageModel.setPrescriberPhone(rs.getString("prescriber_phone"));
            ncpdpMessageModel.setPrescriberFax(rs.getString("prescriber_fax"));
            ncpdpMessageModel.setPrescriberAgent(rs.getString("prescriber_Agent"));
            ncpdpMessageModel.setPatientFirstName(rs.getString("patient_First_Name"));
            ncpdpMessageModel.setPatientMidName(rs.getString("patient_Mid_Name"));
            ncpdpMessageModel.setPatientLastName(rs.getString("patient_Last_Name"));
            ncpdpMessageModel.setPatientAddr1(rs.getString("patient_addr_1"));
            ncpdpMessageModel.setPatientAddr2(rs.getString("patient_addr_2"));
            ncpdpMessageModel.setPatientDob(rs.getString("patient_dob"));
            ncpdpMessageModel.setPatientGender(rs.getString("patient_gender"));
            ncpdpMessageModel.setRxDrugPrescribed(rs.getString("rx_Drug_Prescribed"));
            ncpdpMessageModel.setRxQuantity(rs.getString("rx_Quantity"));
            ncpdpMessageModel.setRxDaysSupply(rs.getString("rx_Days_Supply"));
            ncpdpMessageModel.setRxDateWritten(rs.getString("rx_Date_Written"));
            ncpdpMessageModel.setRxPotencyUnitCode(rs.getString("rx_Potency_Unit_Code"));
            ncpdpMessageModel.setRxDrugForm(rs.getString("rx_Drug_Form"));
            ncpdpMessageModel.setRxDrugStrength(rs.getString("rx_Drug_Strength"));
            ncpdpMessageModel.setRxRefills(rs.getString("rx_Refills"));
            ncpdpMessageModel.setRxSig(rs.getString("rx_Sig"));
            ncpdpMessageModel.setRxDispenseNotes(rs.getString("rx_Dispense_Notes"));
            ncpdpMessageModel.setRxComments(rs.getString("rx_Comments"));
            ncpdpMessageModel.setPlanId(rs.getString("plan_id"));
            ncpdpMessageModel.setRxGrp(rs.getString("rx_Grp"));
            ncpdpMessageModel.setRxBinNum(rs.getString("rx_Bin_Num"));
            ncpdpMessageModel.setRxPcn(rs.getString("rx_Pcn"));
            ncpdpMessageModel.setReqRefno(rs.getString("req_refno"));
            ncpdpMessageModel.setResType(rs.getString("res_type"));
            ncpdpMessageModel.setResAprvReasonCd(rs.getString("res_aprv_reason_cd"));
            ncpdpMessageModel.setResAprvRefno(rs.getString("res_aprv_refno"));
            ncpdpMessageModel.setResAprvNote(rs.getString("res_aprv_note"));
            ncpdpMessageModel.setResAprvWthChngReasonCd(rs.getString("res_aprv_w_chng_reason_cd"));
            ncpdpMessageModel.setResAprvWthChngRefno(rs.getString("res_aprv_w_chng_refno"));
            ncpdpMessageModel.setResAprvWthChngNote(rs.getString("res_aprv_w_chng_note"));
            ncpdpMessageModel.setResDenialReasonCd(rs.getString("res_denial_reason_cd"));
            ncpdpMessageModel.setResDenialRefno(rs.getString("res_denial_refno"));
            ncpdpMessageModel.setResDenialReason(rs.getString("res_denial_reason"));
            ncpdpMessageModel.setResDenialNrxReasonCd(rs.getString("res_denial_nrx_reason_cd"));
            ncpdpMessageModel.setResDenialNrxRefno(rs.getString("res_denial_nrx_refno"));
            ncpdpMessageModel.setResDenialNrxReason(rs.getString("res_denial_nrx_reason"));
            ncpdpMessageModel.setEsvDescriptionCode(rs.getString("esv_description_code"));
            ncpdpMessageModel.setEsvCode(rs.getString("esv_code"));
            ncpdpMessageModel.setEsvDescription(rs.getString("esv_description"));
            ncpdpMessageModel.setClinicId(rs.getString("clinic_id"));
            return ncpdpMessageModel;
        }
    }

    public class NcpdpMsgListRowMapper
    implements RowMapper<NcpdpMessageListModel> {
        public NcpdpMessageListModel mapRow(ResultSet rs, int rowNum) throws SQLException {
            NcpdpMessageListModel ncpdpMessageListModel = new NcpdpMessageListModel();
            ncpdpMessageListModel.setInboundNcpdpMsgId(Long.parseUnsignedLong(rs.getString("inbound_ncpdp_msg_id")));
            ncpdpMessageListModel.setRxMessageId(rs.getString("rx_messageId"));
            ncpdpMessageListModel.setRelToMessageid(rs.getString("rel_to_message_id"));
            ncpdpMessageListModel.setMessageType(rs.getString("message_type"));
            ncpdpMessageListModel.setReceivedDate(rs.getString("received_date"));
            ncpdpMessageListModel.setPharmacyName(rs.getString("pharmacy_name"));
            ncpdpMessageListModel.setPharmacyAddr1(rs.getString("pharmacy_addr_1"));
            ncpdpMessageListModel.setPrescriberName(rs.getString("prescriber_Name"));
            ncpdpMessageListModel.setPatientName(rs.getString("patient_Name"));
            ncpdpMessageListModel.setRxDrugPrescribed(rs.getString("rx_Drug_Prescribed"));
            ncpdpMessageListModel.setPatient_chk_status(rs.getString("patient_chk_status"));
            ncpdpMessageListModel.setProvider_chk_status(rs.getString("provider_chk_status"));
            ncpdpMessageListModel.setDrug_chk_status(rs.getString("drug_chk_status"));
            ncpdpMessageListModel.setMessage_status(rs.getString("message_status"));
            return ncpdpMessageListModel;
        }
    }
}

