/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.pharmacy.persistence.service.impl;

import gov.va.med.pharmacy.persistence.dao.PharmacyDao;
import gov.va.med.pharmacy.persistence.managepharmacy.ManagePharmacyFilter;
import gov.va.med.pharmacy.persistence.model.PharmacyEntity;
import gov.va.med.pharmacy.persistence.service.PharmacyService;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.HibernateException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pharmacyService")
@Transactional
public class PharmacyServiceImpl
implements PharmacyService {
    private static final Logger LOG = LogManager.getLogger(PharmacyServiceImpl.class);
    @Autowired
    private PharmacyDao pharmacyDao;

    @Override
    public List<PharmacyEntity> find(ManagePharmacyFilter managePharmacyFilter) {
        return this.pharmacyDao.find(managePharmacyFilter);
    }

    @Override
    public PharmacyEntity findByNCPDPId(String NCPDPId) {
        return this.pharmacyDao.findByNCPDPId(NCPDPId);
    }

    @Override
    public void savePharmacyInfo(PharmacyEntity pharmacy) throws HibernateException {
        try {
            this.pharmacyDao.save(pharmacy);
        }
        catch (HibernateException e) {
            throw new HibernateException((Throwable)e);
        }
        LOG.info("saved pharmacy information.");
    }

    @Override
    public PharmacyEntity findById(Long pharmacyId) throws Exception {
        try {
            return this.pharmacyDao.findById(pharmacyId);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Override
    public void updatePharmacyInfo(PharmacyEntity pharmacy) throws HibernateException {
        try {
            this.pharmacyDao.updatePharmacyInfo(pharmacy);
        }
        catch (HibernateException e) {
            throw new HibernateException((Throwable)e);
        }
        LOG.info("updated pharmacy information.");
    }
}

